/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.MethodYield;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;

public class MethodBehavior {
    private final Symbol.MethodSymbol methodSymbol;
    private final Set<MethodYield> yields;
    private final List<SymbolicValue> parameters;
    private boolean complete = false;

    public MethodBehavior(Symbol.MethodSymbol methodSymbol) {
        this.methodSymbol = methodSymbol;
        this.yields = new LinkedHashSet<MethodYield>();
        this.parameters = new ArrayList<SymbolicValue>();
    }

    public void createYield(ExplodedGraph.Node node) {
        MethodYield yield = new MethodYield(this.parameters.size(), ((JavaSymbol.MethodJavaSymbol)this.methodSymbol).isVarArgs(), node, this);
        yield.exception = !node.happyPath;
        for (int i = 0; i < yield.parametersConstraints.length; ++i) {
            yield.parametersConstraints[i] = node.programState.getConstraint(this.parameters.get(i));
        }
        SymbolicValue resultSV = node.programState.exitValue();
        if (resultSV instanceof SymbolicValue.ExceptionalSymbolicValue) {
            yield.exception = true;
            yield.exceptionType = ((SymbolicValue.ExceptionalSymbolicValue)resultSV).exceptionType();
        } else if (!this.isConstructor() && !this.isVoidMethod()) {
            if (resultSV == null) {
                yield.exception = true;
            } else {
                yield.resultIndex = this.parameters.indexOf(resultSV);
                yield.resultConstraint = node.programState.getConstraint(resultSV);
            }
        }
        this.yields.add(yield);
    }

    private boolean isVoidMethod() {
        return this.methodSymbol.returnType().type().isVoid();
    }

    private boolean isConstructor() {
        return ((JavaSymbol.MethodJavaSymbol)this.methodSymbol).isConstructor();
    }

    List<MethodYield> yields() {
        return ImmutableList.builder().addAll(this.yields).build();
    }

    Stream<MethodYield> exceptionalPathYields() {
        return this.yields.stream().filter(y -> y.exception);
    }

    Stream<MethodYield> happyPathYields() {
        return this.yields.stream().filter(y -> !y.exception);
    }

    public void addParameter(SymbolicValue sv) {
        this.parameters.add(sv);
    }

    public List<SymbolicValue> parameters() {
        return this.parameters;
    }

    public boolean isComplete() {
        return this.complete;
    }

    void completed() {
        this.complete = true;
    }

    void addYield(MethodYield yield) {
        this.yields.add(yield);
    }
}

