/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.MethodBehavior;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;

public class MethodYield {
    private final boolean varArgs;
    private final ExplodedGraph.Node node;
    private final MethodBehavior behavior;
    Constraint[] parametersConstraints;
    int resultIndex;
    @Nullable
    Constraint resultConstraint;
    @Nullable
    Type exceptionType;
    boolean exception;

    public MethodYield(int arity, boolean varArgs, ExplodedGraph.Node node, MethodBehavior behavior) {
        this.parametersConstraints = new Constraint[arity];
        this.varArgs = varArgs;
        this.node = node;
        this.behavior = behavior;
        this.resultIndex = -1;
        this.resultConstraint = null;
        this.exception = false;
        this.exceptionType = null;
    }

    public MethodYield(int arity, boolean varArgs) {
        this.parametersConstraints = new Constraint[arity];
        this.varArgs = varArgs;
        this.node = null;
        this.behavior = null;
        this.resultIndex = -1;
        this.resultConstraint = null;
        this.exception = false;
        this.exceptionType = null;
    }

    public String toString() {
        return String.format("{params: %s, result: %s (%d), exceptional: %b%s}", Arrays.toString(this.parametersConstraints), this.resultConstraint, this.resultIndex, this.exception, this.exceptionType == null ? "" : " (" + this.exceptionType + ")");
    }

    public Stream<ProgramState> statesAfterInvocation(List<SymbolicValue> invocationArguments, List<Type> invocationTypes, ProgramState programState, Supplier<SymbolicValue> svSupplier) {
        Set<ProgramState> results = new LinkedHashSet<ProgramState>();
        for (int index = 0; index < invocationArguments.size(); ++index) {
            Constraint constraint = this.getConstraint(index, invocationTypes);
            if (constraint == null) continue;
            SymbolicValue invokedArg = invocationArguments.get(index);
            Set<ProgramState> programStates = MethodYield.programStatesForConstraint(results.isEmpty() ? Lists.newArrayList((Object[])new ProgramState[]{programState}) : results, invokedArg, constraint);
            if (programStates.isEmpty()) {
                return Stream.empty();
            }
            results = programStates;
        }
        if (results.isEmpty()) {
            results.add(programState);
        }
        SymbolicValue sv = this.resultIndex < 0 ? svSupplier.get() : invocationArguments.get(this.resultIndex);
        Stream<ProgramState> stateStream = results.stream().map(s -> s.stackValue(sv));
        if (this.resultConstraint != null) {
            stateStream = stateStream.map(s -> s.addConstraint(sv, this.resultConstraint));
        }
        return stateStream.distinct();
    }

    @CheckForNull
    private Constraint getConstraint(int index, List<Type> invocationTypes) {
        if (!this.varArgs || this.applicableOnVarArgs(index, invocationTypes)) {
            return this.parametersConstraints[index];
        }
        return null;
    }

    private boolean applicableOnVarArgs(int index, List<Type> types) {
        if (index < this.parametersConstraints.length - 1) {
            return true;
        }
        if (this.parametersConstraints.length != types.size()) {
            return false;
        }
        Type argumentType = types.get(index);
        return argumentType.isArray() || argumentType.is("<nulltype>");
    }

    private static Set<ProgramState> programStatesForConstraint(Collection<ProgramState> states, SymbolicValue invokedArg, Constraint constraint) {
        LinkedHashSet<ProgramState> programStates = new LinkedHashSet<ProgramState>();
        if (constraint instanceof ObjectConstraint) {
            ObjectConstraint objectConstraint = (ObjectConstraint)constraint;
            states.forEach(state -> programStates.addAll(invokedArg.setConstraint((ProgramState)state, objectConstraint)));
        } else if (constraint instanceof BooleanConstraint) {
            BooleanConstraint booleanConstraint = (BooleanConstraint)constraint;
            states.forEach(state -> programStates.addAll(invokedArg.setConstraint((ProgramState)state, booleanConstraint)));
        }
        return programStates;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 1291).append((Object[])this.parametersConstraints).append(this.varArgs).append(this.resultIndex).append((Object)this.resultConstraint).append(this.exception).append((Object)this.exceptionType).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodYield other = (MethodYield)obj;
        return new EqualsBuilder().append((Object[])this.parametersConstraints, (Object[])other.parametersConstraints).append(this.varArgs, other.varArgs).append(this.resultIndex, other.resultIndex).append((Object)this.resultConstraint, (Object)other.resultConstraint).append(this.exception, other.exception).append((Object)this.exceptionType, (Object)other.exceptionType).isEquals();
    }

    public List<JavaFileScannerContext.Location> flow(int parameterIndex) {
        if (this.node == null || this.behavior == null) {
            return Lists.newArrayList();
        }
        if (parameterIndex < 0) {
            return FlowComputation.flow(this.node, this.node.programState.exitValue());
        }
        return FlowComputation.flow(this.node, this.behavior.parameters().get(parameterIndex));
    }

    @CheckForNull
    public Type exceptionType() {
        return this.exceptionType;
    }
}

