/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PMap;
import org.sonar.java.collections.PStack;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.VariableTree;

public class ProgramState {
    private int hashCode;
    private final int constraintSize;
    public static final ProgramState EMPTY_STATE = new ProgramState(PCollections.emptyMap(), PCollections.emptyMap(), PCollections.emptyMap().put(SymbolicValue.NULL_LITERAL, ObjectConstraint.nullConstraint()).put(SymbolicValue.TRUE_LITERAL, BooleanConstraint.TRUE).put(SymbolicValue.FALSE_LITERAL, BooleanConstraint.FALSE), PCollections.emptyMap(), PCollections.emptyStack(), null);
    private final PMap<ExplodedGraph.ProgramPoint, Integer> visitedPoints;
    @Nullable
    Symbol lastEvaluated;
    private final PStack<SymbolicValue> stack;
    private final PMap<SymbolicValue, Integer> references;
    private SymbolicValue exitSymbolicValue;
    final PMap<Symbol, SymbolicValue> values;
    final PMap<SymbolicValue, Constraint> constraints;

    private ProgramState(PMap<Symbol, SymbolicValue> values, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, Constraint> constraints, PMap<ExplodedGraph.ProgramPoint, Integer> visitedPoints, PStack<SymbolicValue> stack, SymbolicValue exitSymbolicValue) {
        this.values = values;
        this.references = references;
        this.constraints = constraints;
        this.visitedPoints = visitedPoints;
        this.stack = stack;
        this.exitSymbolicValue = exitSymbolicValue;
        this.constraintSize = 3;
    }

    private ProgramState(Symbol symbol, PMap<Symbol, SymbolicValue> values, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, Constraint> constraints, PMap<ExplodedGraph.ProgramPoint, Integer> visitedPoints, PStack<SymbolicValue> stack, SymbolicValue exitSymbolicValue) {
        this(values, references, constraints, visitedPoints, stack, exitSymbolicValue);
        this.lastEvaluated = symbol;
    }

    private ProgramState(ProgramState ps, PStack<SymbolicValue> newStack) {
        this.values = ps.values;
        this.references = ps.references;
        this.constraints = ps.constraints;
        this.constraintSize = ps.constraintSize;
        this.visitedPoints = ps.visitedPoints;
        this.exitSymbolicValue = ps.exitSymbolicValue;
        this.stack = newStack;
    }

    private ProgramState(ProgramState ps, PMap<SymbolicValue, Constraint> newConstraints) {
        this.values = ps.values;
        this.references = ps.references;
        this.constraints = newConstraints;
        this.constraintSize = ps.constraintSize + 1;
        this.visitedPoints = ps.visitedPoints;
        this.exitSymbolicValue = ps.exitSymbolicValue;
        this.stack = ps.stack;
    }

    ProgramState stackValue(SymbolicValue sv) {
        return new ProgramState(this, this.stack.push(sv));
    }

    ProgramState clearStack() {
        return this.stack.isEmpty() ? this : new ProgramState(this, PCollections.emptyStack());
    }

    public Pop unstackValue(int nbElements) {
        if (nbElements == 0 || this.stack.isEmpty()) {
            return new Pop(this, Collections.emptyList());
        }
        PStack<SymbolicValue> newStack = this.stack;
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < nbElements && !newStack.isEmpty(); ++i) {
            result.add(newStack.peek());
            newStack = newStack.pop();
        }
        return new Pop(new ProgramState(this, newStack), result);
    }

    @CheckForNull
    public SymbolicValue peekValue() {
        return this.stack.isEmpty() ? null : this.stack.peek();
    }

    public List<SymbolicValue> peekValues(int n) {
        ImmutableList.Builder result = ImmutableList.builder();
        PStack<SymbolicValue> tmpStack = this.stack;
        for (int i = 0; i < n; ++i) {
            result.add((Object)tmpStack.peek());
            tmpStack = tmpStack.pop();
        }
        return result.build();
    }

    int numberOfTimeVisited(ExplodedGraph.ProgramPoint programPoint) {
        Integer count = this.visitedPoints.get(programPoint);
        return count == null ? 0 : count;
    }

    @CheckForNull
    public Symbol getLastEvaluated() {
        return this.lastEvaluated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramState that = (ProgramState)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.exitSymbolicValue, that.exitSymbolicValue) && Objects.equals(this.peekValue(), that.peekValue());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.values, this.constraints, this.peekValue());
        }
        return this.hashCode;
    }

    public String toString() {
        return "{" + this.values.toString() + "}  {" + this.constraints.toString() + "} { " + this.stack.toString() + " } { " + this.getLastEvaluated() + " } ";
    }

    public ProgramState addConstraint(SymbolicValue symbolicValue, Constraint constraint) {
        PMap<SymbolicValue, Constraint> newConstraints = this.constraints.put(symbolicValue, constraint);
        if (newConstraints != this.constraints) {
            return new ProgramState(this, newConstraints);
        }
        return this;
    }

    ProgramState put(Symbol symbol, SymbolicValue value) {
        if (symbol.isUnknown() || ProgramState.isVolatileField(symbol)) {
            return this;
        }
        SymbolicValue oldValue = this.values.get(symbol);
        if (oldValue == null || oldValue != value) {
            PMap<SymbolicValue, Integer> newReferences = this.references;
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            newReferences = ProgramState.increaseReference(newReferences, value);
            PMap<Symbol, SymbolicValue> newValues = this.values.put(symbol, value);
            return new ProgramState(symbol, newValues, newReferences, this.constraints, this.visitedPoints, this.stack, this.exitSymbolicValue);
        }
        if (this.lastEvaluated == null) {
            this.lastEvaluated = symbol;
        }
        return this;
    }

    private static boolean isVolatileField(Symbol symbol) {
        return ProgramState.isField(symbol) && symbol.isVolatile();
    }

    private static PMap<SymbolicValue, Integer> decreaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        Preconditions.checkNotNull((Object)value);
        return givenReferences.put(sv, value - 1);
    }

    private static PMap<SymbolicValue, Integer> increaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        if (value == null) {
            return givenReferences.put(sv, 1);
        }
        return givenReferences.put(sv, value + 1);
    }

    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable Object constraint) {
        return SymbolicValue.isDisposable(symbolicValue) && (constraint == null || !(constraint instanceof ObjectConstraint) || ((ObjectConstraint)constraint).isDisposable());
    }

    private static boolean inStack(PStack<SymbolicValue> stack, SymbolicValue symbolicValue) {
        return stack.anyMatch(sv -> sv.equals(symbolicValue) || sv.references(symbolicValue));
    }

    private static boolean isLocalVariable(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isMethodSymbol();
    }

    public ProgramState cleanupDeadSymbols(final Set<Symbol> liveVariables, final Collection<SymbolicValue> protectedSymbolicValues) {
        class CleanAction
        implements BiConsumer<Symbol, SymbolicValue> {
            boolean newProgramState = false;
            PMap<Symbol, SymbolicValue> newValues;
            PMap<SymbolicValue, Integer> newReferences;
            PMap<SymbolicValue, Constraint> newConstraints;

            CleanAction() {
                this.newValues = ProgramState.this.values;
                this.newReferences = ProgramState.this.references;
                this.newConstraints = ProgramState.this.constraints;
            }

            @Override
            public void accept(Symbol symbol, SymbolicValue symbolicValue) {
                if (ProgramState.isLocalVariable(symbol) && !liveVariables.contains(symbol) && !protectedSymbolicValues.contains(symbolicValue)) {
                    this.newProgramState = true;
                    this.newValues = this.newValues.remove(symbol);
                    this.newReferences = ProgramState.decreaseReference(this.newReferences, symbolicValue);
                    if (!ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, this.newConstraints.get(symbolicValue)) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                        this.newConstraints = this.newConstraints.remove(symbolicValue);
                        this.newReferences = this.newReferences.remove(symbolicValue);
                    }
                }
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.values.forEach(cleanAction);
        return cleanAction.newProgramState ? new ProgramState(cleanAction.newValues, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack, this.exitSymbolicValue) : this;
    }

    public ProgramState cleanupConstraints() {
        class CleanAction
        implements BiConsumer<SymbolicValue, Constraint> {
            boolean newProgramState = false;
            PMap<SymbolicValue, Constraint> newConstraints;
            PMap<SymbolicValue, Integer> newReferences;

            CleanAction() {
                this.newConstraints = ProgramState.this.constraints;
                this.newReferences = ProgramState.this.references;
            }

            @Override
            public void accept(SymbolicValue symbolicValue, Constraint constraint) {
                if (!ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, constraint) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                    this.newProgramState = true;
                    this.newConstraints = this.newConstraints.remove(symbolicValue);
                    this.newReferences = this.newReferences.remove(symbolicValue);
                }
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.constraints.forEach(cleanAction);
        return cleanAction.newProgramState ? new ProgramState(this.values, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack, this.exitSymbolicValue) : this;
    }

    public ProgramState resetFieldValues(ConstraintManager constraintManager) {
        ArrayList variableTrees = new ArrayList();
        this.values.forEach((symbol, symbolicValue) -> {
            VariableTree variable;
            if (ProgramState.isField(symbol) && (variable = ((Symbol.VariableSymbol)symbol).declaration()) != null) {
                variableTrees.add(variable);
            }
        });
        if (variableTrees.isEmpty()) {
            return this;
        }
        PMap<Symbol, SymbolicValue> newValues = this.values;
        PMap<SymbolicValue, Integer> newReferences = this.references;
        for (VariableTree variableTree : variableTrees) {
            Symbol symbol2 = variableTree.symbol();
            SymbolicValue oldValue = newValues.get(symbol2);
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            SymbolicValue newValue = constraintManager.createSymbolicValue(variableTree);
            newValues = newValues.put(symbol2, newValue);
            newReferences = ProgramState.increaseReference(newReferences, newValue);
        }
        return new ProgramState(newValues, newReferences, this.constraints, this.visitedPoints, this.stack, this.exitSymbolicValue);
    }

    public static boolean isField(Symbol symbol) {
        return symbol.isVariableSymbol() && !symbol.owner().isMethodSymbol();
    }

    private static boolean isReachable(SymbolicValue symbolicValue, PMap<SymbolicValue, Integer> references) {
        Integer integer = references.get(symbolicValue);
        return integer != null && integer > 0;
    }

    public boolean canReach(SymbolicValue symbolicValue) {
        return ProgramState.isReachable(symbolicValue, this.references);
    }

    public ProgramState visitedPoint(ExplodedGraph.ProgramPoint programPoint, int nbOfVisit) {
        return new ProgramState(this.values, this.references, this.constraints, this.visitedPoints.put(programPoint, nbOfVisit), this.stack, this.exitSymbolicValue);
    }

    @CheckForNull
    public Constraint getConstraint(SymbolicValue sv) {
        return this.constraints.get(sv);
    }

    public int constraintsSize() {
        return this.constraintSize;
    }

    @CheckForNull
    public SymbolicValue getValue(Symbol symbol) {
        return this.values.get(symbol);
    }

    public Map<SymbolicValue, ObjectConstraint<ObjectConstraint.Status>> getValuesWithConstraints(Object state) {
        HashMap<SymbolicValue, ObjectConstraint<ObjectConstraint.Status>> result = new HashMap<SymbolicValue, ObjectConstraint<ObjectConstraint.Status>>();
        this.constraints.forEach((symbolicValue, valueConstraint) -> {
            ObjectConstraint constraint;
            if (valueConstraint instanceof ObjectConstraint && (constraint = (ObjectConstraint)valueConstraint).hasStatus(state)) {
                result.put((SymbolicValue)symbolicValue, constraint);
            }
        });
        return result;
    }

    public List<BinaryRelation> getKnownRelations() {
        ArrayList<BinaryRelation> knownRelations = new ArrayList<BinaryRelation>();
        this.constraints.forEach((symbolicValue, constraint) -> {
            BinaryRelation relation = symbolicValue.binaryRelation();
            if (relation != null) {
                if (BooleanConstraint.TRUE.equals(constraint)) {
                    knownRelations.add(relation);
                } else if (BooleanConstraint.FALSE.equals(constraint)) {
                    knownRelations.add(relation.inverse());
                }
            }
        });
        return knownRelations;
    }

    @CheckForNull
    public <S extends ObjectConstraint.Status> ObjectConstraint<S> getConstraintWithStatus(SymbolicValue value, S aState) {
        ObjectConstraint oConstraint;
        Constraint constraint = this.getConstraint(value.wrappedValue());
        if (constraint instanceof ObjectConstraint && (oConstraint = (ObjectConstraint)constraint).hasStatus(aState)) {
            return oConstraint;
        }
        return null;
    }

    public void storeExitValue() {
        this.exitSymbolicValue = this.peekValue();
    }

    @CheckForNull
    public SymbolicValue exitValue() {
        return this.exitSymbolicValue;
    }

    public boolean exitingOnRuntimeException() {
        return this.exitSymbolicValue instanceof SymbolicValue.ExceptionalSymbolicValue && ((SymbolicValue.ExceptionalSymbolicValue)this.exitSymbolicValue).exceptionType() == null;
    }

    public static class Pop {
        public final ProgramState state;
        public final List<SymbolicValue> values;

        public Pop(ProgramState programState, List<SymbolicValue> result) {
            this.state = programState;
            this.values = result;
        }
    }
}

