/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.checks.SECheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2583")
public class ConditionAlwaysTrueOrFalseCheck
extends SECheck {
    private Deque<EvaluatedConditions> evaluatedConditions = new LinkedList<EvaluatedConditions>();

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.evaluatedConditions.push(new EvaluatedConditions());
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        EvaluatedConditions ec = this.evaluatedConditions.pop();
        for (Tree condition : Sets.difference((Set)ec.evaluatedToFalse.keySet(), (Set)ec.evaluatedToTrue.keySet())) {
            context.reportIssue(condition, this, "Change this condition so that it does not always evaluate to \"false\"", ConditionAlwaysTrueOrFalseCheck.collectFlow(ec.evaluatedToFalse.get((Object)condition), false));
        }
        for (Tree condition : Sets.difference((Set)ec.evaluatedToTrue.keySet(), (Set)ec.evaluatedToFalse.keySet())) {
            context.reportIssue(condition, this, "Change this condition so that it does not always evaluate to \"true\"", ConditionAlwaysTrueOrFalseCheck.collectFlow(ec.evaluatedToTrue.get((Object)condition), true));
        }
    }

    private static Set<List<JavaFileScannerContext.Location>> collectFlow(Collection<ExplodedGraph.Node> nodes, boolean conditionIsAlwaysTrue) {
        return nodes.stream().map(node -> ConditionAlwaysTrueOrFalseCheck.flowFromNode(node, conditionIsAlwaysTrue)).collect(Collectors.toSet());
    }

    private static List<JavaFileScannerContext.Location> flowFromNode(ExplodedGraph.Node node, boolean conditionIsAlwaysTrue) {
        List<JavaFileScannerContext.Location> flow = FlowComputation.flow(node.parent(), node.programState.peekValue());
        flow.add(0, new JavaFileScannerContext.Location("Condition is always " + conditionIsAlwaysTrue + ".", node.programPoint.syntaxTree()));
        return flow;
    }

    public void evaluatedToFalse(Tree condition, ExplodedGraph.Node node) {
        this.evaluatedConditions.peek().evaluatedToFalse(condition, node);
    }

    public void evaluatedToTrue(Tree condition, ExplodedGraph.Node node) {
        this.evaluatedConditions.peek().evaluatedToTrue(condition, node);
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.evaluatedConditions.pop();
    }

    private static class EvaluatedConditions {
        private final Multimap<Tree, ExplodedGraph.Node> evaluatedToFalse = HashMultimap.create();
        private final Multimap<Tree, ExplodedGraph.Node> evaluatedToTrue = HashMultimap.create();

        private EvaluatedConditions() {
        }

        void evaluatedToFalse(Tree condition, ExplodedGraph.Node node) {
            this.evaluatedToFalse.put((Object)condition, (Object)node);
        }

        void evaluatedToTrue(Tree condition, ExplodedGraph.Node node) {
            this.evaluatedToTrue.put((Object)condition, (Object)node);
        }
    }
}

