/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3655")
public class OptionalGetBeforeIsPresentCheck
extends SECheck {
    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(this, context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    private static class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
        private static final MethodMatcher OPTIONAL_GET = MethodMatcher.create().typeDefinition("java.util.Optional").name("get").withoutParameter();
        private static final MethodMatcher OPTIONAL_IS_PRESENT = MethodMatcher.create().typeDefinition("java.util.Optional").name("isPresent").withoutParameter();
        private final CheckerContext context;
        private final ConstraintManager constraintManager;
        private final SECheck check;

        private PreStatementVisitor(SECheck check, CheckerContext context) {
            super(context.getState());
            this.context = context;
            this.constraintManager = context.getConstraintManager();
            this.check = check;
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (OPTIONAL_IS_PRESENT.matches(tree)) {
                this.constraintManager.setValueFactory(id -> new OptionalSymbolicValue(id, this.programState.peekValue()));
            } else if (OPTIONAL_GET.matches(tree) && this.presenceHasNotBeenChecked(this.programState.peekValue())) {
                String flowMsg;
                String issueMsg;
                String identifier = PreStatementVisitor.getIdentifierPart(tree.methodSelect());
                if (identifier.isEmpty()) {
                    issueMsg = "Optional#";
                    flowMsg = "";
                } else {
                    issueMsg = identifier + ".";
                    flowMsg = identifier + " ";
                }
                Set<List<JavaFileScannerContext.Location>> flow = FlowComputation.singleton("Optional " + flowMsg + "is accessed", tree.methodSelect());
                this.context.reportIssue(tree, this.check, "Call \"" + issueMsg + "isPresent()\" before accessing the value.", flow);
                this.programState = null;
            }
        }

        private boolean presenceHasNotBeenChecked(SymbolicValue sv) {
            return this.programState.getConstraintWithStatus(sv, Status.PRESENT) == null;
        }

        private static String getIdentifierPart(ExpressionTree methodSelect) {
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
                if (expression.is(Tree.Kind.IDENTIFIER)) {
                    return ((IdentifierTree)expression).name();
                }
            }
            return "";
        }
    }

    private static class OptionalSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue optionalSV;

        public OptionalSymbolicValue(int id, SymbolicValue sv) {
            super(id);
            this.optionalSV = sv;
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ObjectConstraint<Status> optionalConstraint = (ObjectConstraint<Status>)programState.getConstraint(this.optionalSV);
            if (optionalConstraint == null) {
                optionalConstraint = ObjectConstraint.notNull();
            }
            if (OptionalSymbolicValue.isImpossibleState(booleanConstraint, optionalConstraint)) {
                return ImmutableList.of();
            }
            if (optionalConstraint.hasStatus(Status.NOT_PRESENT) || optionalConstraint.hasStatus(Status.PRESENT)) {
                return ImmutableList.of((Object)programState);
            }
            ObjectConstraint<Status> newConstraint = booleanConstraint.isTrue() ? optionalConstraint.withStatus(Status.PRESENT) : optionalConstraint.withStatus(Status.NOT_PRESENT);
            return ImmutableList.of((Object)programState.addConstraint(this.optionalSV, newConstraint));
        }

        private static boolean isImpossibleState(BooleanConstraint booleanConstraint, ObjectConstraint optionalConstraint) {
            return optionalConstraint.hasStatus(Status.PRESENT) && booleanConstraint.isFalse() || optionalConstraint.hasStatus(Status.NOT_PRESENT) && booleanConstraint.isTrue();
        }
    }

    private static enum Status implements ObjectConstraint.Status
    {
        PRESENT,
        NOT_PRESENT;

    }
}

