/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.constraint;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.java.se.constraint.Constraint;

public class ObjectConstraint<S extends Status>
implements Constraint {
    private static final ObjectConstraint<Status> NOT_NULL = new ObjectConstraint<Object>(false, true, null);
    private final boolean isNull;
    private final boolean disposable;
    @Nullable
    private final S status;

    public ObjectConstraint(S status) {
        this(false, true, status);
    }

    public ObjectConstraint(boolean isNull, boolean disposable, @Nullable S status) {
        this.isNull = isNull;
        this.disposable = disposable;
        this.status = status;
    }

    public static <S extends Status> ObjectConstraint<S> notNull() {
        return NOT_NULL;
    }

    public static <S extends Status> ObjectConstraint<S> nullConstraint() {
        return new ObjectConstraint<Object>(true, false, null);
    }

    public ObjectConstraint<S> inverse() {
        return new ObjectConstraint<S>(!this.isNull, this.disposable, this.status);
    }

    public ObjectConstraint<S> withStatus(S newStatus) {
        return new ObjectConstraint<S>(this.isNull, this.disposable, newStatus);
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    @Override
    public String valueAsString() {
        if (this.isNull) {
            return "null";
        }
        return this.status == null || this.status.valueAsString() == null ? "non-null" : this.status.valueAsString();
    }

    public boolean isInvalidWith(@Nullable Constraint target) {
        return false;
    }

    public boolean isDisposable() {
        return this.disposable;
    }

    public boolean hasStatus(@Nullable Object aState) {
        if (aState == null) {
            return this.status == null;
        }
        return aState.equals(this.status);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.isNull ? "NULL" : "NOT_NULL");
        if (this.status != null) {
            buffer.append('(');
            buffer.append(this.status);
            buffer.append(')');
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectConstraint that = (ObjectConstraint)o;
        return this.isNull == that.isNull && Objects.equals(this.status, that.status);
    }

    public int hashCode() {
        return Objects.hash(this.isNull, this.status);
    }

    public static Predicate<Constraint> statusPredicate(Object status) {
        return c -> c instanceof ObjectConstraint && ((ObjectConstraint)c).hasStatus(status);
    }

    public static interface Status {
        default public String valueAsString() {
            return null;
        }
    }
}

