/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValueFactory;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2222")
public class LocksNotUnlockedCheck
extends SECheck {
    private static final String LOCK = "java.util.concurrent.locks.Lock";
    private static final String LOCK_METHOD_NAME = "lock";
    private static final String TRY_LOCK_METHOD_NAME = "tryLock";
    private static final String UNLOCK_METHOD_NAME = "unlock";

    private static boolean isMemberSelectActingOnField(IdentifierTree expression) {
        return ProgramState.isField(expression.symbol());
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        ExplodedGraph.Node node = context.getNode();
        context.getState().getValuesWithConstraints(LockConstraint.LOCKED).stream().flatMap(sv -> {
            ArrayList domains = Lists.newArrayList((Object[])new Class[]{LockConstraint.class});
            return FlowComputation.flow(node, sv, LockConstraint.LOCKED::equals, LockConstraint.UNLOCKED::equals, domains).stream().flatMap(Collection::stream);
        }).forEach(this::reportIssue);
    }

    private void reportIssue(JavaFileScannerContext.Location location) {
        if (location.syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree syntaxNode = (MethodInvocationTree)location.syntaxNode;
            String flowMsg = "Lock '" + SyntaxTreeNameFinder.getName(syntaxNode.methodSelect()) + "' is never unlocked.";
            Tree tree = LocksNotUnlockedCheck.issueTree(syntaxNode);
            this.reportIssue(tree, "Unlock this lock along all executions paths of this method.", FlowComputation.singleton(flowMsg, tree));
        }
    }

    private static Tree issueTree(MethodInvocationTree syntaxNode) {
        ExpressionTree methodSelect = syntaxNode.methodSelect();
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            return ((MemberSelectExpressionTree)methodSelect).expression();
        }
        return syntaxNode;
    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        public PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            MemberSelectExpressionTree memberSelect;
            ExpressionTree expression;
            if (syntaxNode.methodSelect().is(Tree.Kind.MEMBER_SELECT) && (expression = (memberSelect = (MemberSelectExpressionTree)syntaxNode.methodSelect()).expression()).is(Tree.Kind.IDENTIFIER) && expression.symbolType().isSubtypeOf(LocksNotUnlockedCheck.LOCK)) {
                String methodName = memberSelect.identifier().name();
                this.visitMethodInvocationWithIdentifierTarget(methodName, (IdentifierTree)expression);
            }
        }

        private void visitMethodInvocationWithIdentifierTarget(String methodName, IdentifierTree target) {
            if (!LocksNotUnlockedCheck.isMemberSelectActingOnField(target)) {
                SymbolicValue symbolicValue = this.programState.getValue(target.symbol());
                if (LocksNotUnlockedCheck.LOCK_METHOD_NAME.equals(methodName) || LocksNotUnlockedCheck.TRY_LOCK_METHOD_NAME.equals(methodName)) {
                    this.programState = this.programState.addConstraint(symbolicValue, LockConstraint.LOCKED);
                } else if (LocksNotUnlockedCheck.UNLOCK_METHOD_NAME.equals(methodName)) {
                    this.programState = this.programState.addConstraint(symbolicValue, LockConstraint.UNLOCKED);
                }
            }
        }
    }

    private static class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final ConstraintManager constraintManager;

        public PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.constraintManager = context.getConstraintManager();
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree syntaxNode) {
            MemberSelectExpressionTree memberSelect;
            ExpressionTree expression;
            if (syntaxNode.methodSelect().is(Tree.Kind.MEMBER_SELECT) && (expression = (memberSelect = (MemberSelectExpressionTree)syntaxNode.methodSelect()).expression()).is(Tree.Kind.IDENTIFIER) && expression.symbolType().isSubtypeOf(LocksNotUnlockedCheck.LOCK)) {
                String methodName = memberSelect.identifier().name();
                IdentifierTree target = (IdentifierTree)expression;
                if (!LocksNotUnlockedCheck.isMemberSelectActingOnField(target) && LocksNotUnlockedCheck.TRY_LOCK_METHOD_NAME.equals(methodName)) {
                    SymbolicValue symbolicValue = this.programState.getValue(target.symbol());
                    this.constraintManager.setValueFactory(new TryLockSymbolicValueFactory(symbolicValue));
                }
            }
        }
    }

    private static class TryLockSymbolicValueFactory
    implements SymbolicValueFactory {
        private final SymbolicValue operand;

        TryLockSymbolicValueFactory(SymbolicValue operand) {
            this.operand = operand;
        }

        @Override
        public SymbolicValue createSymbolicValue(int id) {
            return new TryLockSymbolicValue(id, this.operand);
        }
    }

    private static class TryLockSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue operand;

        public TryLockSymbolicValue(int id, SymbolicValue operand) {
            super(id);
            this.operand = operand;
        }

        @Override
        public boolean references(SymbolicValue other) {
            return this.operand.equals(other) || this.operand.references(other);
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            if (BooleanConstraint.TRUE.equals(booleanConstraint)) {
                return ImmutableList.of((Object)programState.addConstraint(this.operand, LockConstraint.LOCKED));
            }
            return ImmutableList.of((Object)programState.addConstraint(this.operand, LockConstraint.UNLOCKED));
        }

        @Override
        public String toString() {
            return super.toString() + ".tryLock()";
        }
    }

    public static enum LockConstraint implements Constraint
    {
        LOCKED,
        UNLOCKED;


        @Override
        public String valueAsString() {
            if (this == LOCKED) {
                return "locked";
            }
            return "unlocked";
        }
    }
}

