/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.ExceptionalYieldChecker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3655")
public class OptionalGetBeforeIsPresentCheck
extends SECheck {
    private static final ExceptionalYieldChecker EXCEPTIONAL_YIELD_CHECKER = new ExceptionalYieldChecker("NoSuchElementException will be thrown when invoking method %s() without verifying Optional parameter.");

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(this, context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        EXCEPTIONAL_YIELD_CHECKER.reportOnExceptionalYield(context.getNode(), this);
    }

    private static class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private static final String JAVA_UTIL_OPTIONAL = "java.util.Optional";
        private static final MethodMatcher OPTIONAL_GET = MethodMatcher.create().typeDefinition("java.util.Optional").name("get").withoutParameter();
        private static final MethodMatcher OPTIONAL_IS_PRESENT = MethodMatcher.create().typeDefinition("java.util.Optional").name("isPresent").withoutParameter();
        private final CheckerContext context;
        private final ConstraintManager constraintManager;
        private final SECheck check;

        private PreStatementVisitor(SECheck check, CheckerContext context) {
            super(context.getState());
            this.context = context;
            this.constraintManager = context.getConstraintManager();
            this.check = check;
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree tree) {
            SymbolicValue peek = this.programState.peekValue();
            if (OPTIONAL_IS_PRESENT.matches(tree)) {
                this.constraintManager.setValueFactory(id -> new OptionalSymbolicValue(id, peek));
            } else if (OPTIONAL_GET.matches(tree) && this.presenceHasNotBeenChecked(peek)) {
                this.context.addExceptionalYield(peek, this.programState, "java.util.NoSuchElementException", this.check);
                this.reportIssue(tree);
                this.programState = null;
            }
        }

        private void reportIssue(MethodInvocationTree mit) {
            String flowMsg;
            String issueMsg;
            String identifier = PreStatementVisitor.getIdentifierPart(mit.methodSelect());
            if (identifier.isEmpty()) {
                issueMsg = "Optional#";
                flowMsg = "";
            } else {
                issueMsg = identifier + ".";
                flowMsg = identifier + " ";
            }
            Set<List<JavaFileScannerContext.Location>> flow = FlowComputation.singleton("Optional " + flowMsg + "is accessed", mit.methodSelect());
            this.context.reportIssue(mit, this.check, "Call \"" + issueMsg + "isPresent()\" before accessing the value.", flow);
        }

        private boolean presenceHasNotBeenChecked(SymbolicValue sv) {
            return this.programState.getConstraint(sv, OptionalConstraint.class) != OptionalConstraint.PRESENT;
        }

        private static String getIdentifierPart(ExpressionTree methodSelect) {
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
                if (expression.is(Tree.Kind.IDENTIFIER)) {
                    return ((IdentifierTree)expression).name();
                }
            }
            return "";
        }
    }

    private static class OptionalSymbolicValue
    extends SymbolicValue {
        private final SymbolicValue optionalSV;

        public OptionalSymbolicValue(int id, SymbolicValue sv) {
            super(id);
            this.optionalSV = sv;
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            OptionalConstraint optionalConstraint = programState.getConstraint(this.optionalSV, OptionalConstraint.class);
            if (OptionalSymbolicValue.isImpossibleState(booleanConstraint, optionalConstraint)) {
                return ImmutableList.of();
            }
            if (optionalConstraint == OptionalConstraint.NOT_PRESENT || optionalConstraint == OptionalConstraint.PRESENT) {
                return ImmutableList.of((Object)programState);
            }
            OptionalConstraint newConstraint = booleanConstraint.isTrue() ? OptionalConstraint.PRESENT : OptionalConstraint.NOT_PRESENT;
            return ImmutableList.of((Object)programState.addConstraint(this.optionalSV, newConstraint));
        }

        private static boolean isImpossibleState(BooleanConstraint booleanConstraint, OptionalConstraint optionalConstraint) {
            return optionalConstraint == OptionalConstraint.PRESENT && booleanConstraint.isFalse() || optionalConstraint == OptionalConstraint.NOT_PRESENT && booleanConstraint.isTrue();
        }
    }

    private static enum OptionalConstraint implements Constraint
    {
        PRESENT,
        NOT_PRESENT;

    }
}

