/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public abstract class BinarySymbolicValue
extends SymbolicValue {
    SymbolicValue leftOp;
    SymbolicValue rightOp;

    public BinarySymbolicValue(int id) {
        super(id);
    }

    public abstract BooleanConstraint shouldNotInverse();

    @Override
    public boolean references(SymbolicValue other) {
        return this.leftOp.equals(other) || this.rightOp.equals(other) || this.leftOp.references(other) || this.rightOp.references(other);
    }

    @Override
    public void computedFrom(List<SymbolicValue> symbolicValues) {
        Preconditions.checkArgument((symbolicValues.size() == 2 ? 1 : 0) != 0);
        this.rightOp = symbolicValues.get(0);
        this.leftOp = symbolicValues.get(1);
    }

    @Override
    public List<SymbolicValue> computedFrom() {
        return ImmutableList.of((Object)this.leftOp, (Object)this.rightOp);
    }

    public SymbolicValue getLeftOp() {
        return this.leftOp;
    }

    public SymbolicValue getRightOp() {
        return this.rightOp;
    }
}

