/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class RelationalSymbolicValue
extends BinarySymbolicValue {
    private final Kind kind;

    public RelationalSymbolicValue(int id, Kind kind) {
        super(id);
        this.kind = kind;
    }

    @Override
    public BooleanConstraint shouldNotInverse() {
        switch (this.kind) {
            case METHOD_EQUALS: 
            case EQUAL: {
                return BooleanConstraint.TRUE;
            }
        }
        return BooleanConstraint.FALSE;
    }

    @Override
    public List<ProgramState> setConstraint(ProgramState initialProgramState, BooleanConstraint booleanConstraint) {
        ProgramState programState = this.checkRelation(booleanConstraint, initialProgramState);
        if (programState == null) {
            return ImmutableList.of();
        }
        ArrayList<ProgramState> results = new ArrayList<ProgramState>();
        List<ProgramState> copiedConstraints = this.copyConstraint(this.leftOp, this.rightOp, programState, booleanConstraint);
        if (Kind.METHOD_EQUALS == this.kind || Kind.NOT_METHOD_EQUALS == this.kind) {
            copiedConstraints = this.addNullConstraintsForBooleanWrapper(booleanConstraint, initialProgramState, copiedConstraints);
        }
        for (ProgramState ps : copiedConstraints) {
            List<ProgramState> copiedConstraintsRightToLeft = this.copyConstraint(this.rightOp, this.leftOp, ps, booleanConstraint);
            if (copiedConstraintsRightToLeft.size() == 1 && copiedConstraintsRightToLeft.get(0).equals(programState)) {
                results.add(programState.addConstraint(this, booleanConstraint));
                continue;
            }
            results.addAll(copiedConstraintsRightToLeft);
        }
        return results;
    }

    private List<ProgramState> addNullConstraintsForBooleanWrapper(BooleanConstraint booleanConstraint, ProgramState initialProgramState, List<ProgramState> copiedConstraints) {
        BooleanConstraint leftConstraint = initialProgramState.getConstraint(this.leftOp, BooleanConstraint.class);
        BooleanConstraint rightConstraint = initialProgramState.getConstraint(this.rightOp, BooleanConstraint.class);
        if (leftConstraint != null && rightConstraint == null && !this.shouldNotInverse().equals(booleanConstraint)) {
            List nullConstraints = copiedConstraints.stream().flatMap(ps -> this.rightOp.setConstraint((ProgramState)ps, ObjectConstraint.NULL).stream()).map(ps -> ps.removeConstraintsOnDomain(this.rightOp, BooleanConstraint.class)).collect(Collectors.toList());
            return ImmutableList.builder().addAll(copiedConstraints).addAll(nullConstraints).build();
        }
        return copiedConstraints;
    }

    protected List<ProgramState> copyConstraint(SymbolicValue from, SymbolicValue to, ProgramState programState, BooleanConstraint booleanConstraint) {
        ProgramState newState = programState;
        if (programState.canReach(from) || programState.canReach(to)) {
            newState = programState.addConstraint(this, booleanConstraint);
        }
        return this.copyConstraintFromTo(from, to, newState, booleanConstraint);
    }

    private List<ProgramState> copyConstraintFromTo(SymbolicValue from, SymbolicValue to, ProgramState programState, BooleanConstraint booleanConstraint) {
        ArrayList<ProgramState> states = new ArrayList<ProgramState>();
        states.add(programState);
        PMap<Class<? extends Constraint>, Constraint> leftConstraints = programState.getConstraints(from);
        if (leftConstraints != null) {
            leftConstraints.forEach((d, c) -> {
                ArrayList newStates = new ArrayList();
                Constraint constraint = this.shouldNotInverse().equals(booleanConstraint) ? c : c.inverse();
                states.forEach(state -> {
                    if (constraint == null) {
                        PMap<Class<? extends Constraint>, Constraint> constraints = state.getConstraints(to);
                        if (constraints != null) {
                            newStates.add(state.removeConstraintsOnDomain(to, c.getClass()));
                        } else {
                            newStates.add(state);
                        }
                    } else if (ObjectConstraint.NULL == constraint && c != constraint) {
                        newStates.add(state);
                    } else {
                        newStates.addAll(to.setConstraint((ProgramState)state, constraint));
                    }
                });
                states.clear();
                states.addAll(newStates);
            });
        }
        return states;
    }

    @CheckForNull
    private ProgramState checkRelation(BooleanConstraint booleanConstraint, ProgramState programState) {
        RelationState relationState = this.binaryRelation().resolveState(programState.getKnownRelations());
        if (relationState.rejects(booleanConstraint)) {
            return null;
        }
        return programState;
    }

    @Override
    public BinaryRelation binaryRelation() {
        return BinaryRelation.binaryRelation(this.kind, this.leftOp, this.rightOp);
    }

    @Override
    public String toString() {
        return this.binaryRelation().toString();
    }

    public static enum Kind {
        EQUAL("=="),
        NOT_EQUAL("!="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        METHOD_EQUALS(".EQ."),
        NOT_METHOD_EQUALS(".NE.");

        final String operand;

        private Kind(String operand) {
            this.operand = operand;
        }

        public Kind inverse() {
            switch (this) {
                case GREATER_THAN: {
                    return LESS_THAN_OR_EQUAL;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN;
                }
                case LESS_THAN: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case LESS_THAN_OR_EQUAL: {
                    return GREATER_THAN;
                }
                case METHOD_EQUALS: {
                    return NOT_METHOD_EQUALS;
                }
                case NOT_METHOD_EQUALS: {
                    return METHOD_EQUALS;
                }
            }
            return this;
        }

        public Kind symmetric() {
            Kind sym;
            switch (this) {
                case GREATER_THAN: {
                    sym = LESS_THAN;
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    sym = LESS_THAN_OR_EQUAL;
                    break;
                }
                case LESS_THAN: {
                    sym = GREATER_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    sym = GREATER_THAN_OR_EQUAL;
                    break;
                }
                default: {
                    sym = this;
                }
            }
            return sym;
        }
    }
}

