/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PMap;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.ExceptionalCheckBasedYield;
import org.sonar.java.se.xproc.ExceptionalYield;
import org.sonar.java.se.xproc.HappyPathYield;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;

public class MethodBehavior {
    private final Symbol.MethodSymbol methodSymbol;
    private final boolean varArgs;
    private final int arity;
    private final Set<MethodYield> yields;
    private final List<SymbolicValue> parameters;
    private boolean complete = false;

    public MethodBehavior(Symbol.MethodSymbol methodSymbol) {
        this.methodSymbol = methodSymbol;
        this.yields = new LinkedHashSet<MethodYield>();
        this.parameters = new ArrayList<SymbolicValue>();
        this.varArgs = ((JavaSymbol.MethodJavaSymbol)methodSymbol).isVarArgs();
        this.arity = methodSymbol.parameterTypes().size();
    }

    public void createYield(ExplodedGraph.Node node) {
        MethodYield yield;
        boolean expectReturnValue = !this.isConstructor() && !this.isVoidMethod();
        SymbolicValue resultSV = node.programState.exitValue();
        if (!node.onHappyPath() || resultSV == null && expectReturnValue || resultSV instanceof SymbolicValue.ExceptionalSymbolicValue) {
            ExceptionalYield exceptionalYield = new ExceptionalYield(node, this);
            if (resultSV != null) {
                exceptionalYield.setExceptionType(((SymbolicValue.ExceptionalSymbolicValue)resultSV).exceptionType());
            }
            yield = exceptionalYield;
        } else {
            HappyPathYield happyPathYield = new HappyPathYield(node, this);
            if (expectReturnValue) {
                happyPathYield.setResult(this.parameters.indexOf(resultSV), node.programState.getConstraints(resultSV));
            }
            yield = happyPathYield;
        }
        this.addParameterConstraints(node, yield);
        this.yields.add(yield);
    }

    private void addParameterConstraints(ExplodedGraph.Node node, MethodYield yield) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            PMap<Class<Constraint>, Constraint> constraints = node.programState.getConstraints(this.parameters.get(i));
            if (constraints == null) {
                constraints = PCollections.emptyMap();
            }
            yield.parametersConstraints.add(constraints);
        }
    }

    public ExceptionalYield createExceptionalCheckBasedYield(SymbolicValue target, ExplodedGraph.Node node, Type exceptionType, SECheck check) {
        ExceptionalCheckBasedYield yield = new ExceptionalCheckBasedYield(target, exceptionType, check.getClass(), node, this);
        this.addParameterConstraints(node, yield);
        this.yields.add(yield);
        return yield;
    }

    public boolean isMethodVarArgs() {
        return this.varArgs;
    }

    public int methodArity() {
        return this.arity;
    }

    private boolean isVoidMethod() {
        return this.methodSymbol.returnType().type().isVoid();
    }

    private boolean isConstructor() {
        return ((JavaSymbol.MethodJavaSymbol)this.methodSymbol).isConstructor();
    }

    public List<MethodYield> yields() {
        return ImmutableList.builder().addAll(this.yields).build();
    }

    public Stream<ExceptionalYield> exceptionalPathYields() {
        return this.yields.stream().filter(y -> y instanceof ExceptionalYield).map(ExceptionalYield.class::cast);
    }

    public Stream<HappyPathYield> happyPathYields() {
        return this.yields.stream().filter(y -> y instanceof HappyPathYield).map(HappyPathYield.class::cast);
    }

    public void addParameter(SymbolicValue sv) {
        this.parameters.add(sv);
    }

    public List<SymbolicValue> parameters() {
        return this.parameters;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void completed() {
        this.complete = true;
    }

    public void addYield(MethodYield yield) {
        this.yields.add(yield);
    }
}

