/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.sonar.java.bytecode.loader.Loader;

class FileSystemLoader
implements Loader {
    private Path baseDirPath;

    public FileSystemLoader(@Nullable File baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir can't be null");
        }
        this.baseDirPath = baseDir.toPath();
    }

    @Override
    public URL findResource(String name) {
        if (this.baseDirPath == null) {
            throw new IllegalStateException("Loader closed");
        }
        Path filePath = this.baseDirPath.resolve(name);
        if (filePath.toFile().isFile()) {
            try {
                return filePath.toUri().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public byte[] loadBytes(String name) {
        if (this.baseDirPath == null) {
            throw new IllegalStateException("Loader closed");
        }
        Path filePath = this.baseDirPath.resolve(name);
        if (!filePath.toFile().exists()) {
            return new byte[0];
        }
        try {
            return Files.readAllBytes(filePath);
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    @Override
    public void close() {
        this.baseDirPath = null;
    }
}

