/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

public class LiteralUtils {
    private LiteralUtils() {
    }

    @CheckForNull
    public static Integer intLiteralValue(ExpressionTree expression) {
        if (expression.is(Tree.Kind.INT_LITERAL)) {
            return LiteralUtils.intLiteralValue((LiteralTree)expression);
        }
        if (expression.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
            UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
            Integer subExpressionIntValue = LiteralUtils.intLiteralValue(unaryExp.expression());
            return expression.is(Tree.Kind.UNARY_MINUS) ? LiteralUtils.minus(subExpressionIntValue) : subExpressionIntValue;
        }
        return null;
    }

    @CheckForNull
    private static Integer intLiteralValue(LiteralTree literal) {
        String literalValue = literal.value().replaceAll("_", "");
        if (literalValue.startsWith("0x") || literalValue.startsWith("0b")) {
            return null;
        }
        return Integer.valueOf(literalValue);
    }

    @CheckForNull
    public static Long longLiteralValue(ExpressionTree tree) {
        int sign;
        ExpressionTree expression = tree;
        int n = sign = tree.is(Tree.Kind.UNARY_MINUS) ? -1 : 1;
        if (tree.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
            expression = ((UnaryExpressionTree)tree).expression();
        }
        if (expression.is(Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL)) {
            String value = LiteralUtils.trimLongSuffix(((LiteralTree)expression).value());
            value = value.replaceAll("\\_", "");
            try {
                return (long)sign * Long.decode(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    private static Integer minus(@Nullable Integer nullableInteger) {
        return nullableInteger == null ? null : Integer.valueOf(-nullableInteger.intValue());
    }

    public static String trimQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }

    public static String trimLongSuffix(String longString) {
        if (StringUtils.isBlank((String)longString)) {
            return longString;
        }
        int lastCharPosition = longString.length() - 1;
        char lastChar = longString.charAt(lastCharPosition);
        String value = longString;
        if (lastChar == 'L' || lastChar == 'l') {
            value = longString.substring(0, lastCharPosition);
        }
        return value;
    }
}

