/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.se.LearnedAssociation;
import org.sonar.java.se.LearnedConstraint;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.tree.Tree;

public class ExplodedGraph {
    private Map<Node, Node> nodes = Maps.newHashMap();

    public Node node(ProgramPoint programPoint, @Nullable ProgramState programState) {
        Node result = new Node(programPoint, programState);
        Node cached = this.nodes.get(result);
        if (cached != null) {
            cached.isNew = false;
            return cached;
        }
        result.isNew = true;
        this.nodes.put(result, result);
        return result;
    }

    public Map<Node, Node> nodes() {
        return this.nodes;
    }

    public static final class Edge {
        final Node child;
        final Node parent;
        private Set<LearnedConstraint> lc;
        private Set<LearnedAssociation> la;
        private final Set<MethodYield> yields = new LinkedHashSet<MethodYield>();

        private Edge(Node child, Node parent) {
            Preconditions.checkState((!Objects.equals(child, parent) ? 1 : 0) != 0);
            this.child = child;
            this.parent = parent;
        }

        public Node child() {
            return this.child;
        }

        public Node parent() {
            return this.parent;
        }

        public Set<LearnedConstraint> learnedConstraints() {
            if (this.lc == null) {
                this.lc = this.child.programState.learnedConstraints(this.parent.programState);
            }
            return this.lc;
        }

        public Set<LearnedAssociation> learnedAssociations() {
            if (this.la == null) {
                this.la = this.child.programState.learnedAssociations(this.parent.programState);
            }
            return this.la;
        }

        public Set<MethodYield> yields() {
            return this.yields;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return Objects.equals(this.child, edge.child) && Objects.equals(this.parent, edge.parent);
        }

        public int hashCode() {
            return Objects.hash(this.child, this.parent);
        }
    }

    public static final class Node {
        public final ProgramPoint programPoint;
        @Nullable
        public final ProgramState programState;
        private final Map<Node, Edge> edges = new HashMap<Node, Edge>();
        boolean isNew;
        boolean exitPath = false;
        boolean happyPath = true;

        private Node(ProgramPoint programPoint, @Nullable ProgramState programState) {
            Objects.requireNonNull(programPoint);
            this.programPoint = programPoint;
            this.programState = programState;
        }

        public void addParent(@Nullable Node parent, @Nullable MethodYield methodYield) {
            if (parent == null) {
                return;
            }
            Edge edge = this.edges.computeIfAbsent(parent, p -> new Edge(this, (Node)p));
            if (methodYield != null) {
                Preconditions.checkState((boolean)parent.programPoint.syntaxTree().is(Tree.Kind.METHOD_INVOCATION), (Object)"Yield on edge where parent is not MIT");
                edge.yields.add(methodYield);
            }
        }

        public boolean onHappyPath() {
            return this.happyPath;
        }

        @Nullable
        public Node parent() {
            return this.parents().stream().findFirst().orElse(null);
        }

        public Set<Node> parents() {
            return this.edges.keySet();
        }

        public int hashCode() {
            return this.programPoint.hashCode() * 31 + (this.programState == null ? 0 : this.programState.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node other = (Node)obj;
                return this.programPoint.equals(other.programPoint) && Objects.equals(this.programState, other.programState);
            }
            return false;
        }

        public String toString() {
            return "B" + this.programPoint.block.id() + "." + this.programPoint.i + ": " + this.programState;
        }

        public Collection<Edge> edges() {
            return this.edges.values();
        }
    }
}

