/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PSet;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.LearnedAssociation;
import org.sonar.java.se.LearnedConstraint;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class FlowComputation {
    public static final String IMPLIES_MSG = "Implies '%s' is %s.";
    private final Predicate<Constraint> addToFlow;
    private final Predicate<Constraint> terminateTraversal;
    private final Set<SymbolicValue> symbolicValues;
    private final List<Class<? extends Constraint>> domains;

    private FlowComputation(Set<SymbolicValue> symbolicValues, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal, List<Class<? extends Constraint>> domains) {
        this.addToFlow = addToFlow;
        this.terminateTraversal = terminateTraversal;
        this.symbolicValues = symbolicValues;
        this.domains = domains;
    }

    private static Set<SymbolicValue> computedFrom(@Nullable SymbolicValue symbolicValue) {
        if (symbolicValue == null) {
            return Collections.emptySet();
        }
        HashSet<SymbolicValue> result = new HashSet<SymbolicValue>();
        result.add(symbolicValue);
        symbolicValue.computedFrom().forEach(sv -> result.addAll(FlowComputation.computedFrom(sv)));
        return result;
    }

    public static Set<List<JavaFileScannerContext.Location>> flow(ExplodedGraph.Node currentNode, Set<SymbolicValue> symbolicValues, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal, List<Class<? extends Constraint>> domains, @Nullable Symbol trackSymbol) {
        Set<SymbolicValue> allSymbolicValues = symbolicValues.stream().map(FlowComputation::computedFrom).flatMap(Collection::stream).collect(Collectors.toSet());
        FlowComputation flowComputation = new FlowComputation(allSymbolicValues, addToFlow, terminateTraversal, domains);
        return flowComputation.run(currentNode, trackSymbol == null ? currentNode.programState.getLastEvaluated() : trackSymbol);
    }

    public static Set<List<JavaFileScannerContext.Location>> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, List<Class<? extends Constraint>> domains) {
        return FlowComputation.flow(currentNode, currentVal, (Constraint constraint) -> true, domains);
    }

    public static Set<List<JavaFileScannerContext.Location>> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, List<Class<? extends Constraint>> domains, @Nullable Symbol trackSymbol) {
        return FlowComputation.flow(currentNode, (Set<SymbolicValue>)(currentVal == null ? ImmutableSet.of() : ImmutableSet.of((Object)currentVal)), c -> true, c -> false, domains, trackSymbol);
    }

    public static Set<List<JavaFileScannerContext.Location>> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, Predicate<Constraint> addToFlow, List<Class<? extends Constraint>> domains) {
        return FlowComputation.flow(currentNode, currentVal, addToFlow, c -> false, domains);
    }

    public static Set<List<JavaFileScannerContext.Location>> flow(ExplodedGraph.Node currentNode, @Nullable SymbolicValue currentVal, Predicate<Constraint> addToFlow, Predicate<Constraint> terminateTraversal, List<Class<? extends Constraint>> domains) {
        return FlowComputation.flow(currentNode, (Set<SymbolicValue>)(currentVal == null ? ImmutableSet.of() : ImmutableSet.of((Object)currentVal)), addToFlow, terminateTraversal, domains, null);
    }

    private Set<List<JavaFileScannerContext.Location>> run(ExplodedGraph.Node node, @Nullable Symbol trackSymbol) {
        HashSet<List<JavaFileScannerContext.Location>> flows = new HashSet<List<JavaFileScannerContext.Location>>();
        ArrayDeque workList = new ArrayDeque();
        node.edges().stream().flatMap(e -> this.startPath((ExplodedGraph.Edge)e, trackSymbol)).forEach(workList::push);
        while (!workList.isEmpty()) {
            ExecutionPath path = (ExecutionPath)workList.pop();
            if (path.finished) {
                flows.add(path.flow);
                continue;
            }
            path.lastEdge.parent.edges().stream().filter(path::notVisited).flatMap(path::addEdge).forEach(workList::push);
        }
        return flows;
    }

    Stream<ExecutionPath> startPath(ExplodedGraph.Edge edge, @Nullable Symbol trackSymbol) {
        return new ExecutionPath(null, PCollections.emptySet(), trackSymbol, (List)ImmutableList.of(), false).addEdge(edge);
    }

    public static Set<List<JavaFileScannerContext.Location>> singleton(String msg, Tree tree) {
        return ImmutableSet.of((Object)ImmutableList.of((Object)new JavaFileScannerContext.Location(msg, tree)));
    }

    private class ExecutionPath {
        @Nullable
        final Symbol trackSymbol;
        final ExplodedGraph.Edge lastEdge;
        final PSet<ExplodedGraph.Edge> visited;
        final List<JavaFileScannerContext.Location> flow;
        final boolean finished;

        private ExecutionPath(ExplodedGraph.Edge edge, @Nullable PSet<ExplodedGraph.Edge> visited, Symbol trackSymbol, List<JavaFileScannerContext.Location> flow, boolean finished) {
            this.trackSymbol = trackSymbol;
            this.lastEdge = edge;
            this.visited = visited;
            this.flow = flow;
            this.finished = finished;
        }

        Stream<ExecutionPath> addEdge(ExplodedGraph.Edge edge) {
            ImmutableList.Builder flowBuilder = ImmutableList.builder();
            flowBuilder.addAll(this.flow);
            List laFlow = this.learnedAssociation(edge).map(la -> this.flowFromLearnedAssociation((LearnedAssociation)la, edge.parent)).orElse((List)ImmutableList.of());
            flowBuilder.addAll((Iterable)laFlow);
            Symbol newTrackSymbol = this.newTrackedSymbol(edge);
            Set<LearnedConstraint> learnedConstraints = this.learnedConstraints(edge);
            List<JavaFileScannerContext.Location> lcFlow = this.flowFromLearnedConstraints(edge, learnedConstraints);
            flowBuilder.addAll(lcFlow);
            boolean endOfPath = this.visitedAllParents(edge) || this.shouldTerminate(learnedConstraints);
            ImmutableList currentFlow = flowBuilder.build();
            Set<List<JavaFileScannerContext.Location>> yieldsFlows = this.flowFromYields(edge);
            return yieldsFlows.stream().map(arg_0 -> ExecutionPath.lambda$addEdge$1((List)currentFlow, arg_0)).map(f -> new ExecutionPath(edge, this.visited.add(edge), newTrackSymbol, (List<JavaFileScannerContext.Location>)f, endOfPath));
        }

        private List<JavaFileScannerContext.Location> flowFromLearnedConstraints(ExplodedGraph.Edge edge, Set<LearnedConstraint> learnedConstraints) {
            return learnedConstraints.stream().map(lc -> this.learnedConstraintFlow((LearnedConstraint)lc, edge)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private boolean shouldTerminate(Set<LearnedConstraint> learnedConstraints) {
            return learnedConstraints.stream().map(LearnedConstraint::constraint).anyMatch(FlowComputation.this.terminateTraversal);
        }

        Optional<LearnedAssociation> learnedAssociation(ExplodedGraph.Edge edge) {
            return edge.learnedAssociations().stream().filter(la -> la.symbol().equals(this.trackSymbol)).findAny();
        }

        List<JavaFileScannerContext.Location> flowFromLearnedAssociation(LearnedAssociation learnedAssociation, ExplodedGraph.Node node) {
            if (this.trackSymbol == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder flowBuilder = ImmutableList.builder();
            for (Class domain : FlowComputation.this.domains) {
                Object constraint = node.programState.getConstraint(learnedAssociation.symbolicValue(), domain);
                if (constraint == null) continue;
                String message = String.format("'%s' is assigned %s.", learnedAssociation.symbol().name(), constraint.valueAsString());
                flowBuilder.add((Object)new JavaFileScannerContext.Location(message, node.programPoint.syntaxTree()));
            }
            return flowBuilder.build();
        }

        @Nullable
        private Symbol newTrackedSymbol(ExplodedGraph.Edge edge) {
            if (this.trackSymbol == null) {
                return null;
            }
            if (this.learnedAssociation(edge).isPresent()) {
                return edge.parent.programState.getLastEvaluated();
            }
            return this.trackSymbol;
        }

        private boolean visitedAllParents(ExplodedGraph.Edge edge) {
            return edge.parent.edges().stream().allMatch(this.visited::contains);
        }

        boolean notVisited(ExplodedGraph.Edge e) {
            return !this.visited.contains(e);
        }

        Set<LearnedConstraint> learnedConstraints(ExplodedGraph.Edge edge) {
            Set<LearnedConstraint> learnedConstraints = edge.learnedConstraints();
            ImmutableSet.Builder lcByDomainBuilder = ImmutableSet.builder();
            for (Class domain : FlowComputation.this.domains) {
                learnedConstraints.stream().filter(lc -> FlowComputation.this.symbolicValues.contains(lc.symbolicValue()) && this.hasConstraintForDomain((LearnedConstraint)lc, domain)).forEach(arg_0 -> ((ImmutableSet.Builder)lcByDomainBuilder).add(arg_0));
            }
            return lcByDomainBuilder.build();
        }

        private boolean hasConstraintForDomain(LearnedConstraint lc, Class<? extends Constraint> domain) {
            Constraint constraint = lc.constraint;
            return constraint == null || domain.isAssignableFrom(constraint.getClass());
        }

        private List<JavaFileScannerContext.Location> learnedConstraintFlow(LearnedConstraint learnedConstraint, ExplodedGraph.Edge edge) {
            Constraint constraint = learnedConstraint.constraint();
            if (constraint == null || !FlowComputation.this.addToFlow.test(constraint)) {
                return ImmutableList.of();
            }
            ExplodedGraph.Node parent = edge.parent;
            Tree nodeTree = parent.programPoint.syntaxTree();
            if (this.isMethodInvocationNode(parent)) {
                return this.methodInvocationFlow(constraint, edge);
            }
            if (nodeTree.is(Tree.Kind.NEW_CLASS)) {
                return ImmutableList.of((Object)this.location(parent, String.format("Constructor implies '%s'.", constraint.valueAsString())));
            }
            String name = SyntaxTreeNameFinder.getName(nodeTree);
            String message = name == null ? constraint.valueAsString() : String.format(FlowComputation.IMPLIES_MSG, name, constraint.valueAsString());
            return ImmutableList.of((Object)this.location(parent, message));
        }

        private List<JavaFileScannerContext.Location> methodInvocationFlow(Constraint learnedConstraint, ExplodedGraph.Edge edge) {
            ExplodedGraph.Node parent = edge.parent;
            MethodInvocationTree mit = (MethodInvocationTree)parent.programPoint.syntaxTree();
            ImmutableList.Builder flowBuilder = ImmutableList.builder();
            SymbolicValue returnSV = edge.child.programState.peekValue();
            if (FlowComputation.this.symbolicValues.contains(returnSV)) {
                flowBuilder.add((Object)this.location(parent, String.format("'%s()' returns %s.", mit.symbol().name(), learnedConstraint.valueAsString())));
            }
            SymbolicValue invocationTarget = parent.programState.peekValue(mit.arguments().size());
            if (FlowComputation.this.symbolicValues.contains(invocationTarget)) {
                String invocationTargetName = SyntaxTreeNameFinder.getName(mit.methodSelect());
                flowBuilder.add((Object)this.location(parent, String.format(FlowComputation.IMPLIES_MSG, invocationTargetName, learnedConstraint.valueAsString())));
            }
            List<Integer> argumentIndices = this.correspondingArgumentIndices(FlowComputation.this.symbolicValues, parent);
            argumentIndices.stream().map(mit.arguments()::get).map(argTree -> {
                String message = String.format(FlowComputation.IMPLIES_MSG, SyntaxTreeNameFinder.getName(argTree), learnedConstraint.valueAsString());
                return new JavaFileScannerContext.Location(message, (Tree)argTree);
            }).forEach(arg_0 -> ((ImmutableList.Builder)flowBuilder).add(arg_0));
            return flowBuilder.build();
        }

        private Set<List<JavaFileScannerContext.Location>> flowFromYields(ExplodedGraph.Edge edge) {
            Set<MethodYield> methodYields = edge.yields();
            if (methodYields.isEmpty()) {
                return ImmutableSet.of((Object)ImmutableList.of());
            }
            List<Integer> argumentIndices = this.correspondingArgumentIndices(FlowComputation.this.symbolicValues, edge.parent);
            SymbolicValue returnSV = edge.child.programState.peekValue();
            if (FlowComputation.this.symbolicValues.contains(returnSV)) {
                argumentIndices.add(-1);
            }
            return methodYields.stream().map(y -> y.flow(argumentIndices, FlowComputation.this.domains)).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        private boolean isMethodInvocationNode(ExplodedGraph.Node node) {
            ProgramPoint pp = node.programPoint;
            if (pp.i < pp.block.elements().size()) {
                Tree tree = pp.block.elements().get(pp.i);
                return tree.is(Tree.Kind.METHOD_INVOCATION);
            }
            return false;
        }

        private List<Integer> correspondingArgumentIndices(Set<SymbolicValue> candidates, ExplodedGraph.Node invocationNode) {
            MethodInvocationTree mit = (MethodInvocationTree)invocationNode.programPoint.syntaxTree();
            List<SymbolicValue> arguments = this.argumentsUsedForMethodInvocation(invocationNode, mit);
            return IntStream.range(0, arguments.size()).filter(i -> candidates.contains(arguments.get(i))).boxed().collect(Collectors.toList());
        }

        private List<SymbolicValue> argumentsUsedForMethodInvocation(ExplodedGraph.Node invocationNode, MethodInvocationTree mit) {
            List<SymbolicValue> values = invocationNode.programState.peekValues(mit.arguments().size());
            return Lists.reverse(values);
        }

        private JavaFileScannerContext.Location location(ExplodedGraph.Node node, String message) {
            return new JavaFileScannerContext.Location(message, node.programPoint.syntaxTree());
        }

        private static /* synthetic */ ImmutableList lambda$addEdge$1(List currentFlow, List yieldFlow) {
            return ImmutableList.builder().addAll((Iterable)currentFlow).addAll((Iterable)yieldFlow).build();
        }
    }
}

