/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PMap;
import org.sonar.java.collections.PStack;
import org.sonar.java.se.LearnedAssociation;
import org.sonar.java.se.LearnedConstraint;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.checks.CustomUnclosedResourcesCheck;
import org.sonar.java.se.checks.LocksNotUnlockedCheck;
import org.sonar.java.se.checks.UnclosedResourcesCheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.VariableTree;

public class ProgramState {
    private int hashCode;
    private final int constraintSize;
    public static final ProgramState EMPTY_STATE = new ProgramState(PCollections.emptyMap(), PCollections.emptyMap(), PCollections.emptyMap().put(SymbolicValue.NULL_LITERAL, PCollections.emptyMap().put(ObjectConstraint.class, ObjectConstraint.NULL)).put(SymbolicValue.TRUE_LITERAL, PCollections.emptyMap().put(BooleanConstraint.class, BooleanConstraint.TRUE).put(ObjectConstraint.class, (BooleanConstraint)((Object)ObjectConstraint.NOT_NULL))).put(SymbolicValue.FALSE_LITERAL, PCollections.emptyMap().put(BooleanConstraint.class, BooleanConstraint.FALSE).put(ObjectConstraint.class, (BooleanConstraint)((Object)ObjectConstraint.NOT_NULL))), PCollections.emptyMap(), PCollections.emptyStack(), null);
    private final PMap<ProgramPoint, Integer> visitedPoints;
    @Nullable
    Symbol lastEvaluated;
    private final PStack<SymbolicValue> stack;
    private final PMap<SymbolicValue, Integer> references;
    private SymbolicValue exitSymbolicValue;
    final PMap<Symbol, SymbolicValue> values;
    final PMap<SymbolicValue, PMap<Class<? extends Constraint>, Constraint>> constraints;

    private ProgramState(PMap<Symbol, SymbolicValue> values, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, PMap<Class<? extends Constraint>, Constraint>> constraints, PMap<ProgramPoint, Integer> visitedPoints, PStack<SymbolicValue> stack, SymbolicValue exitSymbolicValue) {
        this.values = values;
        this.references = references;
        this.constraints = constraints;
        this.visitedPoints = visitedPoints;
        this.stack = stack;
        this.exitSymbolicValue = exitSymbolicValue;
        this.constraintSize = 3;
    }

    private ProgramState(Symbol symbol, PMap<Symbol, SymbolicValue> values, PMap<SymbolicValue, Integer> references, PMap<SymbolicValue, PMap<Class<? extends Constraint>, Constraint>> constraints, PMap<ProgramPoint, Integer> visitedPoints, PStack<SymbolicValue> stack, SymbolicValue exitSymbolicValue) {
        this(values, references, constraints, visitedPoints, stack, exitSymbolicValue);
        this.lastEvaluated = symbol;
    }

    private ProgramState(ProgramState ps, PStack<SymbolicValue> newStack) {
        this.values = ps.values;
        this.references = ps.references;
        this.constraints = ps.constraints;
        this.constraintSize = ps.constraintSize;
        this.visitedPoints = ps.visitedPoints;
        this.exitSymbolicValue = ps.exitSymbolicValue;
        this.stack = newStack;
    }

    private ProgramState(ProgramState ps, PMap<SymbolicValue, PMap<Class<? extends Constraint>, Constraint>> newConstraints) {
        this.values = ps.values;
        this.references = ps.references;
        this.constraints = newConstraints;
        this.constraintSize = ps.constraintSize + 1;
        this.visitedPoints = ps.visitedPoints;
        this.exitSymbolicValue = ps.exitSymbolicValue;
        this.stack = ps.stack;
    }

    public ProgramState stackValue(SymbolicValue sv) {
        return new ProgramState(this, this.stack.push(sv));
    }

    ProgramState clearStack() {
        return this.stack.isEmpty() ? this : new ProgramState(this, PCollections.emptyStack());
    }

    public Pop unstackValue(int nbElements) {
        if (nbElements == 0 || this.stack.isEmpty()) {
            return new Pop(this, Collections.emptyList());
        }
        PStack<SymbolicValue> newStack = this.stack;
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < nbElements && !newStack.isEmpty(); ++i) {
            result.add(newStack.peek());
            newStack = newStack.pop();
        }
        return new Pop(new ProgramState(this, newStack), result);
    }

    @CheckForNull
    public SymbolicValue peekValue() {
        return this.stack.isEmpty() ? null : this.stack.peek();
    }

    public SymbolicValue peekValue(int i) {
        return this.stack.peek(i);
    }

    public List<SymbolicValue> peekValues(int n) {
        ImmutableList.Builder result = ImmutableList.builder();
        PStack<SymbolicValue> tmpStack = this.stack;
        for (int i = 0; i < n; ++i) {
            result.add((Object)tmpStack.peek());
            tmpStack = tmpStack.pop();
        }
        return result.build();
    }

    int numberOfTimeVisited(ProgramPoint programPoint) {
        Integer count = this.visitedPoints.get(programPoint);
        return count == null ? 0 : count;
    }

    @CheckForNull
    public Symbol getLastEvaluated() {
        return this.lastEvaluated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramState that = (ProgramState)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.constraints, that.constraints) && Objects.equals(this.exitSymbolicValue, that.exitSymbolicValue) && Objects.equals(this.stack, that.stack);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.values, this.constraints, this.peekValue());
        }
        return this.hashCode;
    }

    public String toString() {
        return "{" + this.values.toString() + "}  {" + this.constraints.toString() + "} { " + this.stack.toString() + " } { " + this.getLastEvaluated() + " } ";
    }

    public ProgramState addConstraint(SymbolicValue symbolicValue, Constraint constraint) {
        Preconditions.checkState((!(symbolicValue instanceof RelationalSymbolicValue) || constraint != BooleanConstraint.FALSE ? 1 : 0) != 0, (String)"Relations stored in PS should always use TRUE constraint. SV: %s", (Object[])new Object[]{symbolicValue});
        PMap<Class<Constraint>, Constraint> constraintsForSV = this.constraints.get(symbolicValue);
        if (constraintsForSV == null) {
            constraintsForSV = PCollections.emptyMap();
        }
        return this.addConstraints(symbolicValue, constraintsForSV.put(constraint.getClass(), constraint));
    }

    public ProgramState addConstraints(SymbolicValue symbolicValue, PMap<Class<? extends Constraint>, Constraint> constraintsForSV) {
        PMap<SymbolicValue, PMap<Class<? extends Constraint>, Constraint>> newConstraints = this.constraints.put(symbolicValue, constraintsForSV);
        if (newConstraints != this.constraints) {
            return new ProgramState(this, newConstraints);
        }
        return this;
    }

    public ProgramState removeConstraintsOnDomain(SymbolicValue sv, Class<? extends Constraint> domain) {
        PMap<Class<? extends Constraint>, Constraint> svConstraint = this.constraints.get(sv);
        if (svConstraint == null) {
            return this;
        }
        PMap<Class<? extends Constraint>, Constraint> newConstraintForSv = svConstraint.remove(domain);
        if (newConstraintForSv.isEmpty()) {
            return new ProgramState(this, this.constraints.remove(sv));
        }
        return this.addConstraints(sv, newConstraintForSv);
    }

    @VisibleForTesting
    public ProgramState put(Symbol symbol, SymbolicValue value) {
        if (symbol.isUnknown() || ProgramState.isVolatileField(symbol)) {
            return this;
        }
        SymbolicValue oldValue = this.values.get(symbol);
        if (oldValue == null || oldValue != value) {
            PMap<SymbolicValue, Integer> newReferences = this.references;
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            newReferences = ProgramState.increaseReference(newReferences, value);
            PMap<Symbol, SymbolicValue> newValues = this.values.put(symbol, value);
            return new ProgramState(symbol, newValues, newReferences, this.constraints, this.visitedPoints, this.stack, this.exitSymbolicValue);
        }
        if (this.lastEvaluated == null) {
            this.lastEvaluated = symbol;
        }
        return this;
    }

    private static boolean isVolatileField(Symbol symbol) {
        return ProgramState.isField(symbol) && symbol.isVolatile();
    }

    private static PMap<SymbolicValue, Integer> decreaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        Preconditions.checkNotNull((Object)value);
        return givenReferences.put(sv, value - 1);
    }

    private static PMap<SymbolicValue, Integer> increaseReference(PMap<SymbolicValue, Integer> givenReferences, SymbolicValue sv) {
        Integer value = givenReferences.get(sv);
        if (value == null) {
            return givenReferences.put(sv, 1);
        }
        return givenReferences.put(sv, value + 1);
    }

    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable Constraint constraint) {
        return SymbolicValue.isDisposable(symbolicValue) && (constraint == null || !(constraint instanceof UnclosedResourcesCheck.ResourceConstraint) && !(constraint instanceof CustomUnclosedResourcesCheck.CustomResourceConstraint) && !(constraint instanceof LocksNotUnlockedCheck.LockConstraint));
    }

    private static boolean isDisposable(SymbolicValue symbolicValue, @Nullable PMap<Class<? extends Constraint>, Constraint> constraints) {
        return SymbolicValue.isDisposable(symbolicValue) && (constraints == null || constraints.get(UnclosedResourcesCheck.ResourceConstraint.class) == null && constraints.get(CustomUnclosedResourcesCheck.CustomResourceConstraint.class) == null && constraints.get(LocksNotUnlockedCheck.LockConstraint.class) == null);
    }

    private static boolean inStack(PStack<SymbolicValue> stack, SymbolicValue symbolicValue) {
        return stack.anyMatch(sv -> sv.equals(symbolicValue) || sv.references(symbolicValue));
    }

    private static boolean isLocalVariable(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isMethodSymbol();
    }

    public ProgramState cleanupDeadSymbols(final Set<Symbol> liveVariables, final Collection<SymbolicValue> protectedSymbolicValues) {
        class CleanAction
        implements BiConsumer<Symbol, SymbolicValue> {
            boolean newProgramState = false;
            PMap<Symbol, SymbolicValue> newValues;
            PMap<SymbolicValue, Integer> newReferences;
            PMap<SymbolicValue, PMap<Class<? extends Constraint>, Constraint>> newConstraints;

            CleanAction() {
                this.newValues = ProgramState.this.values;
                this.newReferences = ProgramState.this.references;
                this.newConstraints = ProgramState.this.constraints;
            }

            @Override
            public void accept(Symbol symbol, SymbolicValue symbolicValue) {
                if (ProgramState.isLocalVariable(symbol) && !liveVariables.contains(symbol) && !protectedSymbolicValues.contains(symbolicValue)) {
                    this.newProgramState = true;
                    this.newValues = this.newValues.remove(symbol);
                    this.newReferences = ProgramState.decreaseReference(this.newReferences, symbolicValue);
                    if (!ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, this.newConstraints.get(symbolicValue)) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                        this.newConstraints = this.newConstraints.remove(symbolicValue);
                        this.newReferences = this.newReferences.remove(symbolicValue);
                    }
                }
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.values.forEach(cleanAction);
        return cleanAction.newProgramState ? new ProgramState(cleanAction.newValues, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack, this.exitSymbolicValue) : this;
    }

    public ProgramState cleanupConstraints(final Collection<SymbolicValue> protectedSymbolicValues) {
        class CleanAction
        implements BiConsumer<SymbolicValue, PMap<Class<? extends Constraint>, Constraint>> {
            boolean newProgramState = false;
            PMap<SymbolicValue, PMap<Class<? extends Constraint>, Constraint>> newConstraints;
            PMap<SymbolicValue, Integer> newReferences;

            CleanAction() {
                this.newConstraints = ProgramState.this.constraints;
                this.newReferences = ProgramState.this.references;
            }

            @Override
            public void accept(SymbolicValue symbolicValue, PMap<Class<? extends Constraint>, Constraint> constraintPMap) {
                constraintPMap.forEach((domain, constraint) -> {
                    if (!protectedSymbolicValues.contains(symbolicValue) && !ProgramState.isReachable(symbolicValue, this.newReferences) && ProgramState.isDisposable(symbolicValue, constraint) && !ProgramState.inStack(ProgramState.this.stack, symbolicValue)) {
                        this.newProgramState = true;
                        PMap<Class<? extends Constraint>, Constraint> removed = this.newConstraints.get(symbolicValue).remove((Class<? extends Constraint>)domain);
                        this.newConstraints = removed.isEmpty() ? this.newConstraints.remove(symbolicValue) : this.newConstraints.put(symbolicValue, removed);
                        this.newReferences = this.newReferences.remove(symbolicValue);
                    }
                });
            }
        }
        CleanAction cleanAction = new CleanAction();
        this.constraints.forEach(cleanAction);
        return cleanAction.newProgramState ? new ProgramState(this.values, cleanAction.newReferences, cleanAction.newConstraints, this.visitedPoints, this.stack, this.exitSymbolicValue) : this;
    }

    public ProgramState resetFieldValues(ConstraintManager constraintManager) {
        ArrayList variableTrees = new ArrayList();
        this.values.forEach((symbol, symbolicValue) -> {
            VariableTree variable;
            if (ProgramState.isField(symbol) && (variable = ((Symbol.VariableSymbol)symbol).declaration()) != null) {
                variableTrees.add(variable);
            }
        });
        if (variableTrees.isEmpty()) {
            return this;
        }
        PMap<Symbol, SymbolicValue> newValues = this.values;
        PMap<SymbolicValue, Integer> newReferences = this.references;
        for (VariableTree variableTree : variableTrees) {
            Symbol symbol2 = variableTree.symbol();
            SymbolicValue oldValue = newValues.get(symbol2);
            if (oldValue != null) {
                newReferences = ProgramState.decreaseReference(newReferences, oldValue);
            }
            SymbolicValue newValue = constraintManager.createSymbolicValue(variableTree);
            newValues = newValues.put(symbol2, newValue);
            newReferences = ProgramState.increaseReference(newReferences, newValue);
        }
        return new ProgramState(newValues, newReferences, this.constraints, this.visitedPoints, this.stack, this.exitSymbolicValue);
    }

    public static boolean isField(Symbol symbol) {
        return symbol.isVariableSymbol() && !symbol.owner().isMethodSymbol();
    }

    private static boolean isReachable(SymbolicValue symbolicValue, PMap<SymbolicValue, Integer> references) {
        Integer integer = references.get(symbolicValue);
        return integer != null && integer > 0;
    }

    public boolean canReach(SymbolicValue symbolicValue) {
        return ProgramState.isReachable(symbolicValue, this.references);
    }

    public ProgramState visitedPoint(ProgramPoint programPoint, int nbOfVisit) {
        return new ProgramState(this.values, this.references, this.constraints, this.visitedPoints.put(programPoint, nbOfVisit), this.stack, this.exitSymbolicValue);
    }

    @Nullable
    public PMap<Class<? extends Constraint>, Constraint> getConstraints(SymbolicValue sv) {
        return this.constraints.get(sv);
    }

    @CheckForNull
    public <T extends Constraint> T getConstraint(SymbolicValue sv, Class<T> domain) {
        PMap<Class<? extends Constraint>, Constraint> classConstraintPMap = this.constraints.get(sv);
        if (classConstraintPMap == null) {
            return null;
        }
        return (T)classConstraintPMap.get(domain);
    }

    public int constraintsSize() {
        return this.constraintSize;
    }

    @CheckForNull
    public SymbolicValue getValue(Symbol symbol) {
        return this.values.get(symbol);
    }

    public List<SymbolicValue> getValuesWithConstraints(Constraint constraint) {
        ArrayList<SymbolicValue> result = new ArrayList<SymbolicValue>();
        this.constraints.forEach((symbolicValue, constraintByDomain) -> {
            Constraint find = (Constraint)constraintByDomain.get(constraint.getClass());
            if (constraint.equals(find)) {
                result.add((SymbolicValue)symbolicValue);
            }
        });
        return result;
    }

    public List<BinaryRelation> getKnownRelations() {
        ArrayList<BinaryRelation> knownRelations = new ArrayList<BinaryRelation>();
        this.constraints.forEach((symbolicValue, pMap) -> {
            BinaryRelation relation = symbolicValue.binaryRelation();
            if (relation != null) {
                if (BooleanConstraint.TRUE.equals(pMap.get(BooleanConstraint.class))) {
                    knownRelations.add(relation);
                } else if (BooleanConstraint.FALSE.equals(pMap.get(BooleanConstraint.class))) {
                    knownRelations.add(relation.inverse());
                }
            }
        });
        return knownRelations;
    }

    public void storeExitValue() {
        this.exitSymbolicValue = this.peekValue();
    }

    @CheckForNull
    public SymbolicValue exitValue() {
        return this.exitSymbolicValue;
    }

    public boolean exitingOnRuntimeException() {
        return this.exitSymbolicValue instanceof SymbolicValue.ExceptionalSymbolicValue && ((SymbolicValue.ExceptionalSymbolicValue)this.exitSymbolicValue).exceptionType() == null;
    }

    Set<LearnedConstraint> learnedConstraints(ProgramState parent) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        this.constraints.forEach((sv, pmap) -> pmap.forEach((domain, c) -> {
            if (!c.equals(parent.getConstraint((SymbolicValue)sv, (Class)domain))) {
                ProgramState.addLearnedConstraint((ImmutableSet.Builder<LearnedConstraint>)result, sv, c);
            }
        }));
        return result.build();
    }

    private static void addLearnedConstraint(ImmutableSet.Builder<LearnedConstraint> result, SymbolicValue sv, Constraint c) {
        result.add((Object)new LearnedConstraint(sv, c));
        if (sv instanceof BinarySymbolicValue) {
            BinarySymbolicValue binarySymbolicValue = (BinarySymbolicValue)sv;
            ProgramState.addLearnedConstraint(result, binarySymbolicValue.getLeftOp(), null);
            ProgramState.addLearnedConstraint(result, binarySymbolicValue.getRightOp(), null);
        }
    }

    Set<LearnedAssociation> learnedAssociations(ProgramState parent) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        this.values.forEach((s, sv) -> {
            if (parent.getValue((Symbol)s) != sv) {
                result.add((Object)new LearnedAssociation((SymbolicValue)sv, (Symbol)s));
            }
        });
        return result.build();
    }

    public static class Pop {
        public final ProgramState state;
        public final List<SymbolicValue> values;

        public Pop(ProgramState programState, List<SymbolicValue> result) {
            this.state = programState;
            this.values = result;
        }
    }
}

