/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.ExceptionalYieldChecker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S3518")
public class DivisionByZeroCheck
extends SECheck {
    private static final ExceptionalYieldChecker EXCEPTIONAL_YIELD_CHECKER = new ExceptionalYieldChecker("A division by zero will occur when invoking method %s().");

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        EXCEPTIONAL_YIELD_CHECKER.reportOnExceptionalYield(context.getNode(), this);
    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitLiteral(LiteralTree tree) {
            String value = tree.value();
            SymbolicValue sv = this.programState.peekValue();
            if (tree.is(Tree.Kind.CHAR_LITERAL) && PostStatementVisitor.isNullCharacter(value)) {
                this.addZeroConstraint(sv, ZeroConstraint.ZERO);
            } else if (tree.is(Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL)) {
                this.addZeroConstraint(sv, PostStatementVisitor.isNumberZero(value) ? ZeroConstraint.ZERO : ZeroConstraint.NON_ZERO);
            }
        }

        private static boolean isNumberZero(String literalValue) {
            return !literalValue.matches("(.)*[1-9]+(.)*") && !literalValue.matches("(0x|0X){1}(.)*[1-9a-fA-F]+(.)*") && !literalValue.matches("(0b|0B){1}(.)*[1]+(.)*");
        }

        private static boolean isNullCharacter(String literalValue) {
            return "'\\0'".equals(literalValue) || "'\\u0000'".equals(literalValue);
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        @Override
        public void visitUnaryExpression(UnaryExpressionTree tree) {
            this.checkDeferredConstraint();
        }

        @Override
        public void visitTypeCast(TypeCastTree tree) {
            this.checkDeferredConstraint();
        }

        private void checkDeferredConstraint() {
            SymbolicValue sv = this.programState.peekValue();
            if (sv instanceof DeferredConstraintHolderSV) {
                this.addZeroConstraint(sv, ((DeferredConstraintHolderSV)sv).deferredConstraint);
            }
        }

        private void addZeroConstraint(SymbolicValue sv, @Nullable ZeroConstraint zeroConstraint) {
            this.programState = zeroConstraint == null ? this.programState.removeConstraintsOnDomain(sv, ZeroConstraint.class) : this.programState.addConstraint(sv, zeroConstraint);
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final ConstraintManager constraintManager;
        private final CheckerContext context;

        PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.context = context;
            this.constraintManager = context.getConstraintManager();
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            SymbolicValue expr;
            SymbolicValue var;
            if (ExpressionUtils.isSimpleAssignment(tree)) {
                var = this.programState.getValue(ExpressionUtils.extractIdentifier(tree).symbol());
                expr = this.programState.peekValue();
            } else {
                List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
                var = symbolicValues.get(1);
                expr = symbolicValues.get(0);
            }
            this.checkExpression(tree, var, expr);
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            switch (tree.kind()) {
                case MULTIPLY: 
                case PLUS: 
                case MINUS: 
                case DIVIDE: 
                case REMAINDER: {
                    List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
                    this.checkExpression(tree, symbolicValues.get(1), symbolicValues.get(0));
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL_TO: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL_TO: {
                    List<SymbolicValue> symbolicValues = this.programState.peekValues(2);
                    this.removeZeroConstraint(symbolicValues.get(1));
                    this.removeZeroConstraint(symbolicValues.get(0));
                    break;
                }
            }
        }

        private void removeZeroConstraint(SymbolicValue sv) {
            this.programState = this.programState.removeConstraintsOnDomain(sv, ZeroConstraint.class);
        }

        private void checkExpression(Tree tree, SymbolicValue leftOp, SymbolicValue rightOp) {
            switch (tree.kind()) {
                case MULTIPLY: 
                case MULTIPLY_ASSIGNMENT: {
                    this.handleMultiply(leftOp, rightOp);
                    break;
                }
                case PLUS: 
                case MINUS: 
                case PLUS_ASSIGNMENT: 
                case MINUS_ASSIGNMENT: {
                    this.handlePlusMinus(leftOp, rightOp);
                    break;
                }
                case DIVIDE: 
                case REMAINDER: 
                case DIVIDE_ASSIGNMENT: 
                case REMAINDER_ASSIGNMENT: {
                    this.handleDivide(tree, leftOp, rightOp);
                    break;
                }
            }
        }

        private boolean isZero(SymbolicValue symbolicValue) {
            return this.hasConstraint(symbolicValue, ZeroConstraint.ZERO);
        }

        private boolean isNonZero(SymbolicValue symbolicValue) {
            return this.hasConstraint(symbolicValue, ZeroConstraint.NON_ZERO);
        }

        private boolean hasNoConstraint(SymbolicValue symbolicValue) {
            return this.hasConstraint(symbolicValue, null);
        }

        private boolean hasConstraint(SymbolicValue symbolicValue, ZeroConstraint constraint) {
            return this.programState.getConstraint(symbolicValue, ZeroConstraint.class) == constraint;
        }

        private void handleMultiply(SymbolicValue left, SymbolicValue right) {
            boolean leftIsZero = this.isZero(left);
            if (leftIsZero || this.isZero(right)) {
                this.reuseSymbolicValue(leftIsZero ? left : right);
            } else if (this.isNonZero(left) && this.isNonZero(right)) {
                this.deferConstraint(ZeroConstraint.NON_ZERO);
            }
        }

        private void handlePlusMinus(SymbolicValue left, SymbolicValue right) {
            boolean leftIsZero = this.isZero(left);
            if (leftIsZero || this.isZero(right)) {
                this.reuseSymbolicValue(leftIsZero ? right : left);
            }
        }

        private void handleDivide(Tree tree, SymbolicValue leftOp, SymbolicValue rightOp) {
            if (this.isZero(rightOp)) {
                this.context.addExceptionalYield(rightOp, this.programState, "java.lang.ArithmeticException", DivisionByZeroCheck.this);
                this.reportIssue(tree, rightOp);
                this.programState = null;
            } else if (this.isZero(leftOp)) {
                this.reuseSymbolicValue(leftOp);
            } else if (this.isNonZero(leftOp) && this.isNonZero(rightOp)) {
                this.deferConstraint(tree.is(Tree.Kind.DIVIDE, Tree.Kind.DIVIDE_ASSIGNMENT) ? ZeroConstraint.NON_ZERO : null);
            } else if (this.hasNoConstraint(rightOp)) {
                ProgramState exceptionalState = this.programState.addConstraint(rightOp, ZeroConstraint.ZERO).addConstraint(rightOp, ObjectConstraint.NOT_NULL);
                this.context.addExceptionalYield(rightOp, exceptionalState, "java.lang.ArithmeticException", DivisionByZeroCheck.this);
            }
        }

        private void deferConstraint(@Nullable ZeroConstraint constraint) {
            this.constraintManager.setValueFactory(() -> new DeferredConstraintHolderSV(constraint));
        }

        private void reuseSymbolicValue(final SymbolicValue sv) {
            this.constraintManager.setValueFactory(() -> new DeferredConstraintHolderSV(this.programState.getConstraint(sv, ZeroConstraint.class)){

                @Override
                public SymbolicValue wrappedValue() {
                    return sv.wrappedValue();
                }
            });
        }

        private void reportIssue(Tree tree, SymbolicValue denominator) {
            String flowMessage;
            String expressionName;
            String operation;
            ExpressionTree expression = this.getDenominator(tree);
            String string = operation = tree.is(Tree.Kind.REMAINDER, Tree.Kind.REMAINDER_ASSIGNMENT) ? "modulation" : "division";
            if (expression.is(Tree.Kind.IDENTIFIER)) {
                String name = ((IdentifierTree)expression).name();
                expressionName = "'" + name + "'";
                flowMessage = expressionName + " is divided by zero";
            } else {
                expressionName = "this expression";
                flowMessage = "this expression contains division by zero";
            }
            ArrayList domains = Lists.newArrayList((Object[])new Class[]{ZeroConstraint.class});
            Set<List<JavaFileScannerContext.Location>> flows = FlowComputation.flow(this.context.getNode(), denominator, domains).stream().map(f -> ImmutableList.builder().add((Object)new JavaFileScannerContext.Location(flowMessage, tree)).addAll((Iterable)f).build()).collect(Collectors.toSet());
            this.context.reportIssue(expression, DivisionByZeroCheck.this, "Make sure " + expressionName + " can't be zero before doing this " + operation + ".", flows);
        }

        private ExpressionTree getDenominator(Tree tree) {
            return tree.is(Tree.Kind.DIVIDE, Tree.Kind.REMAINDER) ? ((BinaryExpressionTree)tree).rightOperand() : ((AssignmentExpressionTree)tree).expression();
        }

        @Override
        public void visitTypeCast(TypeCastTree tree) {
            Type type = tree.type().symbolType();
            if (type.isPrimitive()) {
                SymbolicValue sv = this.programState.peekValue();
                if (this.isZero(sv)) {
                    this.reuseSymbolicValue(sv);
                } else if (this.isNonZero(sv)) {
                    this.deferConstraint(ZeroConstraint.NON_ZERO);
                }
            }
        }

        @Override
        public void visitUnaryExpression(UnaryExpressionTree tree) {
            if (!tree.is(Tree.Kind.LOGICAL_COMPLEMENT)) {
                SymbolicValue sv = this.programState.peekValue();
                if (this.isZero(sv)) {
                    if (tree.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
                        this.reuseSymbolicValue(sv);
                    } else {
                        this.deferConstraint(ZeroConstraint.NON_ZERO);
                    }
                } else {
                    this.deferConstraint(null);
                }
            }
        }
    }

    private static class DeferredConstraintHolderSV
    extends SymbolicValue {
        @Nullable
        private final ZeroConstraint deferredConstraint;

        DeferredConstraintHolderSV(@Nullable ZeroConstraint deferredConstraint) {
            this.deferredConstraint = deferredConstraint;
        }
    }

    @VisibleForTesting
    public static enum ZeroConstraint implements Constraint
    {
        ZERO,
        NON_ZERO;


        @Override
        public String valueAsString() {
            if (this == ZERO) {
                return "zero";
            }
            return "non-zero";
        }

        @Override
        public boolean isValidWith(@Nullable Constraint constraint) {
            return constraint == null || this == constraint;
        }

        @Override
        @Nullable
        public Constraint copyOver(RelationalSymbolicValue.Kind kind) {
            switch (kind) {
                case EQUAL: 
                case METHOD_EQUALS: {
                    return this;
                }
                case LESS_THAN: 
                case GREATER_THAN: 
                case NOT_EQUAL: 
                case NOT_METHOD_EQUALS: {
                    return this.inverse();
                }
            }
            return null;
        }

        @Override
        public Constraint inverse() {
            if (this == ZERO) {
                return NON_ZERO;
            }
            return null;
        }
    }
}

