/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.RelationStateTable;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class BinaryRelation {
    private static final int MAX_ITERATIONS = 10000;
    private static final int MAX_DEDUCED_RELATIONS = 1000;
    private static final Set<RelationalSymbolicValue.Kind> NORMALIZED_OPERATORS = EnumSet.of(RelationalSymbolicValue.Kind.EQUAL, new RelationalSymbolicValue.Kind[]{RelationalSymbolicValue.Kind.NOT_EQUAL, RelationalSymbolicValue.Kind.LESS_THAN, RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL, RelationalSymbolicValue.Kind.METHOD_EQUALS, RelationalSymbolicValue.Kind.NOT_METHOD_EQUALS});
    protected final RelationalSymbolicValue.Kind kind;
    protected final SymbolicValue leftOp;
    protected final SymbolicValue rightOp;
    private BinaryRelation inverse;
    private final int hashcode;

    private BinaryRelation(RelationalSymbolicValue.Kind kind, SymbolicValue v1, SymbolicValue v2) {
        if (!NORMALIZED_OPERATORS.contains((Object)kind)) {
            throw new IllegalArgumentException("Relation " + v1 + kind.operand + v2 + " not normalized!");
        }
        this.kind = kind;
        this.leftOp = v1;
        this.rightOp = v2;
        this.hashcode = this.computeHash();
    }

    private int computeHash() {
        return 31 * (this.kind.hashCode() + this.leftOp.hashCode() + this.rightOp.hashCode());
    }

    static BinaryRelation binaryRelation(RelationalSymbolicValue.Kind kind, SymbolicValue leftOp, SymbolicValue rightOp) {
        switch (kind) {
            case EQUAL: 
            case NOT_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case METHOD_EQUALS: 
            case NOT_METHOD_EQUALS: {
                return new BinaryRelation(kind, leftOp, rightOp);
            }
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: {
                return new BinaryRelation(kind.symmetric(), rightOp, leftOp);
            }
        }
        throw new IllegalStateException("Creation of relation of kind " + (Object)((Object)kind) + " is missing!");
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BinaryRelation) {
            return this.equalsRelation((BinaryRelation)obj);
        }
        return false;
    }

    private boolean equalsRelation(BinaryRelation other) {
        if (!this.kind.equals((Object)other.kind)) {
            return false;
        }
        switch (this.kind) {
            case EQUAL: 
            case NOT_EQUAL: 
            case METHOD_EQUALS: 
            case NOT_METHOD_EQUALS: {
                return this.hasSameOperandsAs(other);
            }
        }
        return this.leftOp.equals(other.leftOp) && this.rightOp.equals(other.rightOp);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.leftOp);
        buffer.append(this.kind.operand);
        buffer.append(this.rightOp);
        return buffer.toString();
    }

    protected RelationState resolveState(List<BinaryRelation> knownRelations) {
        if (this.hasSameOperand()) {
            return this.relationStateForSameOperand();
        }
        HashSet<BinaryRelation> allRelations = new HashSet<BinaryRelation>(knownRelations);
        ArrayDeque<BinaryRelation> workList = new ArrayDeque<BinaryRelation>(knownRelations);
        int iterations = 0;
        while (!workList.isEmpty()) {
            if (allRelations.size() > 1000 || iterations > 10000) {
                throw new TransitiveRelationExceededException("Used relations: " + allRelations.size() + ". Iterations " + iterations);
            }
            ++iterations;
            BinaryRelation relation = (BinaryRelation)workList.pop();
            RelationState result = relation.implies(this);
            if (result.isDetermined()) {
                return result;
            }
            List newRelations = allRelations.stream().map(relation::deduceTransitiveOrSimplified).filter(Objects::nonNull).filter(r -> !allRelations.contains(r)).collect(Collectors.toList());
            allRelations.addAll(newRelations);
            workList.addAll(newRelations);
        }
        return RelationState.UNDETERMINED;
    }

    @VisibleForTesting
    BinaryRelation deduceTransitiveOrSimplified(BinaryRelation other) {
        BinaryRelation result = this.simplify(other);
        if (result != null) {
            return result;
        }
        return this.combineTransitively(other);
    }

    @CheckForNull
    private BinaryRelation simplify(BinaryRelation other) {
        if (this.kind == RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL && other.kind == RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL && this.hasSameOperandsAs(other) && !this.equals(other)) {
            return BinaryRelation.binaryRelation(RelationalSymbolicValue.Kind.EQUAL, this.leftOp, this.rightOp);
        }
        return null;
    }

    private boolean hasSameOperand() {
        return this.leftOp.equals(this.rightOp);
    }

    private boolean hasOperand(SymbolicValue operand) {
        return this.leftOp.equals(operand) || this.rightOp.equals(operand);
    }

    private boolean hasSameOperandsAs(BinaryRelation other) {
        return this.leftOp.equals(other.leftOp) && this.rightOp.equals(other.rightOp) || this.leftOp.equals(other.rightOp) && this.rightOp.equals(other.leftOp);
    }

    @VisibleForTesting
    SymbolicValue differentOperand(BinaryRelation other) {
        Preconditions.checkState((boolean)this.potentiallyTransitiveWith(other), (String)"%s is not in transitive relationship with %s", (Object[])new Object[]{this, other});
        return other.hasOperand(this.leftOp) ? this.rightOp : this.leftOp;
    }

    @VisibleForTesting
    SymbolicValue commonOperand(BinaryRelation other) {
        Preconditions.checkState((boolean)this.potentiallyTransitiveWith(other));
        return other.hasOperand(this.leftOp) ? this.leftOp : this.rightOp;
    }

    @VisibleForTesting
    boolean potentiallyTransitiveWith(BinaryRelation other) {
        if (this.hasSameOperand() || other.hasSameOperand()) {
            return false;
        }
        return (this.hasOperand(other.leftOp) || this.hasOperand(other.rightOp)) && !this.hasSameOperandsAs(other);
    }

    private RelationState relationStateForSameOperand() {
        switch (this.kind) {
            case EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case METHOD_EQUALS: {
                return RelationState.FULFILLED;
            }
            case NOT_EQUAL: 
            case LESS_THAN: 
            case NOT_METHOD_EQUALS: {
                return RelationState.UNFULFILLED;
            }
        }
        throw new IllegalStateException("Unknown resolution for same operand " + this);
    }

    public BinaryRelation inverse() {
        if (this.inverse == null) {
            this.inverse = BinaryRelation.binaryRelation(this.kind.inverse(), this.leftOp, this.rightOp);
        }
        return this.inverse;
    }

    private RelationState implies(BinaryRelation relation) {
        if (this.equals(relation)) {
            return RelationState.FULFILLED;
        }
        if (this.inverse().equals(relation)) {
            return RelationState.UNFULFILLED;
        }
        if (this.hasSameOperandsAs(relation)) {
            return RelationStateTable.solveRelation(this.kind, relation.kind);
        }
        return RelationState.UNDETERMINED;
    }

    @CheckForNull
    private BinaryRelation combineTransitively(BinaryRelation other) {
        if (!this.potentiallyTransitiveWith(other)) {
            return null;
        }
        BinaryRelation transitive = this.combineTransitivelyOneWay(other);
        if (transitive != null) {
            return transitive;
        }
        return other.combineTransitivelyOneWay(this);
    }

    @CheckForNull
    private BinaryRelation combineTransitivelyOneWay(BinaryRelation other) {
        BinaryRelation transitive = this.equalityTransitiveBuilder(other);
        if (transitive != null) {
            return transitive;
        }
        transitive = this.lessThanTransitiveBuilder(other);
        if (transitive != null) {
            return transitive;
        }
        return this.greaterThanEqualTransitiveBuilder(other);
    }

    private boolean isEqualityRelation() {
        return this.kind == RelationalSymbolicValue.Kind.EQUAL || this.kind == RelationalSymbolicValue.Kind.METHOD_EQUALS;
    }

    @CheckForNull
    private BinaryRelation equalityTransitiveBuilder(BinaryRelation other) {
        if (!this.isEqualityRelation() || this.kind == RelationalSymbolicValue.Kind.METHOD_EQUALS && other.kind == RelationalSymbolicValue.Kind.EQUAL) {
            return null;
        }
        return BinaryRelation.binaryRelation(other.kind, this.hasOperand(other.leftOp) ? this.differentOperand(other) : other.leftOp, this.hasOperand(other.leftOp) ? other.rightOp : this.differentOperand(other));
    }

    @CheckForNull
    private BinaryRelation lessThanTransitiveBuilder(BinaryRelation other) {
        if (this.kind != RelationalSymbolicValue.Kind.LESS_THAN) {
            return null;
        }
        if (other.kind == RelationalSymbolicValue.Kind.LESS_THAN) {
            if (this.rightOp.equals(other.leftOp)) {
                return BinaryRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN, this.leftOp, other.rightOp);
            }
            if (this.leftOp.equals(other.rightOp)) {
                return BinaryRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN, other.leftOp, this.rightOp);
            }
        }
        if (other.kind == RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL) {
            if (this.rightOp.equals(other.rightOp)) {
                return BinaryRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN, this.leftOp, other.leftOp);
            }
            if (this.leftOp.equals(other.leftOp)) {
                return BinaryRelation.binaryRelation(RelationalSymbolicValue.Kind.LESS_THAN, other.rightOp, this.rightOp);
            }
        }
        return null;
    }

    @CheckForNull
    private BinaryRelation greaterThanEqualTransitiveBuilder(BinaryRelation other) {
        if (this.kind == RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL && other.kind == RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL && this.rightOp.equals(other.leftOp)) {
            return BinaryRelation.binaryRelation(RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL, this.leftOp, other.rightOp);
        }
        return null;
    }

    public static class TransitiveRelationExceededException
    extends RuntimeException {
        public TransitiveRelationExceededException(String msg) {
            super("Number of transitive relations exceeded!" + msg);
        }
    }
}

