/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.BinaryRelation;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.RelationState;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public class RelationalSymbolicValue
extends BinarySymbolicValue {
    final Kind kind;
    private BinaryRelation binaryRelation;

    public RelationalSymbolicValue(Kind kind) {
        this.kind = kind;
    }

    @VisibleForTesting
    RelationalSymbolicValue(Kind kind, SymbolicValue leftOp, SymbolicValue rightOp) {
        this.kind = kind;
        this.leftOp = leftOp;
        this.rightOp = rightOp;
    }

    @Override
    public List<ProgramState> setConstraint(ProgramState initialProgramState, BooleanConstraint booleanConstraint) {
        if (!this.checkRelation(booleanConstraint, initialProgramState)) {
            return ImmutableList.of();
        }
        return booleanConstraint == BooleanConstraint.TRUE ? this.getNewProgramStates(initialProgramState) : this.inverse().getNewProgramStates(initialProgramState);
    }

    private List<ProgramState> getNewProgramStates(ProgramState initialProgramState) {
        List<RelationalSymbolicValue> newRelations = this.transitiveRelations(initialProgramState);
        newRelations.add(this);
        ArrayList<ProgramState> programStates = new ArrayList<ProgramState>();
        programStates.add(initialProgramState);
        for (RelationalSymbolicValue relationalSymbolicValue : newRelations) {
            ArrayList<ProgramState> intermediateStates = new ArrayList<ProgramState>();
            for (ProgramState programState : programStates) {
                intermediateStates.addAll(relationalSymbolicValue.copyAllConstraints(programState));
            }
            programStates = intermediateStates;
        }
        return programStates;
    }

    RelationalSymbolicValue inverse() {
        return new RelationalSymbolicValue(this.kind.inverse(), this.leftOp, this.rightOp);
    }

    private List<ProgramState> copyAllConstraints(ProgramState programState) {
        ArrayList<ProgramState> results = new ArrayList<ProgramState>();
        List<ProgramState> copiedConstraints = this.copyConstraint(this.leftOp, this.rightOp, programState);
        if (Kind.METHOD_EQUALS == this.kind || Kind.NOT_METHOD_EQUALS == this.kind) {
            copiedConstraints = this.addNullConstraintsForBooleanWrapper(programState, copiedConstraints);
        }
        for (ProgramState ps : copiedConstraints) {
            List<ProgramState> copiedConstraintsRightToLeft = this.copyConstraint(this.rightOp, this.leftOp, ps);
            if (copiedConstraintsRightToLeft.size() == 1 && copiedConstraintsRightToLeft.get(0).equals(programState)) {
                results.add(programState.addConstraint(this, BooleanConstraint.TRUE));
                continue;
            }
            results.addAll(copiedConstraintsRightToLeft);
        }
        return results;
    }

    private List<ProgramState> addNullConstraintsForBooleanWrapper(ProgramState initialProgramState, List<ProgramState> copiedConstraints) {
        BooleanConstraint leftConstraint = initialProgramState.getConstraint(this.leftOp, BooleanConstraint.class);
        BooleanConstraint rightConstraint = initialProgramState.getConstraint(this.rightOp, BooleanConstraint.class);
        if (leftConstraint != null && rightConstraint == null && !this.isEquality()) {
            List nullConstraints = copiedConstraints.stream().flatMap(ps -> this.rightOp.setConstraint((ProgramState)ps, ObjectConstraint.NULL).stream()).map(ps -> ps.removeConstraintsOnDomain(this.rightOp, BooleanConstraint.class)).collect(Collectors.toList());
            return ImmutableList.builder().addAll(copiedConstraints).addAll(nullConstraints).build();
        }
        return copiedConstraints;
    }

    private List<ProgramState> copyConstraint(SymbolicValue from, SymbolicValue to, ProgramState programState) {
        ProgramState newState = programState;
        if (programState.canReach(from) || programState.canReach(to)) {
            newState = programState.addConstraint(this, BooleanConstraint.TRUE);
        }
        return this.copyConstraintFromTo(from, to, newState);
    }

    private List<ProgramState> copyConstraintFromTo(SymbolicValue from, SymbolicValue to, ProgramState programState) {
        ArrayList<ProgramState> states = new ArrayList<ProgramState>();
        states.add(programState);
        PMap<Class<? extends Constraint>, Constraint> leftConstraints = programState.getConstraints(from);
        if (leftConstraints != null) {
            leftConstraints.forEach((d, c) -> {
                ArrayList newStates = new ArrayList();
                Constraint constraint = c.copyOver(this.kind);
                states.forEach(state -> {
                    if (constraint == null) {
                        PMap<Class<? extends Constraint>, Constraint> constraints = state.getConstraints(to);
                        if (constraints != null) {
                            newStates.add(state.removeConstraintsOnDomain(to, c.getClass()));
                        } else {
                            newStates.add(state);
                        }
                    } else if (ObjectConstraint.NULL == constraint && c != constraint) {
                        newStates.add(state);
                    } else {
                        newStates.addAll(to.setConstraint((ProgramState)state, constraint));
                    }
                });
                states.clear();
                states.addAll(newStates);
            });
        }
        return states;
    }

    private boolean checkRelation(BooleanConstraint booleanConstraint, ProgramState programState) {
        RelationState relationState = this.binaryRelation().resolveState(programState.getKnownRelations());
        return !relationState.rejects(booleanConstraint);
    }

    private List<RelationalSymbolicValue> transitiveRelations(ProgramState programState) {
        BinaryRelation relation = this.binaryRelation();
        return programState.getKnownRelations().stream().map(r -> r.deduceTransitiveOrSimplified(relation)).filter(Objects::nonNull).map(RelationalSymbolicValue::binaryRelationToSymbolicValue).collect(Collectors.toList());
    }

    private static RelationalSymbolicValue binaryRelationToSymbolicValue(BinaryRelation binaryRelation) {
        switch (binaryRelation.kind) {
            case EQUAL: 
            case NOT_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case METHOD_EQUALS: 
            case NOT_METHOD_EQUALS: {
                return new RelationalSymbolicValue(binaryRelation.kind, binaryRelation.leftOp, binaryRelation.rightOp);
            }
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return new RelationalSymbolicValue(binaryRelation.kind.symmetric(), binaryRelation.rightOp, binaryRelation.leftOp);
            }
        }
        throw new IllegalStateException("Unable to convert to relational SV " + binaryRelation);
    }

    @Override
    public BinaryRelation binaryRelation() {
        if (this.binaryRelation == null) {
            this.binaryRelation = BinaryRelation.binaryRelation(this.kind, this.leftOp, this.rightOp);
        }
        return this.binaryRelation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationalSymbolicValue that = (RelationalSymbolicValue)o;
        if (this.kind != that.kind) {
            return false;
        }
        if (this.leftOp.equals(that.leftOp) && this.rightOp.equals(that.rightOp)) {
            return true;
        }
        return this.isEquality() && this.leftOp.equals(that.rightOp) && this.rightOp.equals(that.leftOp);
    }

    private boolean isEquality() {
        return this.kind == Kind.EQUAL || this.kind == Kind.METHOD_EQUALS;
    }

    public int hashCode() {
        return this.kind.hashCode() + this.leftOp.hashCode() + this.rightOp.hashCode();
    }

    @Override
    public String toString() {
        return this.leftOp.toString() + this.kind.operand + this.rightOp.toString();
    }

    public static enum Kind {
        EQUAL("=="),
        NOT_EQUAL("!="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        METHOD_EQUALS(".EQ."),
        NOT_METHOD_EQUALS(".NE.");

        final String operand;

        private Kind(String operand) {
            this.operand = operand;
        }

        public Kind inverse() {
            switch (this) {
                case EQUAL: {
                    return NOT_EQUAL;
                }
                case NOT_EQUAL: {
                    return EQUAL;
                }
                case GREATER_THAN: {
                    return LESS_THAN_OR_EQUAL;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return LESS_THAN;
                }
                case LESS_THAN: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case LESS_THAN_OR_EQUAL: {
                    return GREATER_THAN;
                }
                case METHOD_EQUALS: {
                    return NOT_METHOD_EQUALS;
                }
                case NOT_METHOD_EQUALS: {
                    return METHOD_EQUALS;
                }
            }
            throw new IllegalStateException("Unsupported relation!");
        }

        public Kind symmetric() {
            Kind sym;
            switch (this) {
                case GREATER_THAN: {
                    sym = LESS_THAN;
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    sym = LESS_THAN_OR_EQUAL;
                    break;
                }
                case LESS_THAN: {
                    sym = GREATER_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    sym = GREATER_THAN_OR_EQUAL;
                    break;
                }
                default: {
                    sym = this;
                }
            }
            return sym;
        }
    }
}

