/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;

public abstract class MethodYield {
    final ExplodedGraph.Node node;
    private final MethodBehavior behavior;
    List<PMap<Class<? extends Constraint>, Constraint>> parametersConstraints = new ArrayList<PMap<Class<? extends Constraint>, Constraint>>();

    public MethodYield(MethodBehavior behavior) {
        this.node = null;
        this.behavior = behavior;
    }

    public MethodYield(ExplodedGraph.Node node, MethodBehavior behavior) {
        this.node = node;
        this.behavior = behavior;
    }

    public abstract Stream<ProgramState> statesAfterInvocation(List<SymbolicValue> var1, List<Type> var2, ProgramState var3, Supplier<SymbolicValue> var4);

    public Stream<ProgramState> parametersAfterInvocation(List<SymbolicValue> invocationArguments, List<Type> invocationTypes, ProgramState programState) {
        Set<ProgramState> results = new LinkedHashSet<ProgramState>();
        for (int index = 0; index < invocationArguments.size(); ++index) {
            PMap<Class<? extends Constraint>, Constraint> constraints = this.getConstraint(index, invocationTypes);
            if (constraints == null) continue;
            SymbolicValue invokedArg = invocationArguments.get(index);
            Set<ProgramState> programStates = MethodYield.programStatesForConstraint(results.isEmpty() ? Lists.newArrayList((Object[])new ProgramState[]{programState}) : results, invokedArg, constraints);
            if (programStates.isEmpty()) {
                return Stream.empty();
            }
            results = programStates;
        }
        if (results.isEmpty()) {
            results.add(programState);
        }
        return results.stream();
    }

    @CheckForNull
    private PMap<Class<? extends Constraint>, Constraint> getConstraint(int index, List<Type> invocationTypes) {
        if (!this.behavior.isMethodVarArgs() || this.applicableOnVarArgs(index, invocationTypes)) {
            return this.parametersConstraints.get(index);
        }
        return null;
    }

    private boolean applicableOnVarArgs(int index, List<Type> types) {
        if (index < this.parametersConstraints.size() - 1) {
            return true;
        }
        if (this.parametersConstraints.size() != types.size()) {
            return false;
        }
        Type argumentType = types.get(index);
        return argumentType.isArray() || argumentType.is("<nulltype>");
    }

    private static Set<ProgramState> programStatesForConstraint(Collection<ProgramState> states, SymbolicValue invokedArg, PMap<Class<? extends Constraint>, Constraint> constraints) {
        LinkedHashSet<ProgramState> programStates = new LinkedHashSet<ProgramState>(states);
        constraints.forEach((d, c) -> {
            LinkedHashSet<ProgramState> newPs = new LinkedHashSet<ProgramState>();
            for (ProgramState programState : programStates) {
                newPs.addAll(invokedArg.setConstraint(programState, (Constraint)c));
            }
            programStates.clear();
            programStates.addAll(newPs);
        });
        return programStates;
    }

    public boolean generatedByCheck(SECheck check) {
        return false;
    }

    public abstract String toString();

    public int hashCode() {
        return new HashCodeBuilder(7, 1291).append(this.parametersConstraints).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodYield other = (MethodYield)obj;
        return new EqualsBuilder().append(this.parametersConstraints, other.parametersConstraints).isEquals();
    }

    static Stream<Constraint> pmapToStream(@Nullable PMap<Class<? extends Constraint>, Constraint> pmap) {
        if (pmap == null) {
            return Stream.empty();
        }
        Stream.Builder result = Stream.builder();
        pmap.forEach((d, c) -> result.add(c));
        return result.build();
    }

    public Set<List<JavaFileScannerContext.Location>> flow(List<Integer> parameterIndices, List<Class<? extends Constraint>> domains) {
        if (this.node == null || this.behavior == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder parameterSVs = ImmutableSet.builder();
        for (Integer parameterIndex : parameterIndices) {
            if (parameterIndex == -1) {
                parameterSVs.add((Object)this.node.programState.exitValue());
                continue;
            }
            parameterSVs.add((Object)this.behavior.parameters().get(parameterIndex));
        }
        return FlowComputation.flow(this.node, (Set<SymbolicValue>)parameterSVs.build(), c -> true, c -> false, domains, this.node.programState.getLastEvaluated());
    }
}

