/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.matcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.ParametersCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class MethodMatcher {
    private TypeCriteria typeDefinition;
    private TypeCriteria callSite;
    private NameCriteria methodName;
    private ParametersCriteria parameters;
    private List<TypeCriteria> parameterTypes;

    public static MethodMatcher create() {
        return new MethodMatcher();
    }

    public MethodMatcher copy() {
        MethodMatcher copy = new MethodMatcher();
        copy.typeDefinition = this.typeDefinition;
        copy.callSite = this.callSite;
        copy.methodName = this.methodName;
        copy.parameterTypes = this.parameterTypes == null ? null : new ArrayList<TypeCriteria>(this.parameterTypes);
        copy.parameters = this.parameterTypes == null ? null : ParametersCriteria.of(copy.parameterTypes);
        return copy;
    }

    public MethodMatcher name(String methodName) {
        Preconditions.checkState((this.methodName == null ? 1 : 0) != 0);
        this.methodName = NameCriteria.is(methodName);
        return this;
    }

    public MethodMatcher name(NameCriteria methodName) {
        Preconditions.checkState((this.methodName == null ? 1 : 0) != 0);
        this.methodName = methodName;
        return this;
    }

    public MethodMatcher typeDefinition(TypeCriteria typeDefinition) {
        Preconditions.checkState((this.typeDefinition == null ? 1 : 0) != 0);
        this.typeDefinition = typeDefinition;
        return this;
    }

    public MethodMatcher typeDefinition(String fullyQualifiedTypeName) {
        Preconditions.checkState((this.typeDefinition == null ? 1 : 0) != 0);
        this.typeDefinition = TypeCriteria.is(fullyQualifiedTypeName);
        return this;
    }

    public MethodMatcher callSite(TypeCriteria callSite) {
        this.callSite = callSite;
        return this;
    }

    public MethodMatcher addParameter(String fullyQualifiedTypeParameterName) {
        return this.addParameter(TypeCriteria.is(fullyQualifiedTypeParameterName));
    }

    public MethodMatcher addParameter(TypeCriteria parameterTypeCriteria) {
        if (this.parameters == null) {
            this.parameterTypes = Lists.newArrayList();
            this.parameters = ParametersCriteria.of(this.parameterTypes);
        } else {
            Preconditions.checkState((this.parameterTypes != null ? 1 : 0) != 0, (Object)"parameters is already initialized and doesn't support addParameter.");
        }
        this.parameterTypes.add(parameterTypeCriteria);
        return this;
    }

    public MethodMatcher parameters(String ... parameterTypes) {
        if (parameterTypes.length == 0) {
            return this.withoutParameter();
        }
        for (String type : parameterTypes) {
            this.addParameter(type);
        }
        return this;
    }

    public MethodMatcher parameters(TypeCriteria ... parameterTypes) {
        if (parameterTypes.length == 0) {
            return this.withoutParameter();
        }
        for (TypeCriteria type : parameterTypes) {
            this.addParameter(type);
        }
        return this;
    }

    public MethodMatcher withAnyParameters() {
        Preconditions.checkState((this.parameters == null ? 1 : 0) != 0);
        this.parameters = ParametersCriteria.any();
        return this;
    }

    public MethodMatcher withoutParameter() {
        Preconditions.checkState((this.parameters == null ? 1 : 0) != 0);
        this.parameters = ParametersCriteria.none();
        return this;
    }

    public boolean matches(NewClassTree newClassTree) {
        return this.matches(newClassTree.constructorSymbol(), null);
    }

    public boolean matches(MethodInvocationTree mit) {
        IdentifierTree id = MethodMatcher.getIdentifier(mit);
        return this.matches(id.symbol(), MethodMatcher.getCallSiteType(mit));
    }

    public boolean matches(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        Symbol.TypeSymbol enclosingClass = symbol.enclosingClass();
        return enclosingClass != null && this.matches(symbol, enclosingClass.type());
    }

    private boolean matches(Symbol symbol, Type callSiteType) {
        return symbol.isMethodSymbol() && this.isSearchedMethod((Symbol.MethodSymbol)symbol, callSiteType);
    }

    private static Type getCallSiteType(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            Symbol.TypeSymbol enclosingClassSymbol = ((IdentifierTree)methodSelect).symbol().enclosingClass();
            return enclosingClassSymbol != null ? enclosingClassSymbol.type() : null;
        }
        return ((MemberSelectExpressionTree)methodSelect).expression().symbolType();
    }

    private boolean isSearchedMethod(Symbol.MethodSymbol symbol, @Nullable Type callSiteType) {
        boolean result;
        boolean bl = result = this.nameAcceptable(symbol) && this.parametersAcceptable(symbol);
        if (this.typeDefinition != null) {
            result &= this.typeDefinition.test(symbol.owner().type());
        }
        if (this.callSite != null) {
            result &= callSiteType != null && this.callSite.test(callSiteType);
        }
        return result;
    }

    private boolean nameAcceptable(Symbol.MethodSymbol symbol) {
        Preconditions.checkState((this.methodName != null ? 1 : 0) != 0);
        return this.methodName.test(symbol.name());
    }

    private boolean parametersAcceptable(Symbol.MethodSymbol methodSymbol) {
        Preconditions.checkState((this.parameters != null ? 1 : 0) != 0);
        return this.parameters.test(methodSymbol.parameterTypes());
    }

    private static IdentifierTree getIdentifier(MethodInvocationTree mit) {
        if (mit.methodSelect().is(Tree.Kind.IDENTIFIER)) {
            return (IdentifierTree)mit.methodSelect();
        }
        return ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
    }
}

