/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;

public final class ModifiersUtils {
    private ModifiersUtils() {
    }

    public static boolean hasModifier(ModifiersTree modifiers, Modifier expectedModifier) {
        return ModifiersUtils.findModifier(modifiers, expectedModifier).isPresent();
    }

    @CheckForNull
    public static ModifierKeywordTree getModifier(ModifiersTree modifiers, Modifier expectedModifier) {
        return ModifiersUtils.findModifier(modifiers, expectedModifier).orElse(null);
    }

    public static Optional<ModifierKeywordTree> findModifier(ModifiersTree modifiersTree, Modifier expectedModifier) {
        return modifiersTree.modifiers().stream().filter(modifierKeywordTree -> modifierKeywordTree.modifier() == expectedModifier).findAny();
    }
}

