/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.ArrayDimensionTreeImpl;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;

public class NewArrayTreeImpl
extends AbstractTypedTree
implements NewArrayTree {
    @Nullable
    private TypeTree type = null;
    @Nullable
    private SyntaxToken newKeyword;
    private List<ArrayDimensionTree> dimensions;
    @Nullable
    private SyntaxToken openCurlyBraceToken;
    private final ListTree<ExpressionTree> initializers;
    @Nullable
    private SyntaxToken closeCurlyBraceToken;

    public NewArrayTreeImpl(List<ArrayDimensionTree> dimensions, ListTree<ExpressionTree> initializers) {
        super(Tree.Kind.NEW_ARRAY);
        this.dimensions = (List)Preconditions.checkNotNull(dimensions);
        this.initializers = (ListTree)Preconditions.checkNotNull(initializers);
    }

    public NewArrayTreeImpl complete(TypeTree type) {
        Preconditions.checkState((this.type == null ? 1 : 0) != 0);
        this.type = type;
        return this;
    }

    public NewArrayTreeImpl completeWithNewKeyword(SyntaxToken newKeyword) {
        this.newKeyword = newKeyword;
        return this;
    }

    public NewArrayTreeImpl completeWithCurlyBraces(SyntaxToken openCurlyBraceToken, SyntaxToken closeCurlyBraceToken) {
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
        return this;
    }

    public NewArrayTreeImpl completeDimensions(List<ArrayDimensionTree> arrayDimensions) {
        this.dimensions = ImmutableList.builder().addAll(arrayDimensions).addAll(this.dimensions).build();
        return this;
    }

    public NewArrayTreeImpl completeFirstDimension(List<AnnotationTreeImpl> annotations) {
        ((ArrayDimensionTreeImpl)this.dimensions.get(0)).completeAnnotations(annotations);
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.NEW_ARRAY;
    }

    @Override
    public TypeTree type() {
        return this.type;
    }

    @Override
    public List<ArrayDimensionTree> dimensions() {
        return this.dimensions;
    }

    @Override
    @Nullable
    public SyntaxToken openBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public ListTree<ExpressionTree> initializers() {
        return this.initializers;
    }

    @Override
    @Nullable
    public SyntaxToken closeBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNewArray(this);
    }

    @Override
    public Iterable<Tree> children() {
        ImmutableList.Builder iteratorBuilder = ImmutableList.builder();
        NewArrayTreeImpl.addIfNotNull((ImmutableList.Builder<Tree>)iteratorBuilder, this.newKeyword);
        NewArrayTreeImpl.addIfNotNull((ImmutableList.Builder<Tree>)iteratorBuilder, this.type);
        iteratorBuilder.addAll(this.dimensions);
        NewArrayTreeImpl.addIfNotNull((ImmutableList.Builder<Tree>)iteratorBuilder, this.openCurlyBraceToken);
        iteratorBuilder.add(this.initializers);
        NewArrayTreeImpl.addIfNotNull((ImmutableList.Builder<Tree>)iteratorBuilder, this.closeCurlyBraceToken);
        return iteratorBuilder.build();
    }

    @Override
    public SyntaxToken newKeyword() {
        return this.newKeyword;
    }

    private static ImmutableList.Builder<Tree> addIfNotNull(ImmutableList.Builder<Tree> builder, @Nullable Tree tree) {
        if (tree != null) {
            builder.add((Object)tree);
        }
        return builder;
    }
}

