/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.sonar.java.resolve.AnnotationInstanceResolve;
import org.sonar.java.resolve.BytecodeAnnotationVisitor;
import org.sonar.java.resolve.BytecodeVisitor;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.SymbolMetadataResolve;

public class BytecodeMethodVisitor
extends MethodVisitor {
    private final JavaSymbol.MethodJavaSymbol methodSymbol;
    private final BytecodeVisitor bytecodeVisitor;
    private int syntheticArgs;

    BytecodeMethodVisitor(JavaSymbol.MethodJavaSymbol methodSymbol, BytecodeVisitor bytecodeVisitor) {
        super(327680);
        this.methodSymbol = methodSymbol;
        this.bytecodeVisitor = bytecodeVisitor;
        this.syntheticArgs = 0;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        JavaType annotationType = this.bytecodeVisitor.convertAsmType(Type.getType((String)desc), 8192);
        AnnotationInstanceResolve annotationInstance = new AnnotationInstanceResolve(annotationType.getSymbol());
        ((SymbolMetadataResolve)this.methodSymbol.metadata()).addAnnotation(annotationInstance);
        return new BytecodeAnnotationVisitor(annotationInstance, this.bytecodeVisitor);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        JavaType annotationType = this.bytecodeVisitor.convertAsmType(Type.getType((String)desc), 8192);
        if (annotationType.is("java.lang.Synthetic")) {
            ++this.syntheticArgs;
        } else {
            AnnotationInstanceResolve annotationInstance = new AnnotationInstanceResolve(annotationType.getSymbol());
            this.methodSymbol.getParameters().scopeSymbols().get(parameter - this.syntheticArgs).metadata().addAnnotation(annotationInstance);
            return new BytecodeAnnotationVisitor(annotationInstance, this.bytecodeVisitor);
        }
        return null;
    }
}

