/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeSubstitutionSolver;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Type;

public class ParametrizedTypeJavaType
extends ClassJavaType {
    public static TypeSubstitutionSolver typeSubstitutionSolver;
    final TypeSubstitution typeSubstitution;
    final JavaType rawType;

    ParametrizedTypeJavaType(JavaSymbol.TypeJavaSymbol symbol, TypeSubstitution typeSubstitution) {
        super(18, symbol);
        this.rawType = symbol.getType();
        this.typeSubstitution = typeSubstitution;
    }

    @Override
    public JavaType erasure() {
        return this.rawType.erasure();
    }

    @Nullable
    public JavaType substitution(TypeVariableJavaType typeVariableType) {
        JavaType result = null;
        if (this.typeSubstitution != null) {
            result = this.typeSubstitution.substitutedType(typeVariableType);
        }
        return result;
    }

    public List<TypeVariableJavaType> typeParameters() {
        if (this.typeSubstitution != null) {
            return this.typeSubstitution.typeVariables();
        }
        return Lists.newArrayList();
    }

    @Override
    public boolean isSubtypeOf(Type superType) {
        if (((JavaType)superType).isTagged(15)) {
            return false;
        }
        if (this.erasure() == superType.erasure()) {
            return !((JavaType)superType).isParameterized() || this.checkSubstitutedTypesCompatibility((ParametrizedTypeJavaType)superType);
        }
        if (this.verifySuperTypes(superType)) {
            return true;
        }
        return ((JavaType)superType).isTagged(16) && ((WildCardType)superType).isSubtypeOfBound(this);
    }

    private boolean verifySuperTypes(Type superType) {
        ClassJavaType superclass = this.getSuperType();
        return superclass != null && ((JavaType)superclass).isSubtypeOf(superType) || this.symbol.getInterfaces().stream().map(si -> typeSubstitutionSolver.applySubstitution((JavaType)si, this.typeSubstitution)).anyMatch(si -> si.isSubtypeOf(superType));
    }

    private boolean checkSubstitutedTypesCompatibility(ParametrizedTypeJavaType superType) {
        List<JavaType> myTypes = this.typeSubstitution.substitutedTypes();
        List<JavaType> itsTypes = superType.typeSubstitution.substitutedTypes();
        Preconditions.checkState((myTypes.size() == itsTypes.size() ? 1 : 0) != 0);
        if (itsTypes.size() != myTypes.size()) {
            return false;
        }
        for (int i = 0; i < myTypes.size(); ++i) {
            JavaType myType = myTypes.get(i);
            JavaType itsType = itsTypes.get(i);
            if (!(itsType.isTagged(16) ? !myType.isSubtypeOf(itsType) : !myType.equals(itsType))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected ClassJavaType substitutedType(ClassJavaType type) {
        return (ClassJavaType)typeSubstitutionSolver.applySubstitution(type, this.typeSubstitution);
    }
}

