/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.expression.ConditionalExpressionTreeImpl;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.DeferredType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeSubstitutionSolver;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.Types;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.Tree;

public class Resolve {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final JavaSymbolNotFound symbolNotFound = new JavaSymbolNotFound();
    private final BytecodeCompleter bytecodeCompleter;
    private final TypeSubstitutionSolver typeSubstitutionSolver;
    private final Types types = new Types();
    private final Symbols symbols;

    public Resolve(Symbols symbols, BytecodeCompleter bytecodeCompleter, ParametrizedTypeCache parametrizedTypeCache) {
        this.symbols = symbols;
        this.bytecodeCompleter = bytecodeCompleter;
        ParametrizedTypeJavaType.typeSubstitutionSolver = this.typeSubstitutionSolver = new TypeSubstitutionSolver(parametrizedTypeCache, symbols);
    }

    @Nullable
    private static JavaSymbol.TypeJavaSymbol superclassSymbol(JavaSymbol.TypeJavaSymbol c) {
        JavaType supertype = c.getSuperclass();
        return supertype == null ? null : supertype.symbol;
    }

    public JavaSymbol.TypeJavaSymbol registerClass(JavaSymbol.TypeJavaSymbol classSymbol) {
        return this.bytecodeCompleter.registerClass(classSymbol);
    }

    public Scope createStarImportScope(JavaSymbol owner) {
        return new Scope.StarImportScope(owner, this.bytecodeCompleter);
    }

    public Scope createStaticStarImportScope(JavaSymbol owner) {
        return new Scope.StaticStarImportScope(owner, this.bytecodeCompleter);
    }

    public JavaType functionType(ParametrizedTypeJavaType javaType) {
        return this.typeSubstitutionSolver.functionType(javaType);
    }

    public JavaType resolveTypeSubstitution(JavaType type, JavaType definition) {
        return this.typeSubstitutionSolver.applySiteSubstitution(type, definition);
    }

    public List<JavaType> resolveTypeSubstitution(List<JavaType> formals, TypeSubstitution substitution) {
        return this.typeSubstitutionSolver.applySubstitutionToFormalParameters(formals, substitution);
    }

    public JavaType applySubstitution(JavaType type, TypeSubstitution substitution) {
        return this.typeSubstitutionSolver.applySubstitution(type, substitution);
    }

    public JavaType resolveTypeSubstitutionWithDiamondOperator(ParametrizedTypeJavaType type, JavaType definition) {
        ParametrizedTypeJavaType result = type;
        if (definition.isParameterized()) {
            TypeSubstitution substitution = TypeSubstitutionSolver.substitutionFromSuperType(type, (ParametrizedTypeJavaType)definition);
            result = (ParametrizedTypeJavaType)this.typeSubstitutionSolver.applySubstitution(type, substitution);
        }
        return this.typeSubstitutionSolver.erasureSubstitution(result);
    }

    public JavaType parametrizedTypeWithErasure(ParametrizedTypeJavaType type) {
        return this.typeSubstitutionSolver.erasureSubstitution(type);
    }

    private Resolution findField(Env env, JavaSymbol.TypeJavaSymbol site, String name, JavaSymbol.TypeJavaSymbol c) {
        Resolution bestSoFar = this.unresolved();
        Resolution resolution = new Resolution();
        for (JavaSymbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 4) continue;
            if (Resolve.isAccessible(env, site, symbol)) {
                resolution.symbol = symbol;
                resolution.type = this.typeSubstitutionSolver.applySiteSubstitution(symbol.type, c.type);
                return resolution;
            }
            return Resolution.resolution(new AccessErrorJavaSymbol(symbol, Symbols.unknownType));
        }
        if (c.getSuperclass() != null) {
            resolution = this.findField(env, site, name, c.getSuperclass().symbol);
            if (((Resolution)resolution).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                resolution.type = this.typeSubstitutionSolver.applySiteSubstitution(((Resolution)resolution).symbol.type, c.getSuperclass());
                bestSoFar = resolution;
            }
        }
        for (JavaType interfaceType : c.getInterfaces()) {
            resolution = this.findField(env, site, name, interfaceType.symbol);
            if (((Resolution)resolution).symbol.kind >= ((Resolution)bestSoFar).symbol.kind) continue;
            bestSoFar = resolution;
        }
        return bestSoFar;
    }

    private Resolution findVar(Env env, String name) {
        Resolution bestSoFar = this.unresolved();
        Env env1 = env;
        while (env1.outer != null) {
            Resolution sym = new Resolution();
            for (JavaSymbol symbol : env1.scope.lookup(name)) {
                if (symbol.kind != 4) continue;
                sym.symbol = symbol;
            }
            if (sym.symbol == null) {
                sym = this.findField(env1, env1.enclosingClass, name, env1.enclosingClass);
            }
            if (((Resolution)sym).symbol.kind < 64) {
                return sym;
            }
            if (((Resolution)sym).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = sym;
            }
            env1 = env1.outer;
        }
        JavaSymbol symbol = this.findVarInStaticImport(env, name);
        if (symbol.kind < 64) {
            return Resolution.resolution(symbol);
        }
        if (symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
            bestSoFar = Resolution.resolution(symbol);
        }
        return bestSoFar;
    }

    private JavaSymbol findVarInStaticImport(Env env, String name) {
        JavaSymbolNotFound bestSoFar = this.symbolNotFound;
        for (JavaSymbol symbol : env.namedImports.lookup(name)) {
            if ((4 & symbol.kind) == 0) continue;
            return symbol;
        }
        for (JavaSymbol symbol : env.staticStarImports.lookup(name)) {
            if ((4 & symbol.kind) == 0) continue;
            return symbol;
        }
        return bestSoFar;
    }

    private JavaSymbol findMemberType(Env env, JavaSymbol.TypeJavaSymbol site, String name, JavaSymbol.TypeJavaSymbol c) {
        JavaSymbol bestSoFar = this.symbolNotFound;
        for (JavaSymbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 2) continue;
            return Resolve.isAccessible(env, site, symbol) ? symbol : new AccessErrorJavaSymbol(symbol, Symbols.unknownType);
        }
        if (c.getSuperclass() != null) {
            JavaSymbol symbol = this.findMemberType(env, site, name, c.getSuperclass().symbol);
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        if (c.getInterfaces() == null) {
            Preconditions.checkState((boolean)c.completing, (Object)"interfaces of a symbol not currently completing are not set.");
            Preconditions.checkState((c == site ? 1 : 0) != 0);
        } else {
            for (JavaType interfaceType : c.getInterfaces()) {
                JavaSymbol symbol = this.findMemberType(env, site, name, interfaceType.symbol);
                if (symbol.kind >= bestSoFar.kind) continue;
                bestSoFar = symbol;
            }
        }
        return bestSoFar;
    }

    private JavaSymbol findType(Env env, String name) {
        Object bestSoFar = this.symbolNotFound;
        Env env1 = env;
        while (env1 != null) {
            for (JavaSymbol javaSymbol : env1.scope.lookup(name)) {
                if (javaSymbol.kind != 2) continue;
                return javaSymbol;
            }
            if (env1.outer != null) {
                JavaSymbol symbol = this.findMemberType(env1, env1.enclosingClass, name, env1.enclosingClass);
                if (symbol.kind < 64) {
                    return symbol;
                }
                if (symbol.kind < ((JavaSymbol)bestSoFar).kind) {
                    bestSoFar = symbol;
                }
            }
            env1 = env1.outer;
        }
        JavaSymbol predefinedSymbol = this.findMemberType(env, this.symbols.predefClass, name, this.symbols.predefClass);
        if (predefinedSymbol.kind < ((JavaSymbol)bestSoFar).kind) {
            return predefinedSymbol;
        }
        for (JavaSymbol javaSymbol : env.namedImports.lookup(name)) {
            if (javaSymbol.kind != 2) continue;
            return javaSymbol;
        }
        JavaSymbol sym = this.findIdentInPackage(env.packge, name, 2);
        if (sym.kind < ((JavaSymbol)bestSoFar).kind) {
            return sym;
        }
        for (JavaSymbol symbol : env.starImports.lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        JavaSymbol.PackageJavaSymbol packageJavaSymbol = this.bytecodeCompleter.enterPackage("java.lang");
        for (JavaSymbol symbol : packageJavaSymbol.completedMembers().lookup(name)) {
            if (symbol.kind != 2) continue;
            return symbol;
        }
        return bestSoFar;
    }

    public Resolution findIdent(Env env, String name, int kind) {
        Resolution res;
        Resolution bestSoFar = this.unresolved();
        if ((kind & 4) != 0) {
            res = this.findVar(env, name);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        if ((kind & 2) != 0) {
            res = new Resolution();
            res.symbol = this.findType(env, name);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        if ((kind & 1) != 0) {
            res = new Resolution();
            res.symbol = this.findIdentInPackage(this.symbols.defaultPackage, name, 1);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
        }
        return bestSoFar;
    }

    public JavaSymbol findIdentInPackage(JavaSymbol site, String name, int kind) {
        String fullname = this.bytecodeCompleter.formFullName(name, site);
        JavaSymbol bestSoFar = this.symbolNotFound;
        if ((kind & 2) != 0) {
            JavaSymbol sym = this.bytecodeCompleter.loadClass(fullname);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 1) != 0 && bestSoFar.kind >= this.symbolNotFound.kind) {
            bestSoFar = this.bytecodeCompleter.enterPackage(fullname);
        }
        return bestSoFar;
    }

    public Resolution findIdentInType(Env env, JavaSymbol.TypeJavaSymbol site, String name, int kind) {
        Resolution bestSoFar = this.unresolved();
        if ((kind & 4) != 0) {
            Resolution resolution = this.findField(env, site, name, site);
            if (((Resolution)resolution).symbol.kind < 64) {
                return resolution;
            }
            if (((Resolution)resolution).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = resolution;
            }
        }
        if ((kind & 2) != 0) {
            JavaSymbol symbol = this.findMemberType(env, site, name, site);
            if (symbol.kind < 64) {
                return Resolution.resolution(symbol);
            }
            if (symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = Resolution.resolution(symbol);
            }
        }
        return bestSoFar;
    }

    public Resolution findMethod(Env env, String name, List<JavaType> argTypes, List<JavaType> typeParamTypes) {
        Resolution res;
        Resolution bestSoFar = this.unresolved();
        Env env1 = env;
        while (env1.outer != null) {
            res = this.findMethod(env1, env1.enclosingClass.getType(), name, argTypes, typeParamTypes);
            if (((Resolution)res).symbol.kind < 64) {
                return res;
            }
            if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
                bestSoFar = res;
            }
            env1 = env1.outer;
        }
        res = this.findMethodInStaticImport(env, name, argTypes, typeParamTypes);
        if (((Resolution)res).symbol.kind < 64) {
            return res;
        }
        if (((Resolution)res).symbol.kind < ((Resolution)bestSoFar).symbol.kind) {
            bestSoFar = res;
        }
        return bestSoFar;
    }

    private Resolution findMethodInStaticImport(Env env, String name, List<JavaType> argTypes, List<JavaType> typeParamTypes) {
        Resolution bestSoFar = this.unresolved();
        JavaType enclosingType = env.enclosingClass.getType();
        bestSoFar = this.lookupInScope(env, enclosingType, enclosingType, name, argTypes, typeParamTypes, false, env.namedImports, bestSoFar);
        if (((Resolution)bestSoFar).symbol.kind < 64) {
            return bestSoFar;
        }
        bestSoFar = this.lookupInScope(env, enclosingType, enclosingType, name, argTypes, typeParamTypes, false, env.staticStarImports, bestSoFar);
        if (((Resolution)bestSoFar).symbol.kind < 64) {
            return bestSoFar;
        }
        bestSoFar = this.lookupInScope(env, enclosingType, enclosingType, name, argTypes, typeParamTypes, true, env.namedImports, bestSoFar);
        if (((Resolution)bestSoFar).symbol.kind < 64) {
            return bestSoFar;
        }
        bestSoFar = this.lookupInScope(env, enclosingType, enclosingType, name, argTypes, typeParamTypes, true, env.staticStarImports, bestSoFar);
        return bestSoFar;
    }

    public Resolution findMethod(Env env, JavaType site, String name, List<JavaType> argTypes) {
        return this.findMethod(env, site, site, name, argTypes, (List<JavaType>)ImmutableList.of());
    }

    public Resolution findMethod(Env env, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams) {
        return this.findMethod(env, site, site, name, argTypes, typeParams);
    }

    private Resolution findMethod(Env env, JavaType callSite, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams) {
        if ("this".equals(name)) {
            return this.findConstructor(env, site, argTypes, typeParams);
        }
        if ("super".equals(name)) {
            JavaType superclass = site.getSuperType();
            if (superclass == null) {
                return this.unresolved();
            }
            return this.findConstructor(env, superclass, argTypes, typeParams);
        }
        return this.findMethodByStrictThenLooseInvocation(env, callSite, site, name, argTypes, typeParams);
    }

    private Resolution findConstructor(Env env, JavaType site, List<JavaType> argTypes, List<JavaType> typeParams) {
        ImmutableList newArgTypes = argTypes;
        Symbol owner = site.symbol.owner();
        if (!((JavaSymbol)owner).isPackageSymbol() && !site.symbol.isStatic()) {
            newArgTypes = ImmutableList.builder().add((Object)((JavaSymbol)owner).enclosingClass().type).addAll(argTypes).build();
        }
        return this.findMethodByStrictThenLooseInvocation(env, site, site, CONSTRUCTOR_NAME, (List<JavaType>)newArgTypes, typeParams);
    }

    private Resolution findMethodByStrictThenLooseInvocation(Env env, JavaType callSite, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams) {
        Resolution bestSoFar = this.findMethod(env, callSite, site, name, argTypes, typeParams, false);
        if (!argTypes.isEmpty() && (((Resolution)bestSoFar).symbol.kind >= 64 || Resolve.canFindStrictInvocationWithLooseInvocation(argTypes, bestSoFar))) {
            bestSoFar = this.findMethod(env, callSite, site, name, argTypes, typeParams, true);
        }
        return bestSoFar;
    }

    private static boolean canFindStrictInvocationWithLooseInvocation(List<JavaType> argTypes, Resolution bestSoFar) {
        return ((JavaSymbol.MethodJavaSymbol)bestSoFar.symbol).isVarArgs() && argTypes.stream().anyMatch(t -> t.isPrimitive() || t.isPrimitiveWrapper());
    }

    private Resolution findMethod(Env env, JavaType callSite, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams, boolean looseInvocation) {
        JavaType superclass = site.getSuperType();
        Resolution bestSoFar = this.unresolved();
        bestSoFar = this.lookupInScope(env, callSite, site, name, argTypes, typeParams, looseInvocation, site.getSymbol().members(), bestSoFar);
        if (superclass != null) {
            if (name.equals(CONSTRUCTOR_NAME) && superclass.is("java.lang.Enum")) {
                return bestSoFar;
            }
            Resolution method = this.findMethod(env, callSite, superclass, name, argTypes, typeParams, looseInvocation);
            method.type = this.typeSubstitutionSolver.applySiteSubstitution(method.type, site, superclass);
            Resolution best = this.selectBest(env, superclass, callSite, argTypes, typeParams, method.symbol, bestSoFar, looseInvocation);
            if (best.symbol == method.symbol) {
                bestSoFar = method;
            }
        }
        for (JavaType interfaceType : site.getSymbol().getInterfaces()) {
            Resolution method = this.findMethod(env, callSite, interfaceType, name, argTypes, typeParams, looseInvocation);
            method.type = this.typeSubstitutionSolver.applySiteSubstitution(method.type, site, interfaceType);
            Resolution best = this.selectBest(env, interfaceType, callSite, argTypes, typeParams, method.symbol, bestSoFar, looseInvocation);
            if (best.symbol != method.symbol) continue;
            bestSoFar = method;
        }
        return bestSoFar;
    }

    private Resolution lookupInScope(Env env, JavaType callSite, JavaType site, String name, List<JavaType> argTypes, List<JavaType> typeParams, boolean autoboxing, Scope scope, Resolution bestFound) {
        Resolution bestSoFar = bestFound;
        for (JavaSymbol symbol : scope.lookup(name)) {
            Resolution best;
            if (symbol.kind != 16 || (best = this.selectBest(env, site, callSite, argTypes, typeParams, symbol, bestSoFar, autoboxing)).symbol != symbol) continue;
            bestSoFar = best;
        }
        return bestSoFar;
    }

    private Resolution selectBest(Env env, JavaType defSite, JavaType callSite, List<JavaType> argTypes, List<JavaType> typeParams, JavaSymbol candidate, Resolution bestSoFar, boolean looseInvocation) {
        JavaSymbol.TypeJavaSymbol siteSymbol = callSite.symbol;
        if (candidate.kind >= 64 || !Resolve.isInheritedIn(candidate, siteSymbol) || candidate.type == null) {
            return bestSoFar;
        }
        JavaSymbol.MethodJavaSymbol methodJavaSymbol = (JavaSymbol.MethodJavaSymbol)candidate;
        if (!Resolve.hasCompatibleArity(methodJavaSymbol.parameterTypes().size(), argTypes.size(), methodJavaSymbol.isVarArgs())) {
            return bestSoFar;
        }
        TypeSubstitution substitution = this.typeSubstitutionSolver.getTypeSubstitution(methodJavaSymbol, callSite, typeParams, argTypes);
        if (substitution == null) {
            return bestSoFar;
        }
        List<JavaType> formals = ((MethodJavaType)methodJavaSymbol.type).argTypes;
        formals = this.typeSubstitutionSolver.applySiteSubstitutionToFormalParameters(formals, callSite);
        if (defSite != callSite) {
            formals = this.typeSubstitutionSolver.applySiteSubstitutionToFormalParameters(formals, defSite);
        }
        if (!this.isArgumentsAcceptable(argTypes, formals = this.typeSubstitutionSolver.applySubstitutionToFormalParameters(formals, substitution), methodJavaSymbol.isVarArgs(), looseInvocation)) {
            return bestSoFar;
        }
        if (!Resolve.isAccessible(env, siteSymbol, candidate)) {
            Resolution resolution = new Resolution(new AccessErrorJavaSymbol(candidate, Symbols.unknownType));
            resolution.type = Symbols.unknownType;
            return resolution;
        }
        JavaSymbol mostSpecific = this.selectMostSpecific(candidate, bestSoFar.symbol, argTypes, substitution, callSite);
        if (mostSpecific.isKind(65)) {
            return bestSoFar;
        }
        Resolution resolution = new Resolution(mostSpecific);
        JavaSymbol.MethodJavaSymbol mostSpecificMethod = (JavaSymbol.MethodJavaSymbol)mostSpecific;
        List<JavaType> thrownTypes = ((MethodJavaType)mostSpecific.type).thrown;
        JavaType returnType = ((MethodJavaType)mostSpecificMethod.type).resultType;
        if (Resolve.applicableWithUncheckedConversion(mostSpecificMethod, defSite, typeParams) && !mostSpecificMethod.isConstructor()) {
            returnType = returnType.erasure();
            thrownTypes = Resolve.erasure(thrownTypes);
        } else {
            returnType = this.typeSubstitutionSolver.getReturnType(returnType, defSite, callSite, substitution, mostSpecificMethod);
            thrownTypes = thrownTypes.stream().map(t -> this.typeSubstitutionSolver.applySiteSubstitution((JavaType)t, callSite)).map(t -> this.typeSubstitutionSolver.applySubstitution((JavaType)t, substitution)).collect(Collectors.toList());
        }
        resolution.type = new MethodJavaType(formals, returnType, thrownTypes, defSite.symbol);
        return resolution;
    }

    private static List<JavaType> erasure(List<JavaType> types) {
        ArrayList<JavaType> erasedTypes = new ArrayList<JavaType>(types.size());
        for (JavaType type : types) {
            erasedTypes.add(type.erasure());
        }
        return erasedTypes;
    }

    private static boolean applicableWithUncheckedConversion(JavaSymbol.MethodJavaSymbol candidate, JavaType callSite, List<JavaType> typeParams) {
        return !candidate.isStatic() && Resolve.isRawTypeOfParametrizedType(callSite) && typeParams.isEmpty();
    }

    private static boolean isRawTypeOfParametrizedType(JavaType site) {
        return !site.isParameterized() && !site.symbol.typeVariableTypes.isEmpty();
    }

    private static boolean hasCompatibleArity(int formalArgSize, int argSize, boolean isVarArgs) {
        if (isVarArgs) {
            return argSize - formalArgSize >= -1;
        }
        return formalArgSize == argSize;
    }

    private boolean isArgumentsAcceptable(List<JavaType> argTypes, List<JavaType> formals, boolean isVarArgs, boolean autoboxing) {
        int i;
        int argsSize = argTypes.size();
        int formalsSize = formals.size();
        int nbArgToCheck = argsSize - formalsSize;
        if (isVarArgs) {
            ++nbArgToCheck;
        }
        for (i = 1; i <= nbArgToCheck; ++i) {
            ArrayJavaType lastFormal = (ArrayJavaType)formals.get(formalsSize - 1);
            JavaType argType = argTypes.get(argsSize - i);
            if (this.isAcceptableType(argType, lastFormal.elementType, autoboxing) || nbArgToCheck == 1 && this.isAcceptableType(argType, lastFormal, autoboxing)) continue;
            return false;
        }
        for (i = 0; i < argsSize - nbArgToCheck; ++i) {
            JavaType formal;
            JavaType arg = argTypes.get(i);
            if (this.isAcceptableType(arg, formal = formals.get(i), autoboxing)) continue;
            return false;
        }
        return true;
    }

    private boolean isAcceptableType(JavaType arg, JavaType formal, boolean autoboxing) {
        if (arg.isTagged(17)) {
            return this.isAcceptableDeferredType((DeferredType)arg, formal);
        }
        if (formal.isTagged(15) && !arg.isTagged(15)) {
            return Resolve.subtypeOfTypeVar(arg, (TypeVariableJavaType)formal);
        }
        if (formal.isArray() && arg.isArray()) {
            return this.isAcceptableType(((ArrayJavaType)arg).elementType(), ((ArrayJavaType)formal).elementType(), autoboxing);
        }
        if (arg.isParameterized() || formal.isParameterized() || Resolve.isWilcardType(arg) || Resolve.isWilcardType(formal)) {
            return this.callWithRawType(arg, formal) || this.types.isSubtype(arg, formal) || this.isAcceptableByAutoboxing(arg, formal.erasure());
        }
        return this.types.isSubtype(arg.erasure(), formal.erasure()) || autoboxing && this.isAcceptableByAutoboxing(arg, formal.erasure());
    }

    private boolean isAcceptableDeferredType(DeferredType arg, JavaType formal) {
        AbstractTypedTree tree = arg.tree();
        if (tree.is(Tree.Kind.METHOD_REFERENCE, Tree.Kind.LAMBDA_EXPRESSION) && !formal.symbol.isFlag(512)) {
            return false;
        }
        return !tree.is(Tree.Kind.LAMBDA_EXPRESSION) || ((LambdaExpressionTree)((Object)tree)).parameters().size() == this.findSamMethodArgs(formal).size();
    }

    Resolution findMethodReference(Env env, List<JavaType> samMethodArgs, MethodReferenceTree methodRefTree) {
        String methodName;
        Resolution resolution;
        JavaType expressionType;
        Tree expression = methodRefTree.expression();
        if (Resolve.secondSearchRequired(expression, expressionType = (JavaType)((AbstractTypedTree)expression).symbolType(), (resolution = this.findMethod(env, expressionType, methodName = Resolve.getMethodReferenceMethodName(methodRefTree.method().name()), samMethodArgs)).symbol, samMethodArgs)) {
            resolution = this.findMethod(env, expressionType, methodName, samMethodArgs.stream().skip(1L).collect(Collectors.toList()));
        }
        return resolution;
    }

    private static String getMethodReferenceMethodName(String methodName) {
        return JavaKeyword.NEW.getValue().equals(methodName) ? CONSTRUCTOR_NAME : methodName;
    }

    private static boolean secondSearchRequired(Tree expression, JavaType expressionType, JavaSymbol symbol, List<JavaType> samMethodArgs) {
        return Resolve.isMethodRefOnType(expression) && Resolve.firstParamSubtypeOfRefType(expressionType, samMethodArgs) && (symbol.isUnknown() || !symbol.isStatic());
    }

    private static boolean isMethodRefOnType(Tree expression) {
        if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            return ((MemberSelectExpressionTree)expression).identifier().symbol().isTypeSymbol();
        }
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            return ((IdentifierTree)expression).symbol().isTypeSymbol();
        }
        return false;
    }

    private static boolean firstParamSubtypeOfRefType(JavaType expressionType, List<JavaType> samMethodArgs) {
        return samMethodArgs.isEmpty() || samMethodArgs.get(0).isSubtypeOf(expressionType.erasure());
    }

    private boolean callWithRawType(JavaType arg, JavaType formal) {
        return formal.isParameterized() && !arg.isParameterized() && this.types.isSubtype(arg, formal.erasure());
    }

    private static boolean subtypeOfTypeVar(JavaType arg, TypeVariableJavaType formal) {
        for (JavaType bound : formal.bounds()) {
            if ((!bound.isTagged(15) || Resolve.subtypeOfTypeVar(arg, (TypeVariableJavaType)bound)) && arg.isSubtypeOf(bound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWilcardType(JavaType type) {
        return type.isTagged(16);
    }

    private boolean isAcceptableByAutoboxing(JavaType expressionType, JavaType formalType) {
        if (expressionType.isPrimitive()) {
            return this.types.isSubtype((JavaType)this.symbols.boxedTypes.get((Object)expressionType), formalType);
        }
        JavaType unboxedType = (JavaType)this.symbols.boxedTypes.inverse().get((Object)expressionType);
        if (unboxedType != null) {
            return this.types.isSubtype(unboxedType, formalType);
        }
        return false;
    }

    private JavaSymbol selectMostSpecific(JavaSymbol m1, JavaSymbol m2, List<JavaType> argTypes, TypeSubstitution m1Substitution, JavaType callSite) {
        if (m2.type == null || !m2.isKind(16)) {
            return m1;
        }
        TypeSubstitution m2Substitution = null;
        if (((JavaSymbol.MethodJavaSymbol)m2).isParametrized()) {
            m2Substitution = this.typeSubstitutionSolver.getTypeSubstitution((JavaSymbol.MethodJavaSymbol)m2, callSite, (List<JavaType>)ImmutableList.of(), argTypes);
        }
        if (m2Substitution == null) {
            m2Substitution = new TypeSubstitution();
        }
        boolean m1SignatureMoreSpecific = this.isSignatureMoreSpecific(m1, m2, argTypes, m1Substitution, m2Substitution);
        boolean m2SignatureMoreSpecific = this.isSignatureMoreSpecific(m2, m1, argTypes, m1Substitution, m2Substitution);
        if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
            return new AmbiguityErrorJavaSymbol();
        }
        if (m1SignatureMoreSpecific) {
            return m1;
        }
        if (m2SignatureMoreSpecific) {
            return m2;
        }
        return new AmbiguityErrorJavaSymbol();
    }

    private boolean isSignatureMoreSpecific(JavaSymbol m1, JavaSymbol m2, List<JavaType> argTypes, TypeSubstitution m1Substitution, TypeSubstitution m2Substitution) {
        boolean m2VarArity;
        List<JavaType> m1ArgTypes = ((MethodJavaType)m1.type).argTypes;
        List<JavaType> m2ArgTypes = ((MethodJavaType)m2.type).argTypes;
        JavaSymbol.MethodJavaSymbol methodJavaSymbol = (JavaSymbol.MethodJavaSymbol)m1;
        boolean m1VarArity = methodJavaSymbol.isVarArgs();
        if (m1VarArity != (m2VarArity = ((JavaSymbol.MethodJavaSymbol)m2).isVarArgs())) {
            boolean lastArgIsArray = !argTypes.isEmpty() && argTypes.get(argTypes.size() - 1).isArray() && (argTypes.size() == m2ArgTypes.size() || argTypes.size() == m1ArgTypes.size());
            return lastArgIsArray ^ m2VarArity;
        }
        if (m1VarArity) {
            m1ArgTypes = Resolve.expandVarArgsToFitSize(m1ArgTypes, m2ArgTypes.size());
        }
        if (!Resolve.hasCompatibleArity(m1ArgTypes.size(), m2ArgTypes.size(), m2VarArity)) {
            return false;
        }
        m1ArgTypes = this.typeSubstitutionSolver.applySubstitutionToFormalParameters(m1ArgTypes, m1Substitution);
        m2ArgTypes = this.typeSubstitutionSolver.applySubstitutionToFormalParameters(m2ArgTypes, m2Substitution);
        return this.isArgumentsAcceptable(m1ArgTypes, m2ArgTypes, m2VarArity, false);
    }

    private static List<JavaType> expandVarArgsToFitSize(List<JavaType> m1ArgTypes, int size) {
        ArrayList<JavaType> newArgTypes = new ArrayList<JavaType>(m1ArgTypes);
        int m1ArgTypesSize = newArgTypes.size();
        int m1ArgTypesLast = m1ArgTypesSize - 1;
        Type lastElementType = ((Type.ArrayType)newArgTypes.get(m1ArgTypesLast)).elementType();
        newArgTypes.set(m1ArgTypesLast, (JavaType)lastElementType);
        for (int i = m1ArgTypesSize; i < size - 1; ++i) {
            if (i < newArgTypes.size()) {
                newArgTypes.set(i, (JavaType)lastElementType);
                continue;
            }
            newArgTypes.add((JavaType)lastElementType);
        }
        return newArgTypes;
    }

    @VisibleForTesting
    static boolean isAccessible(Env env, JavaSymbol.TypeJavaSymbol c) {
        boolean result;
        switch (c.flags() & 7) {
            case 2: {
                result = Resolve.sameOutermostClass(env.enclosingClass, (JavaSymbol)c.owner());
                break;
            }
            case 0: {
                result = env.packge == c.packge();
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 4: {
                result = env.packge == c.packge() || Resolve.isInnerSubClass(env.enclosingClass, (JavaSymbol)c.owner());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    private static boolean isInnerSubClass(JavaSymbol.TypeJavaSymbol c, JavaSymbol base) {
        while (c != null && Resolve.isSubClass(c, base)) {
            c = ((JavaSymbol)c.owner()).enclosingClass();
        }
        return c != null;
    }

    @VisibleForTesting
    static boolean isSubClass(@Nullable JavaSymbol.TypeJavaSymbol c, JavaSymbol base) {
        if (c == null) {
            return false;
        }
        if (c == base) {
            return true;
        }
        if ((base.flags() & 0x200) != 0) {
            for (JavaType interfaceType : c.getInterfaces()) {
                if (!Resolve.isSubClass(interfaceType.symbol, base)) continue;
                return true;
            }
            return Resolve.isSubClass(Resolve.superclassSymbol(c), base);
        }
        return Resolve.isSubClass(Resolve.superclassSymbol(c), base);
    }

    private static boolean isAccessible(Env env, JavaSymbol.TypeJavaSymbol site, JavaSymbol symbol) {
        switch (symbol.flags() & 7) {
            case 2: {
                return env.enclosingClass != null && Resolve.sameOutermostClass(env.enclosingClass, symbol.owner()) && Resolve.isInheritedIn(symbol, site);
            }
            case 0: {
                return env.packge == symbol.packge() && Resolve.isAccessible(env, site) && Resolve.isInheritedIn(symbol, site) && Resolve.notOverriddenIn(site, symbol);
            }
            case 1: {
                return Resolve.isAccessible(env, site) && Resolve.notOverriddenIn(site, symbol);
            }
            case 4: {
                return (env.packge == symbol.packge() || Resolve.isProtectedAccessible(symbol, env.enclosingClass, site)) && Resolve.isAccessible(env, site) && Resolve.notOverriddenIn(site, symbol);
            }
        }
        throw new IllegalStateException();
    }

    static boolean sameOutermostClass(JavaSymbol s1, JavaSymbol s2) {
        return s1.outermostClass() == s2.outermostClass();
    }

    private static boolean notOverriddenIn(JavaSymbol.TypeJavaSymbol site, JavaSymbol symbol) {
        return true;
    }

    @VisibleForTesting
    static boolean isInheritedIn(JavaSymbol symbol, JavaSymbol.TypeJavaSymbol clazz) {
        switch (symbol.flags() & 7) {
            case 1: {
                return true;
            }
            case 2: {
                return symbol.owner() == clazz;
            }
            case 4: {
                return true;
            }
            case 0: {
                JavaSymbol.PackageJavaSymbol thisPackage = symbol.packge();
                JavaSymbol.TypeJavaSymbol sup = clazz;
                while (sup != null && sup != symbol.owner()) {
                    if (sup.packge() != thisPackage) {
                        return false;
                    }
                    sup = Resolve.superclassSymbol(sup);
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean isProtectedAccessible(JavaSymbol symbol, JavaSymbol.TypeJavaSymbol c, JavaSymbol.TypeJavaSymbol site) {
        return true;
    }

    Type leastUpperBound(Set<Type> refTypes) {
        return this.typeSubstitutionSolver.leastUpperBound(refTypes);
    }

    Resolution unresolved() {
        Resolution resolution = new Resolution(this.symbolNotFound);
        resolution.type = Symbols.unknownType;
        return resolution;
    }

    public JavaType conditionalExpressionType(ConditionalExpressionTree tree, JavaType trueType, JavaType falseType) {
        if (trueType.isTagged(17)) {
            return falseType.isTagged(17) ? this.symbols.deferedType((ConditionalExpressionTreeImpl)tree) : falseType;
        }
        if (falseType.isTagged(17)) {
            return trueType;
        }
        if (trueType == falseType) {
            return trueType;
        }
        if (trueType.isTagged(13)) {
            return falseType.isPrimitive() ? falseType.primitiveWrapperType() : falseType;
        }
        if (falseType.isTagged(13)) {
            return trueType.isPrimitive() ? trueType.primitiveWrapperType() : trueType;
        }
        JavaType secondOperand = Resolve.getPrimitive(trueType);
        JavaType thirdOperand = Resolve.getPrimitive(falseType);
        if (secondOperand != null && thirdOperand != null && Resolve.isNumericalConditionalExpression(secondOperand, thirdOperand)) {
            if ((secondOperand.tag < thirdOperand.tag || secondOperand.isTagged(4)) && !thirdOperand.isTagged(4)) {
                return thirdOperand;
            }
            return secondOperand;
        }
        return (JavaType)this.leastUpperBound(Sets.newHashSet((Object[])new Type[]{trueType, falseType}));
    }

    private static boolean isNumericalConditionalExpression(JavaType secondOperand, JavaType thirdOperand) {
        return secondOperand.isNumerical() && thirdOperand.isNumerical();
    }

    @CheckForNull
    private static JavaType getPrimitive(JavaType primitiveOrWrapper) {
        if (primitiveOrWrapper.isPrimitiveWrapper()) {
            return primitiveOrWrapper.primitiveType();
        }
        return primitiveOrWrapper.isPrimitive() ? primitiveOrWrapper : null;
    }

    public List<JavaType> findSamMethodArgs(Type type) {
        return this.findSamMethodArgsRecursively(type).orElse(new ArrayList());
    }

    private Optional<List<JavaType>> findSamMethodArgsRecursively(@Nullable Type type) {
        if (type == null) {
            return Optional.empty();
        }
        return this.getSamMethod((JavaType)type).map(m -> ((MethodJavaType)m.type).argTypes).map(samTypes -> this.applySamSubstitution(type, (List<JavaType>)samTypes));
    }

    private List<JavaType> applySamSubstitution(Type type, List<JavaType> samTypes) {
        JavaType functionType = (JavaType)type;
        if (functionType instanceof ParametrizedTypeJavaType) {
            functionType = this.typeSubstitutionSolver.functionType((ParametrizedTypeJavaType)functionType);
        }
        List<JavaType> argTypes = this.typeSubstitutionSolver.applySiteSubstitutionToFormalParameters(samTypes, functionType);
        return argTypes.stream().map(argType -> {
            if (argType.isTagged(16)) {
                return ((WildCardType)argType).bound;
            }
            return argType;
        }).collect(Collectors.toList());
    }

    public Optional<JavaSymbol.MethodJavaSymbol> getSamMethod(JavaType lambdaType) {
        for (Symbol member : lambdaType.symbol().memberSymbols()) {
            JavaSymbol.MethodJavaSymbol methodJavaSymbol;
            boolean isObjectMethod;
            if (!Resolve.isAbstractMethod(member) || (isObjectMethod = this.isObjectMethod(methodJavaSymbol = (JavaSymbol.MethodJavaSymbol)member))) continue;
            return Optional.of(methodJavaSymbol);
        }
        for (ClassJavaType type : lambdaType.symbol.superTypes()) {
            Optional<JavaSymbol.MethodJavaSymbol> samMethod = this.getSamMethod(type);
            if (!samMethod.isPresent()) continue;
            return samMethod;
        }
        return Optional.empty();
    }

    private boolean isObjectMethod(JavaSymbol.MethodJavaSymbol methodJavaSymbol) {
        boolean isObjectMethod = false;
        for (JavaSymbol.MethodJavaSymbol overriddenSymbol = methodJavaSymbol.overriddenSymbol(); overriddenSymbol != null && !isObjectMethod; overriddenSymbol = overriddenSymbol.overriddenSymbol()) {
            isObjectMethod = overriddenSymbol.owner.type == this.symbols.objectType;
        }
        return isObjectMethod;
    }

    private static boolean isAbstractMethod(Symbol member) {
        return member.isMethodSymbol() && member.isAbstract();
    }

    public static class AccessErrorJavaSymbol
    extends JavaSymbol {
        JavaSymbol symbol;

        public AccessErrorJavaSymbol(JavaSymbol symbol, JavaType type) {
            super(64, 0, null, null);
            this.symbol = symbol;
            this.type = type;
        }
    }

    public static class AmbiguityErrorJavaSymbol
    extends JavaSymbol {
        public AmbiguityErrorJavaSymbol() {
            super(65, 0, null, null);
        }
    }

    public static class JavaSymbolNotFound
    extends JavaSymbol {
        public JavaSymbolNotFound() {
            super(66, 0, null, Symbols.unknownSymbol);
        }

        @Override
        public boolean isUnknown() {
            return true;
        }
    }

    static class Env {
        Env next;
        @Nullable
        Env outer;
        JavaSymbol.PackageJavaSymbol packge;
        @Nullable
        JavaSymbol.TypeJavaSymbol enclosingClass;
        Scope scope;
        Scope namedImports;
        Scope starImports;
        Scope staticStarImports;

        Env() {
        }

        public Env dup() {
            Env env = new Env();
            env.next = this;
            env.outer = this.outer;
            env.packge = this.packge;
            env.enclosingClass = this.enclosingClass;
            env.scope = this.scope;
            env.namedImports = this.namedImports;
            env.starImports = this.starImports;
            env.staticStarImports = this.staticStarImports;
            return env;
        }
    }

    static class Resolution {
        private JavaSymbol symbol;
        private JavaType type;

        private Resolution(JavaSymbol symbol) {
            this.symbol = symbol;
        }

        Resolution() {
        }

        static Resolution resolution(JavaSymbol symbol) {
            return new Resolution(symbol);
        }

        JavaSymbol symbol() {
            return this.symbol;
        }

        public JavaType type() {
            if (this.type == null) {
                if (this.symbol.isKind(16)) {
                    return ((MethodJavaType)this.symbol.type).resultType;
                }
                if (this.symbol.isUnknown() || this.symbol.isKind(1)) {
                    return Symbols.unknownType;
                }
                return this.symbol.type;
            }
            return this.type;
        }
    }
}

