/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.base.Preconditions;
import org.sonar.java.cfg.CFG;
import org.sonar.plugins.java.api.tree.Tree;

public class ProgramPoint {
    private int hashcode;
    final CFG.Block block;
    final int i;

    ProgramPoint(CFG.Block block) {
        this(block, 0);
    }

    private ProgramPoint(CFG.Block block, int i) {
        int blockSize = block.elements().size();
        Preconditions.checkState((i < blockSize + 2 ? 1 : 0) != 0, (String)"CFG Block has %s elements but PP at %s was requested", (Object[])new Object[]{blockSize, i});
        this.block = block;
        this.i = i;
    }

    ProgramPoint next() {
        int nextPP = this.i + 1;
        return new ProgramPoint(this.block, nextPP);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.block.id() * 31 + this.i;
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProgramPoint) {
            ProgramPoint other = (ProgramPoint)obj;
            return this.block.id() == other.block.id() && this.i == other.i;
        }
        return false;
    }

    public String toString() {
        String tree = "";
        if (this.i < this.block.elements().size()) {
            tree = "" + (Object)((Object)this.block.elements().get(this.i).kind()) + this.block.elements().get(this.i).firstToken().line();
        }
        return "B" + this.block.id() + "." + this.i + "  " + tree;
    }

    public Tree syntaxTree() {
        if (this.block.elements().isEmpty()) {
            return this.block.terminator();
        }
        return this.block.elements().get(Math.min(this.i, this.block.elements().size() - 1));
    }
}

