/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SymbolicExecutionVisitor
extends SubscriptionVisitor {
    private static final Logger LOG = Loggers.get(SymbolicExecutionVisitor.class);
    @VisibleForTesting
    public final BehaviorCache behaviorCache = new BehaviorCache(this);
    private final ExplodedGraphWalker.ExplodedGraphWalkerFactory egwFactory;

    public SymbolicExecutionVisitor(List<JavaFileScanner> executableScanners) {
        this.egwFactory = new ExplodedGraphWalker.ExplodedGraphWalkerFactory(executableScanners);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Lists.newArrayList((Object[])new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR});
    }

    @Override
    public void visitNode(Tree tree) {
        this.execute((MethodTree)tree);
    }

    @CheckForNull
    public MethodBehavior execute(MethodTree methodTree) {
        ExplodedGraphWalker walker = this.egwFactory.createWalker(this.behaviorCache, (SemanticModel)this.context.getSemanticModel());
        try {
            Symbol.MethodSymbol methodSymbol = methodTree.symbol();
            if (SymbolicExecutionVisitor.methodCanNotBeOverriden(methodSymbol)) {
                MethodBehavior methodBehavior = this.behaviorCache.methodBehaviorForSymbol(methodSymbol);
                if (!methodBehavior.isVisited()) {
                    methodBehavior = walker.visitMethod(methodTree, methodBehavior);
                    methodBehavior.completed();
                }
                return methodBehavior;
            }
            return walker.visitMethod(methodTree);
        }
        catch (ExplodedGraphWalker.ExplodedGraphTooBigException | ExplodedGraphWalker.MaximumStepsReachedException | RelationalSymbolicValue.TransitiveRelationExceededException exception) {
            LOG.debug("Could not complete symbolic execution: ", (Object)exception);
            if (walker.methodBehavior != null) {
                walker.methodBehavior.visited();
            }
            return null;
        }
    }

    public static boolean methodCanNotBeOverriden(Symbol.MethodSymbol methodSymbol) {
        if ((((JavaSymbol.MethodJavaSymbol)methodSymbol).flags() & 0x100) != 0) {
            return false;
        }
        return !methodSymbol.isAbstract() && (methodSymbol.isPrivate() || methodSymbol.isFinal() || methodSymbol.isStatic() || methodSymbol.owner().isFinal());
    }
}

