/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.ExceptionalCheckBasedYield;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ExceptionalYieldChecker {
    private final String message;

    ExceptionalYieldChecker(String message) {
        this.message = message;
    }

    void reportOnExceptionalYield(ExplodedGraph.Node node, SECheck check) {
        node.edges().stream().forEach(edge -> edge.yields().stream().filter(yield -> yield.generatedByCheck(check)).forEach(yield -> this.reportIssue(edge.parent(), (ExceptionalCheckBasedYield)yield, check)));
    }

    private void reportIssue(ExplodedGraph.Node node, ExceptionalCheckBasedYield yield, SECheck check) {
        MethodInvocationTree mit = (MethodInvocationTree)node.programPoint.syntaxTree();
        ExpressionTree methodSelect = mit.methodSelect();
        String methodName = mit.symbol().name();
        ExpressionTree reportTree = methodSelect;
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            reportTree = ((MemberSelectExpressionTree)methodSelect).identifier();
        }
        JavaFileScannerContext.Location methodInvocationMessage = new JavaFileScannerContext.Location(String.format("'%s()' is invoked.", methodName), reportTree);
        Set<List<JavaFileScannerContext.Location>> argumentsFlows = ExceptionalYieldChecker.flowsForMethodArguments(node, mit);
        Set<List<JavaFileScannerContext.Location>> exceptionFlows = yield.exceptionFlows();
        ImmutableSet.Builder flows = ImmutableSet.builder();
        for (List<JavaFileScannerContext.Location> argumentFlow : argumentsFlows) {
            for (List<JavaFileScannerContext.Location> exceptionFlow : exceptionFlows) {
                flows.add((Object)ImmutableList.builder().addAll(exceptionFlow).add((Object)methodInvocationMessage).addAll(argumentFlow).build());
            }
        }
        check.reportIssue(reportTree, String.format(this.message, methodName), (Set<List<JavaFileScannerContext.Location>>)flows.build());
    }

    private static Set<List<JavaFileScannerContext.Location>> flowsForMethodArguments(ExplodedGraph.Node node, MethodInvocationTree mit) {
        ProgramState programState = node.programState;
        List arguments = Lists.reverse(programState.peekValues(mit.arguments().size()));
        List<Class<? extends Constraint>> domains = ExceptionalYieldChecker.domainsFromArguments(programState, arguments);
        return FlowComputation.flow(node, new LinkedHashSet<SymbolicValue>(arguments), c -> true, c -> false, domains, programState.getLastEvaluated());
    }

    private static List<Class<? extends Constraint>> domainsFromArguments(ProgramState programState, List<SymbolicValue> arguments) {
        return arguments.stream().map(programState::getConstraints).filter(Objects::nonNull).map(ExceptionalYieldChecker::domainsFromConstraints).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private static List<Class<? extends Constraint>> domainsFromConstraints(PMap<Class<? extends Constraint>, Constraint> constraints) {
        ArrayList<Class<? extends Constraint>> domains = new ArrayList<Class<? extends Constraint>>();
        constraints.forEach((d, c) -> domains.add((Class<? extends Constraint>)d));
        return domains;
    }
}

