/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.constraint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.se.Pair;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.SymbolicValueFactory;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

public class ConstraintManager {
    private SymbolicValueFactory symbolicValueFactory;

    public void setValueFactory(SymbolicValueFactory valueFactory) {
        Preconditions.checkState((this.symbolicValueFactory == null ? 1 : 0) != 0, (Object)"The symbolic value factory has already been defined by another checker!");
        this.symbolicValueFactory = valueFactory;
    }

    public SymbolicValue createSymbolicValue(Tree syntaxNode) {
        SymbolicValue result;
        switch (syntaxNode.kind()) {
            case LOGICAL_COMPLEMENT: {
                result = new SymbolicValue.NotSymbolicValue();
                break;
            }
            case INSTANCE_OF: {
                result = new SymbolicValue.InstanceOfSymbolicValue();
                break;
            }
            case MEMBER_SELECT: {
                result = this.createIdentifierSymbolicValue(((MemberSelectExpressionTree)syntaxNode).identifier());
                break;
            }
            case IDENTIFIER: {
                result = this.createIdentifierSymbolicValue((IdentifierTree)syntaxNode);
                break;
            }
            default: {
                result = this.createDefaultSymbolicValue();
            }
        }
        return result;
    }

    public SymbolicValue createBinarySymbolicValue(Tree syntaxNode, List<SymbolicValue> computedFrom) {
        SymbolicValue result;
        switch (syntaxNode.kind()) {
            case EQUAL_TO: {
                result = ConstraintManager.createRelationalSymbolicValue(RelationalSymbolicValue.Kind.EQUAL, computedFrom);
                break;
            }
            case NOT_EQUAL_TO: {
                result = ConstraintManager.createRelationalSymbolicValue(RelationalSymbolicValue.Kind.NOT_EQUAL, computedFrom);
                break;
            }
            case LESS_THAN: {
                result = ConstraintManager.createRelationalSymbolicValue(RelationalSymbolicValue.Kind.LESS_THAN, computedFrom);
                break;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                result = ConstraintManager.createRelationalSymbolicValue(RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL, Lists.reverse(computedFrom));
                break;
            }
            case GREATER_THAN: {
                result = ConstraintManager.createRelationalSymbolicValue(RelationalSymbolicValue.Kind.LESS_THAN, Lists.reverse(computedFrom));
                break;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                result = ConstraintManager.createRelationalSymbolicValue(RelationalSymbolicValue.Kind.GREATER_THAN_OR_EQUAL, computedFrom);
                break;
            }
            case AND: 
            case AND_ASSIGNMENT: {
                result = new SymbolicValue.AndSymbolicValue();
                result.computedFrom(computedFrom);
                break;
            }
            case OR: 
            case OR_ASSIGNMENT: {
                result = new SymbolicValue.OrSymbolicValue();
                result.computedFrom(computedFrom);
                break;
            }
            case XOR: 
            case XOR_ASSIGNMENT: {
                result = new SymbolicValue.XorSymbolicValue();
                result.computedFrom(computedFrom);
                break;
            }
            default: {
                result = this.createDefaultSymbolicValue();
                result.computedFrom(computedFrom);
            }
        }
        return result;
    }

    private static RelationalSymbolicValue createRelationalSymbolicValue(RelationalSymbolicValue.Kind kind, List<SymbolicValue> computedFrom) {
        RelationalSymbolicValue result = new RelationalSymbolicValue(kind);
        result.computedFrom(computedFrom);
        return result;
    }

    public SymbolicValue.ExceptionalSymbolicValue createExceptionalSymbolicValue(@Nullable Type exceptionType) {
        return new SymbolicValue.ExceptionalSymbolicValue(exceptionType);
    }

    public SymbolicValue createMethodSymbolicValue(MethodInvocationTree syntaxNode, List<SymbolicValue> values) {
        SymbolicValue result;
        if (ConstraintManager.isEqualsMethod(syntaxNode) || ConstraintManager.isObjectsEqualsMethod(syntaxNode.symbol())) {
            result = new RelationalSymbolicValue(RelationalSymbolicValue.Kind.METHOD_EQUALS);
            SymbolicValue leftOp = values.get(1);
            SymbolicValue rightOp = values.get(0);
            result.computedFrom((List<SymbolicValue>)ImmutableList.of((Object)rightOp, (Object)leftOp));
        } else {
            result = this.createDefaultSymbolicValue();
        }
        return result;
    }

    private static boolean isObjectsEqualsMethod(Symbol symbol) {
        return symbol.isMethodSymbol() && symbol.owner().type().is("java.util.Objects") && "equals".equals(symbol.name());
    }

    private static boolean isEqualsMethod(MethodInvocationTree syntaxNode) {
        MemberSelectExpressionTree expression;
        ExpressionTree methodSelect;
        if (syntaxNode.arguments().size() == 1 && (methodSelect = syntaxNode.methodSelect()).is(Tree.Kind.MEMBER_SELECT) && "equals".equals((expression = (MemberSelectExpressionTree)methodSelect).identifier().name()) && syntaxNode.symbol().isMethodSymbol()) {
            Symbol.MethodSymbol symbol = (Symbol.MethodSymbol)syntaxNode.symbol();
            return symbol.parameterTypes().get(0).is("java.lang.Object");
        }
        return false;
    }

    private SymbolicValue createIdentifierSymbolicValue(IdentifierTree identifier) {
        Type type = identifier.symbol().type();
        if (type != null && type.is("java.lang.Boolean")) {
            if ("TRUE".equals(identifier.name())) {
                return SymbolicValue.TRUE_LITERAL;
            }
            if ("FALSE".equals(identifier.name())) {
                return SymbolicValue.FALSE_LITERAL;
            }
        }
        return this.createDefaultSymbolicValue();
    }

    private SymbolicValue createDefaultSymbolicValue() {
        SymbolicValue result = this.symbolicValueFactory == null ? new SymbolicValue() : this.symbolicValueFactory.createSymbolicValue();
        this.symbolicValueFactory = null;
        return result;
    }

    public boolean isNull(ProgramState ps, SymbolicValue val) {
        ObjectConstraint constraint = ps.getConstraint(val, ObjectConstraint.class);
        return constraint != null && constraint.isNull();
    }

    public Pair<List<ProgramState>, List<ProgramState>> assumeDual(ProgramState programState) {
        ProgramState.Pop unstack = programState.unstackValue(1);
        SymbolicValue sv = unstack.values.get(0);
        List<ProgramState> falseConstraint = sv.setConstraint(unstack.state, BooleanConstraint.FALSE);
        List<ProgramState> trueConstraint = sv.setConstraint(unstack.state, BooleanConstraint.TRUE);
        return new Pair<List<ProgramState>, List<ProgramState>>(falseConstraint, trueConstraint);
    }
}

