/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.symbolicvalues;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.constraint.TypedConstraint;
import org.sonar.java.se.symbolicvalues.BinarySymbolicValue;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.plugins.java.api.semantic.Type;

public class SymbolicValue {
    public static final SymbolicValue NULL_LITERAL = new SymbolicValue(){

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            return ImmutableList.of();
        }

        @Override
        public List<ProgramState> setConstraint(ProgramState programState, Constraint constraint) {
            if (constraint instanceof ObjectConstraint) {
                return super.setConstraint(programState, (ObjectConstraint)constraint);
            }
            return ImmutableList.of((Object)programState);
        }

        @Override
        public String toString() {
            return "SV_NULL";
        }
    };
    public static final SymbolicValue TRUE_LITERAL = new SymbolicValue(){

        @Override
        public String toString() {
            return "SV_TRUE";
        }
    };
    public static final SymbolicValue FALSE_LITERAL = new SymbolicValue(){

        @Override
        public String toString() {
            return "SV_FALSE";
        }
    };
    public static final List<SymbolicValue> PROTECTED_SYMBOLIC_VALUES = ImmutableList.of((Object)NULL_LITERAL, (Object)TRUE_LITERAL, (Object)FALSE_LITERAL);

    public static boolean isDisposable(SymbolicValue symbolicValue) {
        if (symbolicValue instanceof NotSymbolicValue) {
            NotSymbolicValue notSV = (NotSymbolicValue)symbolicValue;
            return !(notSV.operand instanceof RelationalSymbolicValue);
        }
        return !PROTECTED_SYMBOLIC_VALUES.contains(symbolicValue) && !(symbolicValue instanceof RelationalSymbolicValue);
    }

    public boolean references(SymbolicValue other) {
        return false;
    }

    public String toString() {
        return "SV_" + this.hashCode() % 100;
    }

    public void computedFrom(List<SymbolicValue> symbolicValues) {
    }

    public List<SymbolicValue> computedFrom() {
        return Collections.emptyList();
    }

    public List<ProgramState> setConstraint(ProgramState programState, ObjectConstraint nullConstraint) {
        Object constraint = programState.getConstraint(this, nullConstraint.getClass());
        if (constraint == null) {
            if (nullConstraint.isNull()) {
                PMap<Class<? extends Constraint>, Constraint> onlyNullConstraint = PCollections.emptyMap().put(ObjectConstraint.class, ObjectConstraint.NULL);
                return ImmutableList.of((Object)programState.addConstraints(this, onlyNullConstraint));
            }
            return ImmutableList.of((Object)programState.addConstraint(this, nullConstraint));
        }
        if (constraint != nullConstraint) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)programState);
    }

    public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
        Object cstraint = programState.getConstraint(this, booleanConstraint.getClass());
        if (!booleanConstraint.isValidWith((Constraint)cstraint)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)programState.addConstraint(this, booleanConstraint));
    }

    public List<ProgramState> setConstraint(ProgramState programState, Constraint constraint) {
        if (constraint instanceof BooleanConstraint) {
            return this.setConstraint(programState, (BooleanConstraint)constraint);
        }
        if (constraint instanceof ObjectConstraint) {
            return this.setConstraint(programState, (ObjectConstraint)constraint);
        }
        Object csrtaint = programState.getConstraint(this, constraint.getClass());
        if (constraint.isValidWith((Constraint)csrtaint)) {
            return ImmutableList.of((Object)programState.addConstraint(this, constraint));
        }
        return ImmutableList.of();
    }

    public ProgramState setSingleConstraint(ProgramState programState, ObjectConstraint nullConstraint) {
        List<ProgramState> states = this.setConstraint(programState, nullConstraint);
        if (states.size() != 1) {
            throw new IllegalStateException("Only a single program state is expected at this location");
        }
        return states.get(0);
    }

    public SymbolicValue wrappedValue() {
        return this;
    }

    public static class XorSymbolicValue
    extends BooleanExpressionSymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
            for (ProgramState ps : trueFirstOp) {
                XorSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint.inverse()));
            }
            List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
            for (ProgramState ps : falseFirstOp) {
                XorSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " ^ " + this.rightOp;
        }
    }

    public static class OrSymbolicValue
    extends BooleanExpressionSymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (booleanConstraint.isTrue()) {
                List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
                for (ProgramState ps : trueFirstOp) {
                    OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.TRUE));
                    OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.FALSE));
                }
            }
            List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
            for (ProgramState ps : falseFirstOp) {
                OrSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " | " + this.rightOp;
        }
    }

    public static class AndSymbolicValue
    extends BooleanExpressionSymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            if (booleanConstraint.isFalse()) {
                List<ProgramState> falseFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.FALSE);
                for (ProgramState ps : falseFirstOp) {
                    AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.TRUE));
                    AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, BooleanConstraint.FALSE));
                }
            }
            List<ProgramState> trueFirstOp = this.leftOp.setConstraint(programState, BooleanConstraint.TRUE);
            for (ProgramState ps : trueFirstOp) {
                AndSymbolicValue.addStates(states, this.rightOp.setConstraint(ps, booleanConstraint));
            }
            return states;
        }

        @Override
        public String toString() {
            return this.leftOp + " & " + this.rightOp;
        }
    }

    public static abstract class BooleanExpressionSymbolicValue
    extends BinarySymbolicValue {
        protected static void addStates(List<ProgramState> states, List<ProgramState> newStates) {
            if (states.size() > 10000 || newStates.size() > 10000) {
                throw new ExplodedGraphWalker.TooManyNestedBooleanStatesException();
            }
            states.addAll(newStates);
        }
    }

    public static class InstanceOfSymbolicValue
    extends UnarySymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            if (booleanConstraint.isTrue()) {
                ObjectConstraint constraint = programState.getConstraint(this.operand, ObjectConstraint.class);
                if (constraint != null && constraint.isNull()) {
                    return ImmutableList.of();
                }
                List<ProgramState> ps = this.operand.setConstraint(programState, ObjectConstraint.NOT_NULL);
                if (ps.size() == 1 && ps.get(0).equals(programState)) {
                    return ImmutableList.of((Object)programState.addConstraint(this, new TypedConstraint()));
                }
                return ps;
            }
            return ImmutableList.of((Object)programState);
        }
    }

    public static class NotSymbolicValue
    extends UnarySymbolicValue {
        @Override
        public List<ProgramState> setConstraint(ProgramState programState, BooleanConstraint booleanConstraint) {
            return this.operand.setConstraint(programState, booleanConstraint.inverse());
        }

        @Override
        public String toString() {
            return "!(" + this.operand + ")";
        }
    }

    public static class ExceptionalSymbolicValue
    extends SymbolicValue {
        @Nullable
        private final Type exceptionType;

        public ExceptionalSymbolicValue(@Nullable Type exceptionType) {
            this.exceptionType = exceptionType;
        }

        @CheckForNull
        public Type exceptionType() {
            return this.exceptionType;
        }

        @Override
        public String toString() {
            return super.toString() + "_" + (this.exceptionType == null ? "!unknownException" : this.exceptionType.fullyQualifiedName()) + "!";
        }
    }

    public static abstract class UnarySymbolicValue
    extends SymbolicValue {
        protected SymbolicValue operand;

        @Override
        public boolean references(SymbolicValue other) {
            return this.operand.equals(other) || this.operand.references(other);
        }

        @Override
        public void computedFrom(List<SymbolicValue> symbolicValues) {
            Preconditions.checkArgument((symbolicValues.size() == 1 ? 1 : 0) != 0);
            this.operand = symbolicValues.get(0);
        }

        @Override
        public List<SymbolicValue> computedFrom() {
            return ImmutableList.of((Object)this.operand);
        }
    }
}

