/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import com.google.common.annotations.VisibleForTesting;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.java.collections.PCollections;
import org.sonar.java.collections.PMap;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.xproc.ExceptionalYield;
import org.sonar.java.se.xproc.HappyPathYield;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;

public class BehaviorCache {
    private final SymbolicExecutionVisitor sev;
    @VisibleForTesting
    public final Map<Symbol.MethodSymbol, MethodBehavior> behaviors = new LinkedHashMap<Symbol.MethodSymbol, MethodBehavior>();

    public BehaviorCache(SymbolicExecutionVisitor sev) {
        this.sev = sev;
    }

    public MethodBehavior methodBehaviorForSymbol(Symbol.MethodSymbol symbol) {
        return this.behaviors.computeIfAbsent(symbol, MethodBehavior::new);
    }

    @CheckForNull
    public MethodBehavior get(Symbol.MethodSymbol symbol) {
        if (!this.behaviors.containsKey(symbol)) {
            if (BehaviorCache.isObjectsRequireNonNullMethod(symbol)) {
                this.behaviors.put(symbol, BehaviorCache.createRequireNonNullBehavior(symbol));
            } else if (BehaviorCache.isObjectsNullMethod(symbol)) {
                this.behaviors.put(symbol, BehaviorCache.createIsNullBehavior(symbol));
            } else if (BehaviorCache.isStringUtilsMethod(symbol)) {
                MethodBehavior stringUtilsMethod = BehaviorCache.createStringUtilMethodBehavior(symbol);
                if (stringUtilsMethod != null) {
                    this.behaviors.put(symbol, stringUtilsMethod);
                }
            } else if (BehaviorCache.isGuavaPrecondition(symbol)) {
                this.behaviors.put(symbol, BehaviorCache.createGuavaPreconditionsBehavior(symbol, "checkNotNull".equals(symbol.name())));
            } else {
                MethodTree declaration = symbol.declaration();
                if (declaration != null && SymbolicExecutionVisitor.methodCanNotBeOverriden(symbol)) {
                    this.sev.execute(declaration);
                }
            }
        }
        return this.behaviors.get(symbol);
    }

    private static boolean isGuavaPrecondition(Symbol.MethodSymbol symbol) {
        String name = symbol.name();
        return symbol.owner().type().is("com.google.common.base.Preconditions") && ("checkNotNull".equals(name) || "checkArgument".equals(name) || "checkState".equals(name));
    }

    private static boolean isStringUtilsMethod(Symbol.MethodSymbol symbol) {
        Type ownerType = symbol.owner().type();
        return ownerType.is("org.apache.commons.lang3.StringUtils") || ownerType.is("org.apache.commons.lang.StringUtils");
    }

    private static boolean isObjectsNullMethod(Symbol.MethodSymbol symbol) {
        return symbol.owner().type().is("java.util.Objects") && ("nonNull".equals(symbol.name()) || "isNull".equals(symbol.name()));
    }

    private static boolean isObjectsRequireNonNullMethod(Symbol symbol) {
        return symbol.owner().type().is("java.util.Objects") && "requireNonNull".equals(symbol.name());
    }

    @CheckForNull
    private static MethodBehavior createStringUtilMethodBehavior(Symbol.MethodSymbol symbol) {
        MethodBehavior behavior;
        switch (symbol.name()) {
            case "isNotEmpty": 
            case "isNotBlank": {
                behavior = BehaviorCache.createIsEmptyOrBlankMethodBehavior(symbol, BooleanConstraint.FALSE);
                break;
            }
            case "isEmpty": 
            case "isBlank": {
                behavior = BehaviorCache.createIsEmptyOrBlankMethodBehavior(symbol, BooleanConstraint.TRUE);
                break;
            }
            default: {
                behavior = null;
            }
        }
        return behavior;
    }

    private static MethodBehavior createIsEmptyOrBlankMethodBehavior(Symbol.MethodSymbol symbol, Constraint constraint) {
        MethodBehavior behavior = new MethodBehavior(symbol);
        HappyPathYield nullYield = new HappyPathYield(behavior);
        nullYield.parametersConstraints.add(BehaviorCache.pmapForConstraint(ObjectConstraint.NULL));
        nullYield.setResult(-1, BehaviorCache.pmapForConstraint(constraint));
        behavior.addYield(nullYield);
        HappyPathYield notNullYield = new HappyPathYield(behavior);
        notNullYield.parametersConstraints.add(BehaviorCache.pmapForConstraint(ObjectConstraint.NOT_NULL));
        behavior.addYield(notNullYield);
        behavior.completed();
        return behavior;
    }

    private static PMap<Class<? extends Constraint>, Constraint> pmapForConstraint(Constraint constraint) {
        return PCollections.emptyMap().put(constraint.getClass(), constraint);
    }

    private static MethodBehavior createRequireNonNullBehavior(Symbol.MethodSymbol symbol) {
        MethodBehavior behavior = new MethodBehavior(symbol);
        HappyPathYield happyYield = new HappyPathYield(behavior);
        happyYield.parametersConstraints.add(BehaviorCache.pmapForConstraint(ObjectConstraint.NOT_NULL));
        for (int i = 1; i < symbol.parameterTypes().size(); ++i) {
            happyYield.parametersConstraints.add(PCollections.emptyMap());
        }
        happyYield.setResult(0, (PMap)happyYield.parametersConstraints.get(0));
        behavior.addYield(happyYield);
        ExceptionalYield exceptionalYield = new ExceptionalYield(behavior);
        exceptionalYield.parametersConstraints.add(BehaviorCache.pmapForConstraint(ObjectConstraint.NULL));
        for (int i = 1; i < symbol.parameterTypes().size(); ++i) {
            exceptionalYield.parametersConstraints.add(PCollections.emptyMap());
        }
        behavior.addYield(exceptionalYield);
        behavior.completed();
        return behavior;
    }

    private static MethodBehavior createIsNullBehavior(Symbol.MethodSymbol symbol) {
        boolean isNull = "isNull".equals(symbol.name());
        ObjectConstraint trueConstraint = isNull ? ObjectConstraint.NULL : ObjectConstraint.NOT_NULL;
        ObjectConstraint falseConstraint = isNull ? ObjectConstraint.NOT_NULL : ObjectConstraint.NULL;
        MethodBehavior behavior = new MethodBehavior(symbol);
        HappyPathYield trueYield = new HappyPathYield(behavior);
        trueYield.parametersConstraints.add(BehaviorCache.pmapForConstraint(trueConstraint));
        trueYield.setResult(-1, BehaviorCache.pmapForConstraint(BooleanConstraint.TRUE));
        behavior.addYield(trueYield);
        HappyPathYield falseYield = new HappyPathYield(behavior);
        falseYield.parametersConstraints.add(BehaviorCache.pmapForConstraint(falseConstraint));
        falseYield.setResult(-1, BehaviorCache.pmapForConstraint(BooleanConstraint.FALSE));
        behavior.addYield(falseYield);
        behavior.completed();
        return behavior;
    }

    private static MethodBehavior createGuavaPreconditionsBehavior(Symbol.MethodSymbol symbol, boolean isCheckNotNull) {
        MethodBehavior behavior = new MethodBehavior(symbol);
        HappyPathYield happyPathYield = new HappyPathYield(behavior);
        happyPathYield.parametersConstraints.add(BehaviorCache.pmapForConstraint((Constraint)((Object)(isCheckNotNull ? ObjectConstraint.NOT_NULL : BooleanConstraint.TRUE))));
        for (int i = 1; i < symbol.parameterTypes().size(); ++i) {
            happyPathYield.parametersConstraints.add(PCollections.emptyMap());
        }
        PMap constraints = isCheckNotNull ? (PMap)happyPathYield.parametersConstraints.get(0) : null;
        happyPathYield.setResult(isCheckNotNull ? 0 : -1, constraints);
        behavior.addYield(happyPathYield);
        behavior.completed();
        return behavior;
    }
}

