/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaRestrictedKeyword;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

public class SyntaxHighlighterVisitor
extends SubscriptionVisitor {
    private final SonarComponents sonarComponents;
    private final Map<Tree.Kind, TypeOfText> typesByKind;
    private final Set<String> keywords;
    private final Set<String> restrictedKeywords;
    private NewHighlighting highlighting;
    private boolean withinModule = false;

    public SyntaxHighlighterVisitor(SonarComponents sonarComponents) {
        this.sonarComponents = sonarComponents;
        this.keywords = ImmutableSet.copyOf((Object[])JavaKeyword.keywordValues());
        this.restrictedKeywords = ImmutableSet.copyOf((Object[])JavaRestrictedKeyword.restrictedKeywordValues());
        ImmutableMap.Builder typesByKindBuilder = ImmutableMap.builder();
        typesByKindBuilder.put((Object)Tree.Kind.STRING_LITERAL, (Object)TypeOfText.STRING);
        typesByKindBuilder.put((Object)Tree.Kind.CHAR_LITERAL, (Object)TypeOfText.STRING);
        typesByKindBuilder.put((Object)Tree.Kind.FLOAT_LITERAL, (Object)TypeOfText.CONSTANT);
        typesByKindBuilder.put((Object)Tree.Kind.DOUBLE_LITERAL, (Object)TypeOfText.CONSTANT);
        typesByKindBuilder.put((Object)Tree.Kind.LONG_LITERAL, (Object)TypeOfText.CONSTANT);
        typesByKindBuilder.put((Object)Tree.Kind.INT_LITERAL, (Object)TypeOfText.CONSTANT);
        typesByKindBuilder.put((Object)Tree.Kind.ANNOTATION, (Object)TypeOfText.ANNOTATION);
        typesByKindBuilder.put((Object)Tree.Kind.VAR_TYPE, (Object)TypeOfText.KEYWORD);
        this.typesByKind = typesByKindBuilder.build();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().addAll(this.typesByKind.keySet().iterator()).add((Object)Tree.Kind.MODULE).add((Object)Tree.Kind.TOKEN).add((Object)Tree.Kind.TRIVIA).build();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        File file = context.getFile();
        this.highlighting = this.sonarComponents.highlightableFor(file);
        super.scanFile(context);
        this.highlighting.save();
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.MODULE)) {
            this.withinModule = true;
            return;
        }
        if (tree.is(Tree.Kind.ANNOTATION)) {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            this.highlight(annotationTree.atToken(), annotationTree.annotationType(), this.typesByKind.get((Object)Tree.Kind.ANNOTATION));
        } else {
            this.highlight(tree, this.typesByKind.get((Object)tree.kind()));
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.MODULE)) {
            this.withinModule = false;
        }
    }

    private void highlight(Tree tree, TypeOfText typeOfText) {
        this.highlight(tree, tree, typeOfText);
    }

    private void highlight(Tree from, Tree to, TypeOfText typeOfText) {
        SyntaxToken firstToken = from.firstToken();
        SyntaxToken lastToken = to.lastToken();
        this.highlighting.highlight(firstToken.line(), firstToken.column(), lastToken.line(), lastToken.column() + lastToken.text().length(), typeOfText);
    }

    @Override
    public void visitToken(SyntaxToken syntaxToken) {
        String text = syntaxToken.text();
        if (this.keywords.contains(text)) {
            if (SyntaxHighlighterVisitor.isInterfaceOfAnnotationType(syntaxToken)) {
                ClassTreeImpl annotationType = (ClassTreeImpl)syntaxToken.parent();
                this.highlight(annotationType.atToken(), annotationType.declarationKeyword(), TypeOfText.KEYWORD);
            } else {
                this.highlight(syntaxToken, TypeOfText.KEYWORD);
            }
        } else if (this.isRestrictedKeyword(syntaxToken)) {
            this.highlight(syntaxToken, TypeOfText.KEYWORD);
        }
    }

    private static boolean isInterfaceOfAnnotationType(SyntaxToken syntaxToken) {
        return JavaKeyword.INTERFACE.getValue().equals(syntaxToken.text()) && syntaxToken.parent().is(Tree.Kind.ANNOTATION_TYPE);
    }

    private boolean isRestrictedKeyword(SyntaxToken syntaxToken) {
        return this.withinModule && this.restrictedKeywords.contains(syntaxToken.text()) && !syntaxToken.parent().is(Tree.Kind.IDENTIFIER);
    }

    @Override
    public void visitTrivia(SyntaxTrivia syntaxTrivia) {
        String comment = syntaxTrivia.comment();
        int startLine = syntaxTrivia.startLine();
        int startColumn = syntaxTrivia.column();
        String[] lines = comment.split("\\r\\n|\\n|\\r");
        int numberLines = lines.length;
        int endLine = startLine + numberLines - 1;
        int endColumn = numberLines == 1 ? startColumn + comment.length() : lines[numberLines - 1].length();
        boolean isJavadoc = lines[0].trim().startsWith("/**");
        this.highlighting.highlight(startLine, startColumn, endLine, endColumn, isJavadoc ? TypeOfText.STRUCTURED_COMMENT : TypeOfText.COMMENT);
    }
}

