/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.cfg;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.sonar.java.bytecode.cfg.BytecodeCFG;
import org.sonar.java.bytecode.cfg.Instruction;
import org.sonar.java.bytecode.se.MethodLookup;
import org.sonar.java.resolve.Flags;

public class BytecodeCFGMethodVisitor
extends MethodLookup.LookupMethodVisitor {
    private static final Set<String> SIGNATURE_BLACKLIST = ImmutableSet.of((Object)"java.lang.Class#", (Object)"java.lang.Object#wait", (Object)"java.util.Optional#");
    Map<Label, BytecodeCFG.Block> blockByLabel = new HashMap<Label, BytecodeCFG.Block>();
    private BytecodeCFG.Block currentBlock;
    private BytecodeCFG cfg;
    private List<TryCatchBlock> tryCatchBlocks = new ArrayList<TryCatchBlock>();
    private List<TryCatchBlock> currentTryCatches = new ArrayList<TryCatchBlock>();
    private Map<BytecodeCFG.Block, List<TryCatchBlock>> handlersToWire = new HashMap<BytecodeCFG.Block, List<TryCatchBlock>>();

    @Override
    public boolean shouldVisitMethod(int methodFlags, String methodSignature) {
        return BytecodeCFGMethodVisitor.isStatic(methodFlags) && !BytecodeCFGMethodVisitor.methodIsBlacklisted(methodSignature);
    }

    private static boolean isStatic(int methodFlags) {
        return Flags.isFlagged(methodFlags, 8);
    }

    private static boolean methodIsBlacklisted(String signature) {
        return SIGNATURE_BLACKLIST.stream().anyMatch(signature::startsWith);
    }

    @CheckForNull
    public BytecodeCFG getCfg() {
        return this.cfg;
    }

    public void visitCode() {
        this.cfg = new BytecodeCFG();
        this.currentBlock = new BytecodeCFG.Block(this.cfg);
        this.cfg.blocks.add(this.currentBlock);
    }

    public void visitInsn(int opcode) {
        this.currentBlock.addInsn(opcode);
        if (172 <= opcode && opcode <= 177 || opcode == 191) {
            this.currentBlock.successors.add(this.cfg.blocks.get(0));
            this.currentBlock = null;
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        this.currentBlock.addInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.currentBlock.addInsn(opcode, var);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.currentBlock.addInsn(opcode, new Instruction.FieldOrMethod(owner, name, desc));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.currentBlock.addInsn(opcode, new Instruction.FieldOrMethod(owner, name, desc, itf));
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.currentBlock.addInsn(new Instruction.InvokeDynamicInsn(desc));
    }

    public void visitLdcInsn(Object cst) {
        this.currentBlock.addInsn(new Instruction.LdcInsn(cst));
    }

    public void visitIincInsn(int var, int increment) {
        this.currentBlock.addInsn(132, var);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.currentBlock.addInsn(new Instruction.MultiANewArrayInsn(desc, dims));
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.currentBlock.terminator = new Instruction(170);
        this.blockByLabel.computeIfAbsent(dflt, l -> this.currentBlock.createSuccessor());
        for (Label label : labels) {
            this.blockByLabel.computeIfAbsent(label, l -> this.currentBlock.createSuccessor());
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.currentBlock.terminator = new Instruction(171);
        this.blockByLabel.computeIfAbsent(dflt, l -> this.currentBlock.createSuccessor());
        for (Label label : labels) {
            this.blockByLabel.computeIfAbsent(label, l -> this.currentBlock.createSuccessor());
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        this.currentBlock.addInsn(opcode, Type.getObjectType((String)type).getClassName());
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (opcode == 167) {
            this.currentBlock.terminator = new Instruction(opcode);
            ArrayList<BytecodeCFG.Block> successors = new ArrayList<BytecodeCFG.Block>();
            successors.add(this.blockByLabel.computeIfAbsent(label, l -> this.currentBlock.createSuccessor()));
            this.currentBlock.successors = successors;
            this.currentBlock = null;
            return;
        }
        this.currentBlock.setTrueBlock(this.blockByLabel.computeIfAbsent(label, l -> this.currentBlock.createSuccessor()));
        this.currentBlock.terminator = new Instruction(opcode);
        this.currentBlock = this.currentBlock.falseBlock = this.currentBlock.createSuccessor();
        this.handlersToWire.put(this.currentBlock, new ArrayList<TryCatchBlock>(this.currentTryCatches));
    }

    public void visitLabel(Label label) {
        BytecodeCFG.Block previous = this.currentBlock;
        if (this.currentBlock == null) {
            this.currentBlock = this.blockByLabel.computeIfAbsent(label, l -> {
                BytecodeCFG.Block block = new BytecodeCFG.Block(this.cfg);
                this.cfg.blocks.add(block);
                return block;
            });
        } else {
            this.currentBlock = this.blockByLabel.computeIfAbsent(label, l -> this.currentBlock.createSuccessor());
            previous.successors.add(this.currentBlock);
        }
        this.currentTryCatches.addAll(this.handlersStartingWith(label));
        this.currentTryCatches.removeAll(this.handlersEndingWith(label));
        this.handlersToWire.put(this.currentBlock, new ArrayList<TryCatchBlock>(this.currentTryCatches));
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, @Nullable String type) {
        String exception = type == null ? null : Type.getObjectType((String)type).getClassName();
        this.tryCatchBlocks.add(new TryCatchBlock(start, end, handler, exception));
    }

    public void visitEnd() {
        if (this.currentBlock != null && this.currentBlock.successors.isEmpty()) {
            this.currentBlock.successors.add(this.cfg.blocks.get(0));
        }
        this.handlersToWire.forEach((b, tcbs) -> tcbs.forEach(tcb -> b.successors.add(tcb.blockHandler(this.blockByLabel))));
    }

    private List<TryCatchBlock> handlersStartingWith(Label label) {
        return this.tryCatchBlocks.stream().filter(h -> ((TryCatchBlock)h).start == label).collect(Collectors.toList());
    }

    private List<TryCatchBlock> handlersEndingWith(Label label) {
        return this.tryCatchBlocks.stream().filter(h -> ((TryCatchBlock)h).end == label).collect(Collectors.toList());
    }

    private static class TryCatchBlock {
        private final Label start;
        private final Label end;
        private final Label handler;
        @Nullable
        private final String type;

        TryCatchBlock(Label start, Label end, Label handler, @Nullable String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }

        BytecodeCFG.Block blockHandler(Map<Label, BytecodeCFG.Block> blockByLabel) {
            BytecodeCFG.Block blockHandler = blockByLabel.get(this.handler);
            String exType = this.type;
            if (exType == null) {
                exType = "!UncaughtException!";
            }
            blockHandler.exceptionType = exType;
            return blockHandler;
        }
    }
}

