/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.java.AnalysisError;
import org.sonar.java.ExceptionHandler;
import org.sonar.java.IllegalRuleParameterException;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.PackageUtils;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.se.SymbolicExecutionMode;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.Tree;

public class VisitorsBridge {
    private static final Logger LOG = Loggers.get(VisitorsBridge.class);
    private final List<JavaFileScanner> scanners;
    private final BehaviorCache behaviorCache;
    private List<JavaFileScanner> executableScanners;
    private final SonarComponents sonarComponents;
    private final boolean symbolicExecutionEnabled;
    private SemanticModel semanticModel;
    protected File currentFile;
    protected JavaVersion javaVersion;
    private Set<String> classesNotFound = new TreeSet<String>();
    private final SquidClassLoader classLoader;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Collections.singletonList(visitor), new ArrayList<File>(), null);
    }

    @VisibleForTesting
    public VisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        this(visitors, projectClasspath, sonarComponents, SymbolicExecutionMode.DISABLED);
    }

    public VisitorsBridge(Iterable visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents, SymbolicExecutionMode symbolicExecutionMode) {
        ImmutableList.Builder scannersBuilder = ImmutableList.builder();
        for (Object visitor : visitors) {
            if (!(visitor instanceof JavaFileScanner)) continue;
            scannersBuilder.add((Object)((JavaFileScanner)visitor));
        }
        this.scanners = scannersBuilder.build();
        this.executableScanners = this.scanners;
        this.sonarComponents = sonarComponents;
        this.classLoader = ClassLoaderBuilder.create(projectClasspath);
        this.symbolicExecutionEnabled = symbolicExecutionMode.isEnabled();
        this.behaviorCache = new BehaviorCache(this.classLoader, symbolicExecutionMode.isCrossFileEnabled());
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
        this.executableScanners = VisitorsBridge.executableScanners(this.scanners, javaVersion);
    }

    public void visitFile(@Nullable Tree parsedTree) {
        boolean fileParsed;
        this.semanticModel = null;
        CompilationUnitTree tree = new JavaTree.CompilationUnitTreeImpl(null, new ArrayList<ImportClauseTree>(), new ArrayList<Tree>(), null, null);
        boolean bl = fileParsed = parsedTree != null;
        if (fileParsed && parsedTree.is(Tree.Kind.COMPILATION_UNIT)) {
            tree = (CompilationUnitTree)parsedTree;
            if (this.isNotJavaLangOrSerializable(PackageUtils.packageName(tree.packageDeclaration(), "/"))) {
                try {
                    this.semanticModel = SemanticModel.createFor(tree, this.classLoader);
                }
                catch (Exception e) {
                    LOG.error("Unable to create symbol table for : " + this.currentFile.getAbsolutePath(), (Throwable)e);
                    this.addAnalysisError(e, this.currentFile.getPath(), AnalysisError.Kind.SEMANTIC_ERROR);
                    this.sonarComponents.reportAnalysisError(this.currentFile, e.getMessage());
                    return;
                }
                this.createSonarSymbolTable(tree);
            } else {
                SemanticModel.handleMissingTypes(tree);
            }
        }
        JavaFileScannerContext javaFileScannerContext = this.createScannerContext(tree, this.semanticModel, this.sonarComponents, fileParsed);
        if (this.symbolicExecutionEnabled && this.isNotJavaLangOrSerializable(PackageUtils.packageName(tree.packageDeclaration(), "/"))) {
            this.runScanner(javaFileScannerContext, new SymbolicExecutionVisitor(this.executableScanners, this.behaviorCache), AnalysisError.Kind.SE_ERROR);
            this.behaviorCache.cleanup();
        }
        this.executableScanners.forEach(scanner -> this.runScanner(javaFileScannerContext, (JavaFileScanner)scanner, AnalysisError.Kind.CHECK_ERROR));
        if (this.semanticModel != null) {
            this.classesNotFound.addAll(this.semanticModel.classesNotFound());
        }
    }

    private void runScanner(JavaFileScannerContext javaFileScannerContext, JavaFileScanner scanner, AnalysisError.Kind kind) {
        try {
            scanner.scanFile(javaFileScannerContext);
        }
        catch (IllegalRuleParameterException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.sonarComponents != null && this.sonarComponents.shouldFailAnalysisOnException()) {
                throw e;
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof InterruptedIOException || rootCause instanceof InterruptedException) {
                throw e;
            }
            Rule annotation = (Rule)AnnotationUtils.getAnnotation(scanner.getClass(), Rule.class);
            String key = "";
            if (annotation != null) {
                key = annotation.key();
            }
            LOG.error(String.format("Unable to run check %s - %s on file %s, To help improve SonarJava, please report this problem to SonarSource : see https://www.sonarqube.org/community/", scanner.getClass(), key, this.currentFile.getPath()), (Throwable)e);
            this.addAnalysisError(e, this.currentFile.getPath(), kind);
        }
    }

    private void addAnalysisError(Exception e, String path, AnalysisError.Kind checkError) {
        if (this.sonarComponents != null) {
            this.sonarComponents.addAnalysisError(new AnalysisError(e, path, checkError));
        }
    }

    private static List<JavaFileScanner> executableScanners(List<JavaFileScanner> scanners, JavaVersion javaVersion) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (JavaFileScanner scanner : scanners) {
            if (scanner instanceof JavaVersionAwareVisitor && !((JavaVersionAwareVisitor)((Object)scanner)).isCompatibleWithJavaVersion(javaVersion)) continue;
            results.add((Object)scanner);
        }
        return results.build();
    }

    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, SemanticModel semanticModel, SonarComponents sonarComponents, boolean fileParsed) {
        return new DefaultJavaFileScannerContext(tree, this.currentFile, semanticModel, sonarComponents, this.javaVersion, fileParsed);
    }

    private boolean isNotJavaLangOrSerializable(String packageName) {
        String name = this.currentFile.getName();
        return !VisitorsBridge.inJavaLang(packageName) && !VisitorsBridge.isAnnotation(packageName, name) && !VisitorsBridge.isSerializable(packageName, name);
    }

    private static boolean isSerializable(String packageName, String name) {
        return "java/io".equals(packageName) && "Serializable.java".equals(name);
    }

    private static boolean isAnnotation(String packageName, String name) {
        return "java/lang/annotation".equals(packageName) && "Annotation.java".equals(name);
    }

    private static boolean inJavaLang(String packageName) {
        return "java/lang".equals(packageName);
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null && !this.sonarComponents.isSonarLintContext()) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.currentFile), this.semanticModel);
            symVisitor.visitCompilationUnit(tree);
        }
    }

    public void processRecognitionException(RecognitionException e, File file) {
        this.addAnalysisError((Exception)((Object)e), file.getPath(), AnalysisError.Kind.PARSE_ERROR);
        if (this.sonarComponents == null || !this.sonarComponents.reportAnalysisError(e, file)) {
            this.visitFile(null);
            this.scanners.stream().filter(scanner -> scanner instanceof ExceptionHandler).forEach(scanner -> ((ExceptionHandler)((Object)scanner)).processRecognitionException(e));
        }
    }

    public void setCurrentFile(File currentFile) {
        this.currentFile = currentFile;
    }

    public void endOfAnalysis() {
        if (!this.classesNotFound.isEmpty()) {
            String message = "";
            if (this.classesNotFound.size() > 50) {
                message = ", ...";
            }
            LOG.warn("Classes not found during the analysis : [{}{}]", (Object)this.classesNotFound.stream().limit(50L).collect(Collectors.joining(", ")), (Object)message);
        }
        this.classLoader.close();
    }
}

