/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.FirstPass;
import org.sonar.java.resolve.LabelsVisitor;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeAndReferenceSolver;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SemanticModel {
    private final Map<Tree, Symbol> symbolsTree = new HashMap<Tree, Symbol>();
    private final Map<Symbol, Resolve.Env> symbolEnvs = Maps.newHashMap();
    private final BiMap<Tree, Resolve.Env> envs = HashBiMap.create();
    private final BytecodeCompleter bytecodeCompleter;

    @VisibleForTesting
    SemanticModel(BytecodeCompleter bytecodeCompleter) {
        this.bytecodeCompleter = bytecodeCompleter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SemanticModel createFor(CompilationUnitTree tree, SquidClassLoader classLoader) {
        ParametrizedTypeCache parametrizedTypeCache = new ParametrizedTypeCache();
        BytecodeCompleter bytecodeCompleter = new BytecodeCompleter(classLoader, parametrizedTypeCache);
        Symbols symbols = new Symbols(bytecodeCompleter);
        SemanticModel semanticModel = new SemanticModel(bytecodeCompleter);
        try {
            Resolve resolve = new Resolve(symbols, bytecodeCompleter, parametrizedTypeCache);
            TypeAndReferenceSolver typeAndReferenceSolver = new TypeAndReferenceSolver(semanticModel, symbols, resolve, parametrizedTypeCache);
            new FirstPass(semanticModel, symbols, resolve, parametrizedTypeCache, typeAndReferenceSolver).visitCompilationUnit(tree);
            typeAndReferenceSolver.visitCompilationUnit(tree);
            new LabelsVisitor(semanticModel).visitCompilationUnit(tree);
        }
        finally {
            SemanticModel.handleMissingTypes(tree);
        }
        return semanticModel;
    }

    public static void handleMissingTypes(Tree tree) {
        new MissingTypeHandler().handleMissingTypes(tree);
    }

    public void saveEnv(Symbol symbol, Resolve.Env env) {
        this.symbolEnvs.put(symbol, env);
    }

    public Resolve.Env getEnv(Symbol symbol) {
        return this.symbolEnvs.get(symbol);
    }

    public void associateEnv(Tree tree, Resolve.Env env) {
        this.envs.put((Object)tree, (Object)env);
    }

    public Tree getTree(Resolve.Env env) {
        return (Tree)this.envs.inverse().get((Object)env);
    }

    public Resolve.Env getEnv(Tree tree) {
        Resolve.Env result = null;
        for (Tree node = tree; result == null && node != null; node = node.parent()) {
            result = (Resolve.Env)this.envs.get((Object)node);
        }
        return result;
    }

    public Symbol getEnclosingClass(Tree tree) {
        return this.getEnv((Tree)tree).enclosingClass;
    }

    public Type getClassType(String fullyQualifiedName) {
        return this.bytecodeCompleter.loadClass(fullyQualifiedName).type();
    }

    public void associateSymbol(Tree tree, Symbol symbol) {
        Preconditions.checkNotNull((Object)symbol);
        this.symbolsTree.put(tree, symbol);
    }

    @Nullable
    public Symbol getSymbol(Tree tree) {
        return this.symbolsTree.get(tree);
    }

    @VisibleForTesting
    Map<Tree, Symbol> getSymbolsTree() {
        return Collections.unmodifiableMap(this.symbolsTree);
    }

    public Set<String> classesNotFound() {
        return this.bytecodeCompleter.classesNotFound();
    }

    private static class MissingTypeHandler {
        private Deque<JavaTree> parentList = new LinkedList<JavaTree>();

        private MissingTypeHandler() {
        }

        void handleMissingTypes(Tree tree) {
            this.parentList.push((JavaTree)tree);
            while (!this.parentList.isEmpty()) {
                JavaTree parent = this.parentList.pop();
                if (parent instanceof AbstractTypedTree) {
                    ((AbstractTypedTree)parent).completeMissingType();
                }
                if (parent.isLeaf()) continue;
                for (Tree nextTree : parent.getChildren()) {
                    JavaTree next = (JavaTree)nextTree;
                    if (next == null) continue;
                    next.setParent(parent);
                    this.parentList.push(next);
                }
            }
        }
    }
}

