/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.resolve.Flags;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SymbolicExecutionVisitor
extends SubscriptionVisitor {
    private static final Logger LOG = Loggers.get(SymbolicExecutionVisitor.class);
    @VisibleForTesting
    public BehaviorCache behaviorCache;
    private final ExplodedGraphWalker.ExplodedGraphWalkerFactory egwFactory;

    public SymbolicExecutionVisitor(List<JavaFileScanner> executableScanners, BehaviorCache behaviorCache) {
        this.egwFactory = new ExplodedGraphWalker.ExplodedGraphWalkerFactory(executableScanners);
        this.behaviorCache = behaviorCache;
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.behaviorCache.setFileContext(this, (SemanticModel)context.getSemanticModel());
        super.scanFile(context);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Lists.newArrayList((Object[])new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR});
    }

    @Override
    public void visitNode(Tree tree) {
        this.execute((MethodTree)tree);
    }

    public void execute(MethodTree methodTree) {
        block5: {
            ExplodedGraphWalker walker = this.getWalker();
            try {
                Symbol.MethodSymbol methodSymbol = methodTree.symbol();
                if (SymbolicExecutionVisitor.methodCanNotBeOverriden(methodSymbol)) {
                    MethodBehavior methodBehavior = this.behaviorCache.methodBehaviorForSymbol(methodSymbol);
                    if (!methodBehavior.isVisited()) {
                        methodBehavior = walker.visitMethod(methodTree, methodBehavior);
                        methodBehavior.completed();
                    }
                } else {
                    walker.visitMethod(methodTree);
                }
            }
            catch (ExplodedGraphWalker.ExplodedGraphTooBigException | ExplodedGraphWalker.MaximumStepsReachedException exception) {
                LOG.debug("Could not complete symbolic execution: ", (Object)exception);
                if (walker.methodBehavior == null) break block5;
                walker.methodBehavior.visited();
            }
        }
    }

    @VisibleForTesting
    protected ExplodedGraphWalker getWalker() {
        return this.egwFactory.createWalker(this.behaviorCache, (SemanticModel)this.context.getSemanticModel());
    }

    public static boolean methodCanNotBeOverriden(Symbol.MethodSymbol methodSymbol) {
        if (Flags.isFlagged(((JavaSymbol.MethodJavaSymbol)methodSymbol).flags(), 256)) {
            return false;
        }
        return !methodSymbol.isAbstract() && (methodSymbol.isPrivate() || methodSymbol.isFinal() || methodSymbol.isStatic() || methodSymbol.owner().isFinal());
    }
}

