/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.cfg.CFG;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.Flow;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.ExceptionalYieldChecker;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.SyntaxTreeNameFinder;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2259")
public class NullDereferenceCheck
extends SECheck {
    private static final ExceptionalYieldChecker EXCEPTIONAL_YIELD_CHECKER = new ExceptionalYieldChecker("\"NullPointerException\" will be thrown when invoking method \"%s()\".");
    private static final String JAVA_LANG_NPE = "java.lang.NullPointerException";
    private Deque<Set<NullDereferenceIssue>> detectedIssues = new ArrayDeque<Set<NullDereferenceIssue>>();

    @Override
    public void init(MethodTree methodTree, CFG cfg) {
        this.detectedIssues.push(new HashSet());
    }

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        if (context.getState().peekValue() == null) {
            return context.getState();
        }
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)syntaxNode;
            ExpressionTree methodSelect = methodInvocation.methodSelect();
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                SymbolicValue dereferencedSV = context.getState().peekValue(methodInvocation.arguments().size());
                return this.checkConstraint(context, methodSelect, dereferencedSV);
            }
        }
        if (syntaxNode.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
            ExpressionTree toCheck = ((ArrayAccessExpressionTree)syntaxNode).expression();
            SymbolicValue currentVal = context.getState().peekValue(1);
            return this.checkConstraint(context, toCheck, currentVal);
        }
        if (syntaxNode.is(Tree.Kind.MEMBER_SELECT)) {
            return this.checkMemberSelect(context, (MemberSelectExpressionTree)syntaxNode, context.getState().peekValue());
        }
        return context.getState();
    }

    private ProgramState checkMemberSelect(CheckerContext context, MemberSelectExpressionTree mse, SymbolicValue currentVal) {
        if ("class".equals(mse.identifier().name())) {
            return context.getState();
        }
        return this.checkConstraint(context, mse, currentVal);
    }

    private ProgramState checkConstraint(CheckerContext context, Tree syntaxNode, SymbolicValue currentVal) {
        ProgramState programState = context.getState();
        ObjectConstraint constraint = programState.getConstraint(currentVal, ObjectConstraint.class);
        if (constraint != null && constraint.isNull()) {
            NullDereferenceIssue issue = new NullDereferenceIssue(context.getNode(), currentVal, syntaxNode);
            this.detectedIssues.peek().add(issue);
            context.addExceptionalYield(currentVal, programState, JAVA_LANG_NPE, this);
            return null;
        }
        constraint = programState.getConstraint(currentVal, ObjectConstraint.class);
        if (constraint == null) {
            context.addExceptionalYield(currentVal, programState.addConstraint(currentVal, ObjectConstraint.NULL), JAVA_LANG_NPE, this);
            return programState.addConstraint(currentVal, ObjectConstraint.NOT_NULL);
        }
        return programState;
    }

    private void reportIssue(SymbolicValue currentVal, Tree syntaxNode, ExplodedGraph.Node node) {
        String message = "A \"NullPointerException\" could be thrown; ";
        message = syntaxNode.is(Tree.Kind.MEMBER_SELECT) && ((MemberSelectExpressionTree)syntaxNode).expression().is(Tree.Kind.METHOD_INVOCATION) ? message + "\"" + SyntaxTreeNameFinder.getName(syntaxNode) + "()\" can return null." : message + "\"" + SyntaxTreeNameFinder.getName(syntaxNode) + "\" is nullable here.";
        SymbolicValue val = null;
        if (!SymbolicValue.NULL_LITERAL.equals(currentVal)) {
            val = currentVal;
        }
        Symbol dereferencedSymbol = NullDereferenceCheck.dereferencedSymbol(syntaxNode);
        Set<Flow> flows = FlowComputation.flow(node, val, Lists.newArrayList((Object[])new Class[]{ObjectConstraint.class}), dereferencedSymbol).stream().filter(f -> !f.isEmpty()).map(f -> NullDereferenceCheck.addDereferenceMessage(f, syntaxNode)).collect(Collectors.toSet());
        this.reportIssue(syntaxNode, message, flows);
    }

    @Nullable
    private static Symbol dereferencedSymbol(Tree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.MEMBER_SELECT)) {
            ExpressionTree memberSelectExpr = ((MemberSelectExpressionTree)syntaxNode).expression();
            if (memberSelectExpr.is(Tree.Kind.IDENTIFIER)) {
                return ((IdentifierTree)memberSelectExpr).symbol();
            }
        }
        return null;
    }

    private static Flow addDereferenceMessage(Flow flow, Tree syntaxNode) {
        String symbolName = SyntaxTreeNameFinder.getName(syntaxNode);
        String msg = syntaxNode.is(Tree.Kind.MEMBER_SELECT) && ((MemberSelectExpressionTree)syntaxNode).expression().is(Tree.Kind.METHOD_INVOCATION) ? String.format("Result of '%s()' is dereferenced.", symbolName) : String.format("'%s' is dereferenced.", symbolName);
        return Flow.builder().add(new JavaFileScannerContext.Location(msg, syntaxNode)).addAll(flow).build();
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        if (syntaxNode.is(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT) && context.getConstraintManager().isNull(context.getState(), context.getState().peekValue())) {
            NullDereferenceIssue issue = new NullDereferenceIssue(context.getNode(), context.getState().peekValue(), syntaxNode);
            this.detectedIssues.peek().add(issue);
            context.createSink();
            return context.getState();
        }
        List<ProgramState> programStates = NullDereferenceCheck.setNullConstraint(context, syntaxNode);
        for (ProgramState programState : programStates) {
            context.addTransition(programState);
        }
        return context.getState();
    }

    private static List<ProgramState> setNullConstraint(CheckerContext context, Tree syntaxNode) {
        SymbolicValue val = context.getState().peekValue();
        if (syntaxNode.is(Tree.Kind.METHOD_INVOCATION) && NullDereferenceCheck.isAnnotatedCheckForNull((MethodInvocationTree)syntaxNode)) {
            Preconditions.checkNotNull((Object)val);
            ArrayList<ProgramState> states = new ArrayList<ProgramState>();
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.NULL));
            states.addAll(val.setConstraint(context.getState(), ObjectConstraint.NOT_NULL));
            return states;
        }
        return Lists.newArrayList((Object[])new ProgramState[]{context.getState()});
    }

    private static boolean isAnnotatedCheckForNull(MethodInvocationTree syntaxNode) {
        return syntaxNode.symbol().metadata().isAnnotatedWith("javax.annotation.CheckForNull");
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        EXCEPTIONAL_YIELD_CHECKER.reportOnExceptionalYield(context.getNode(), this);
    }

    @Override
    public void checkEndOfExecution(CheckerContext context) {
        this.reportIssues();
    }

    @Override
    public void interruptedExecution(CheckerContext context) {
        this.reportIssues();
    }

    private void reportIssues() {
        Set<NullDereferenceIssue> issues = this.detectedIssues.pop();
        issues.forEach(issue -> this.reportIssue(issue.symbolicValue, issue.tree, issue.node));
    }

    private static class NullDereferenceIssue {
        final ExplodedGraph.Node node;
        final SymbolicValue symbolicValue;
        final Tree tree;

        private NullDereferenceIssue(ExplodedGraph.Node node, SymbolicValue symbolicValue, Tree tree) {
            this.node = node;
            this.symbolicValue = symbolicValue;
            this.tree = tree;
        }
    }
}

