/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.constraint;

import javax.annotation.Nullable;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;

public enum ObjectConstraint implements Constraint
{
    NULL,
    NOT_NULL;


    public boolean isNull() {
        return this == NULL;
    }

    @Override
    public boolean hasPreciseValue() {
        return this == NULL;
    }

    @Override
    public String valueAsString() {
        if (this == NULL) {
            return "null";
        }
        return "not null";
    }

    @Override
    public boolean isValidWith(@Nullable Constraint constraint) {
        return constraint == null || this == constraint;
    }

    @Override
    @Nullable
    public Constraint copyOver(RelationalSymbolicValue.Kind kind) {
        switch (kind) {
            case EQUAL: 
            case METHOD_EQUALS: {
                return this;
            }
        }
        return this == NULL ? NOT_NULL : null;
    }

    @Override
    public Constraint inverse() {
        if (this == NULL) {
            return NOT_NULL;
        }
        return NULL;
    }
}

