/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.AnalysisException;
import org.sonar.java.JavaSquid;
import org.sonar.java.cfg.CFG;
import org.sonar.java.cfg.VariableReadExtractor;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.ucfg.Expression;
import org.sonar.ucfg.Label;
import org.sonar.ucfg.LocationInFile;
import org.sonar.ucfg.UCFG;
import org.sonar.ucfg.UCFGBuilder;
import org.sonar.ucfg.UCFGtoProtobuf;

public class UCFGJavaVisitor
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Logger LOG = Loggers.get(JavaSquid.class);
    private final File protobufDirectory;
    String javaFileKey;
    private int index = 0;

    public UCFGJavaVisitor(File workdir) {
        this.protobufDirectory = new File(new File(workdir, "ucfg"), "java");
        if (this.protobufDirectory.exists()) {
            this.index = this.protobufDirectory.list().length;
        } else {
            this.protobufDirectory.mkdirs();
        }
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.javaFileKey = context.getFileKey();
        if (context.getSemanticModel() == null) {
            return;
        }
        this.scan(context.getTree());
    }

    @Override
    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        Symbol.MethodSymbol methodSymbol = tree.symbol();
        ArrayList<Type> types = new ArrayList<Type>(methodSymbol.parameterTypes());
        if (!tree.is(Tree.Kind.CONSTRUCTOR)) {
            types.add(methodSymbol.returnType().type());
        }
        if (tree.block() != null && types.stream().noneMatch(Type::isUnknown)) {
            CFG cfg = CFG.build(tree);
            this.serializeUCFG(tree, cfg);
        }
    }

    @VisibleForTesting
    protected void serializeUCFG(MethodTree tree, CFG cfg) {
        try {
            UCFG uCFG = this.buildUCfg(tree, cfg);
            UCFGtoProtobuf.toProtobufFile((UCFG)uCFG, (String)this.ucfgFilePath());
        }
        catch (Exception e) {
            String msg = String.format("Cannot generate ucfg for file %s for method at line %d", this.javaFileKey, tree.firstToken().line());
            LOG.error(msg, (Throwable)e);
            throw new AnalysisException(msg, e);
        }
    }

    private String ucfgFilePath() {
        String absolutePath = new File(this.protobufDirectory, "ucfg_" + this.index + ".proto").getAbsolutePath();
        ++this.index;
        return absolutePath;
    }

    private UCFG buildUCfg(MethodTree methodTree, CFG cfg) {
        String signature = UCFGJavaVisitor.signatureFor(methodTree.symbol());
        IdentifierGenerator idGenerator = new IdentifierGenerator(methodTree);
        UCFGBuilder builder = UCFGBuilder.createUCFGForMethod((String)signature);
        methodTree.parameters().stream().map(p -> idGenerator.lookupIdFor(p.symbol())).map(UCFGBuilder::variableWithId).forEach(arg_0 -> ((UCFGBuilder)builder).addMethodParam(arg_0));
        UCFGBuilder.BlockBuilder entryBlockBuilder = this.buildBasicBlock(cfg.entry(), methodTree, idGenerator);
        if (UCFGJavaVisitor.hasAnnotatedParameters(methodTree)) {
            builder.addStartingBlock(this.buildParameterAnnotationsBlock(methodTree, idGenerator, cfg));
            builder.addBasicBlock(entryBlockBuilder);
        } else {
            builder.addStartingBlock(entryBlockBuilder);
        }
        cfg.blocks().stream().filter(b -> !b.equals(cfg.entry())).forEach(b -> builder.addBasicBlock(this.buildBasicBlock((CFG.Block)b, methodTree, idGenerator)));
        return builder.build();
    }

    private UCFGBuilder.BlockBuilder buildParameterAnnotationsBlock(MethodTree methodTree, IdentifierGenerator idGenerator, CFG cfg) {
        LocationInFile parametersLocation = this.location(methodTree.openParenToken(), methodTree.closeParenToken());
        UCFGBuilder.BlockBuilder blockBuilder = UCFGBuilder.newBasicBlock((String)"paramAnnotations", (LocationInFile)parametersLocation);
        List<AnnotationTree> methodAnnotations = methodTree.modifiers().annotations();
        UCFGJavaVisitor.getObjectParameters(methodTree).forEach(parameter -> this.buildBlockForParameter((VariableTree)parameter, methodAnnotations, blockBuilder, idGenerator));
        Label nextBlockLabel = UCFGBuilder.createLabel((String)Integer.toString(cfg.entry().id()));
        blockBuilder.jumpTo(new Label[]{nextBlockLabel});
        return blockBuilder;
    }

    private void buildBlockForParameter(VariableTree parameter, List<AnnotationTree> methodAnnotations, UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator) {
        Expression.Variable parameterVariable = UCFGBuilder.variableWithId((String)idGenerator.lookupIdFor(parameter.symbol()));
        ArrayList annotationVariables = new ArrayList();
        ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
        annotations.addAll(methodAnnotations);
        annotations.addAll(parameter.modifiers().annotations());
        if (annotations.isEmpty()) {
            return;
        }
        annotations.forEach(annotationTree -> {
            Expression.Variable var = UCFGBuilder.variableWithId((String)idGenerator.newId());
            annotationVariables.add(var);
            blockBuilder.assignTo(var, UCFGJavaVisitor.annotateCall(annotationTree, parameterVariable), this.location((Tree)annotationTree));
        });
        Expression[] args = annotationVariables.toArray(new Expression[annotationVariables.size()]);
        blockBuilder.assignTo(parameterVariable, UCFGBuilder.call((String)"__annotation").withArgs(args), this.location(parameter.simpleName()));
    }

    private static UCFGBuilder.CallBuilder annotateCall(AnnotationTree annotation, Expression.Variable annotatedVariable) {
        Expression.Constant fullyQualifiedName = UCFGBuilder.constant((String)annotation.symbolType().fullyQualifiedName());
        return UCFGBuilder.call((String)"__annotate").withArgs(new Expression[]{fullyQualifiedName, annotatedVariable});
    }

    private static boolean hasAnnotatedParameters(MethodTree methodTree) {
        List objectParameters = UCFGJavaVisitor.getObjectParameters(methodTree).collect(Collectors.toList());
        if (objectParameters.isEmpty()) {
            return false;
        }
        return !methodTree.modifiers().annotations().isEmpty() || objectParameters.stream().anyMatch(parameter -> !parameter.modifiers().annotations().isEmpty());
    }

    private static Stream<VariableTree> getObjectParameters(MethodTree methodTree) {
        return methodTree.parameters().stream().filter(parameter -> UCFGJavaVisitor.isObject(parameter.type().symbolType()));
    }

    private UCFGBuilder.BlockBuilder buildBasicBlock(CFG.Block javaBlock, MethodTree methodTree, IdentifierGenerator idGenerator) {
        UCFGBuilder.BlockBuilder blockBuilder = UCFGBuilder.newBasicBlock((String)String.valueOf(javaBlock.id()), (LocationInFile)this.location(javaBlock));
        javaBlock.elements().forEach(e -> this.buildCall((Tree)e, blockBuilder, idGenerator));
        Tree terminator = javaBlock.terminator();
        if (terminator != null && terminator.is(Tree.Kind.RETURN_STATEMENT)) {
            ExpressionTree returnedExpression = ((ReturnStatementTree)terminator).expression();
            Expression.Constant retExpr = UCFGBuilder.constant((String)"\"\"");
            if (methodTree.returnType() != null && UCFGJavaVisitor.isObject(methodTree.returnType().symbolType())) {
                retExpr = idGenerator.lookupExpressionFor(returnedExpression);
            }
            blockBuilder.ret((Expression)retExpr, this.location(terminator));
            return blockBuilder;
        }
        Set<CFG.Block> successors = javaBlock.successors();
        if (!successors.isEmpty()) {
            blockBuilder.jumpTo((Label[])successors.stream().map(b -> UCFGBuilder.createLabel((String)Integer.toString(b.id()))).toArray(Label[]::new));
            return blockBuilder;
        }
        Preconditions.checkState((javaBlock.id() == 0 ? 1 : 0) != 0);
        blockBuilder.ret((Expression)UCFGBuilder.constant((String)"implicit return"), this.location(methodTree.lastToken()));
        return blockBuilder;
    }

    private void buildCall(Tree element, UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator) {
        ArrayAccessExpressionTree arrayAccessExpressionTree;
        if (UCFGJavaVisitor.isObjectVarDeclaration(element)) {
            VariableTree variableTree = (VariableTree)element;
            String lhs = idGenerator.lookupIdFor(variableTree.simpleName());
            if (!idGenerator.isConst(lhs)) {
                Expression source = idGenerator.lookupExpressionFor(variableTree.initializer());
                blockBuilder.assignTo(UCFGBuilder.variableWithId((String)lhs), UCFGBuilder.call((String)"__id").withArgs(new Expression[]{source}), this.location(element));
            }
            return;
        }
        if (element.is(Tree.Kind.METHOD_INVOCATION)) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)element;
            this.buildMethodInvocation(blockBuilder, idGenerator, methodInvocationTree);
        } else if (element.is(Tree.Kind.NEW_CLASS)) {
            NewClassTree newClassTree = (NewClassTree)element;
            this.buildConstructorInvocation(blockBuilder, idGenerator, newClassTree);
        } else if (element.is(Tree.Kind.NEW_ARRAY)) {
            NewArrayTree newArrayTree = (NewArrayTree)element;
            this.buildNewArrayInvocation(blockBuilder, idGenerator, newArrayTree);
        } else if (element.is(Tree.Kind.PLUS)) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)element;
            this.buildConcatenationInvocation(blockBuilder, idGenerator, binaryExpressionTree);
        } else if (element.is(Tree.Kind.ASSIGNMENT)) {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)element;
            this.buildAssignmentInvocation(blockBuilder, idGenerator, assignmentExpressionTree);
        } else if (element.is(Tree.Kind.PLUS_ASSIGNMENT)) {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)element;
            this.buildPlusAssignmentInvocation(blockBuilder, idGenerator, assignmentExpressionTree);
        } else if (element.is(Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT) && !element.parent().is(Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.ASSIGNMENT)) {
            this.buildFieldReadAccessInvocation(blockBuilder, idGenerator, element);
        } else if (element.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION) && !element.parent().is(Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.ASSIGNMENT) && UCFGJavaVisitor.isObject((arrayAccessExpressionTree = (ArrayAccessExpressionTree)element).symbolType())) {
            Expression.Variable getValue = UCFGBuilder.variableWithId((String)idGenerator.newId());
            Expression array = idGenerator.lookupExpressionFor(arrayAccessExpressionTree.expression());
            blockBuilder.assignTo(getValue, UCFGJavaVisitor.arrayGet(array), this.location(element));
            idGenerator.varForExpression(element, getValue.id());
        }
    }

    private void buildNewArrayInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, NewArrayTree tree) {
        if (tree.type() != null && !UCFGJavaVisitor.isObject(tree.type().symbolType())) {
            return;
        }
        Expression.Variable newArray = UCFGBuilder.variableWithId((String)idGenerator.newIdFor(tree));
        blockBuilder.newObject(newArray, tree.symbolType().fullyQualifiedName(), this.location(tree));
        idGenerator.varForExpression(tree, newArray.id());
        tree.initializers().stream().filter(i -> UCFGJavaVisitor.isObject(i.symbolType())).forEach(i -> {
            Expression argument = idGenerator.lookupExpressionFor((Tree)i);
            blockBuilder.assignTo(UCFGBuilder.variableWithId((String)idGenerator.newId()), UCFGJavaVisitor.arraySet((Expression)newArray, argument), this.location(tree));
        });
    }

    private void buildConstructorInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, NewClassTree tree) {
        Symbol constructorSymbol = tree.constructorSymbol();
        if (!constructorSymbol.isMethodSymbol()) {
            return;
        }
        Expression.Variable newInstance = UCFGBuilder.variableWithId((String)idGenerator.newIdFor(tree));
        blockBuilder.newObject(newInstance, tree.symbolType().fullyQualifiedName(), this.location(tree.identifier()));
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(newInstance);
        arguments.addAll(UCFGJavaVisitor.argumentIds(idGenerator, tree.arguments()));
        blockBuilder.assignTo(UCFGBuilder.variableWithId((String)idGenerator.newId()), UCFGBuilder.call((String)UCFGJavaVisitor.signatureFor((Symbol.MethodSymbol)constructorSymbol)).withArgs(arguments.toArray(new Expression[0])), this.location(tree));
    }

    private void buildMethodInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, MethodInvocationTree tree) {
        if (tree.symbol().isUnknown()) {
            return;
        }
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        if (tree.symbol().isStatic()) {
            arguments.add((Expression)new Expression.ClassName(tree.symbol().type().fullyQualifiedName()));
        } else if (tree.methodSelect().is(Tree.Kind.MEMBER_SELECT)) {
            arguments.add(idGenerator.lookupExpressionFor(((MemberSelectExpressionTree)tree.methodSelect()).expression()));
        } else if (tree.methodSelect().is(Tree.Kind.IDENTIFIER)) {
            arguments.add(Expression.THIS);
        }
        arguments.addAll(UCFGJavaVisitor.argumentIds(idGenerator, tree.arguments()));
        this.buildAssignCall(blockBuilder, idGenerator, arguments, tree, (Symbol.MethodSymbol)tree.symbol());
    }

    private void buildConcatenationInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, BinaryExpressionTree tree) {
        if (!UCFGJavaVisitor.isObject(tree.symbolType())) {
            return;
        }
        Expression leftOperand = idGenerator.lookupExpressionFor(tree.leftOperand());
        Expression rightOperand = idGenerator.lookupExpressionFor(tree.rightOperand());
        Expression.Variable var = UCFGBuilder.variableWithId((String)idGenerator.newIdFor(tree));
        blockBuilder.assignTo(var, UCFGJavaVisitor.concat(leftOperand, rightOperand), this.location(tree));
    }

    private void buildAssignmentInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, AssignmentExpressionTree tree) {
        if (!UCFGJavaVisitor.isObject(tree.symbolType())) {
            return;
        }
        ExpressionTree lhsTree = tree.variable();
        ExpressionTree rhsTree = tree.expression();
        Expression rightSide = this.lookupExpression(blockBuilder, idGenerator, rhsTree);
        Optional<Expression.FieldAccess> leftFieldAccess = UCFGJavaVisitor.buildFieldAccess(idGenerator, lhsTree);
        if (leftFieldAccess.isPresent()) {
            blockBuilder.assignTo(leftFieldAccess.get(), UCFGBuilder.call((String)"__id").withArgs(new Expression[]{rightSide}), this.location(tree));
        } else if (lhsTree.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
            Expression leftSide = idGenerator.lookupExpressionFor(((ArrayAccessExpressionTree)lhsTree).expression());
            blockBuilder.assignTo(UCFGBuilder.variableWithId((String)idGenerator.newId()), UCFGJavaVisitor.arraySet(leftSide, rightSide), this.location(tree));
        } else {
            Expression leftSide = idGenerator.lookupExpressionFor(lhsTree);
            if (leftSide.isVariable()) {
                blockBuilder.assignTo((Expression.Variable)leftSide, UCFGBuilder.call((String)"__id").withArgs(new Expression[]{rightSide}), this.location(tree));
            }
        }
    }

    private void buildPlusAssignmentInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, AssignmentExpressionTree tree) {
        if (!UCFGJavaVisitor.isObject(tree.symbolType())) {
            return;
        }
        ExpressionTree lhsTree = tree.variable();
        ExpressionTree rhsTree = tree.expression();
        Expression leftSide = this.lookupExpression(blockBuilder, idGenerator, lhsTree);
        Expression rightSide = this.lookupExpression(blockBuilder, idGenerator, rhsTree);
        Optional<Expression.FieldAccess> leftFieldAccess = UCFGJavaVisitor.buildFieldAccess(idGenerator, lhsTree);
        if (leftFieldAccess.isPresent()) {
            Expression.Variable concatAux = UCFGBuilder.variableWithId((String)idGenerator.newId());
            blockBuilder.assignTo(concatAux, UCFGJavaVisitor.concat(leftSide, rightSide), this.location(tree));
            blockBuilder.assignTo(leftFieldAccess.get(), UCFGBuilder.call((String)"__id").withArgs(new Expression[]{concatAux}), this.location(tree));
        } else if (lhsTree.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
            Expression.Variable concatAux = UCFGBuilder.variableWithId((String)idGenerator.newId());
            blockBuilder.assignTo(concatAux, UCFGJavaVisitor.concat(leftSide, rightSide), this.location(tree));
            blockBuilder.assignTo(UCFGBuilder.variableWithId((String)idGenerator.newId()), UCFGJavaVisitor.arraySet(idGenerator.lookupExpressionFor(((ArrayAccessExpressionTree)lhsTree).expression()), (Expression)concatAux), this.location(tree));
        } else if (leftSide.isVariable()) {
            idGenerator.varForExpression(tree, ((Expression.Variable)leftSide).id());
            blockBuilder.assignTo((Expression.Variable)leftSide, UCFGJavaVisitor.concat(leftSide, rightSide), this.location(tree));
        }
    }

    private void buildAssignCall(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, List<Expression> arguments, Tree tree, Symbol.MethodSymbol symbol) {
        String destination = idGenerator.newIdFor(tree);
        blockBuilder.assignTo(UCFGBuilder.variableWithId((String)destination), UCFGBuilder.call((String)UCFGJavaVisitor.signatureFor(symbol)).withArgs(arguments.toArray(new Expression[0])), this.location(tree));
    }

    private void buildFieldReadAccessInvocation(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, Tree tree) {
        UCFGJavaVisitor.buildFieldAccess(idGenerator, tree).ifPresent(fieldAccess -> {
            Expression.Variable aux = UCFGBuilder.variableWithId((String)idGenerator.newId());
            blockBuilder.assignTo(aux, UCFGBuilder.call((String)"__id").withArgs(new Expression[]{fieldAccess}), this.location(tree));
            idGenerator.varForExpression(tree, aux.id());
        });
    }

    private static Optional<Expression.FieldAccess> buildFieldAccess(IdentifierGenerator identifierGenerator, Tree tree) {
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            return UCFGJavaVisitor.buildFieldAccess((IdentifierTree)tree);
        }
        if (tree.is(Tree.Kind.MEMBER_SELECT)) {
            return UCFGJavaVisitor.buildFieldAccess(identifierGenerator, (MemberSelectExpressionTree)tree);
        }
        return Optional.empty();
    }

    private static Optional<Expression.FieldAccess> buildFieldAccess(IdentifierGenerator idGenerator, MemberSelectExpressionTree memberSelectTree) {
        ExpressionTree lhsTree = memberSelectTree.expression();
        Symbol rhsTreeSymbol = memberSelectTree.identifier().symbol();
        if (!rhsTreeSymbol.isVariableSymbol()) {
            return Optional.empty();
        }
        Expression.Variable rightSide = UCFGBuilder.variableWithId((String)rhsTreeSymbol.name());
        if (!rhsTreeSymbol.isStatic()) {
            Expression leftSide = idGenerator.lookupExpressionFor(lhsTree);
            if (leftSide.equals(Expression.THIS)) {
                return Optional.of(new Expression.FieldAccess(rightSide));
            }
            if (leftSide.isVariable()) {
                return Optional.of(new Expression.FieldAccess((Expression.Variable)leftSide, rightSide));
            }
        }
        if (lhsTree.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree lhsIdentifierTree = (IdentifierTree)lhsTree;
            return Optional.of(new Expression.FieldAccess(new Expression.ClassName(lhsIdentifierTree.symbol().type().fullyQualifiedName()), rightSide));
        }
        return Optional.empty();
    }

    private static Optional<Expression.FieldAccess> buildFieldAccess(IdentifierTree identifierTree) {
        Symbol identifierTreeSymbol = identifierTree.symbol();
        if (!identifierTreeSymbol.isVariableSymbol() || identifierTreeSymbol.owner().isMethodSymbol() || identifierTree.name().equals("this") || identifierTree.name().equals("super")) {
            return Optional.empty();
        }
        Expression.Variable rightSide = UCFGBuilder.variableWithId((String)identifierTree.name());
        if (identifierTreeSymbol.isStatic()) {
            return Optional.of(new Expression.FieldAccess(new Expression.ClassName(identifierTreeSymbol.owner().type().fullyQualifiedName()), rightSide));
        }
        return Optional.of(new Expression.FieldAccess(rightSide));
    }

    private static List<Expression> argumentIds(IdentifierGenerator idGenerator, Arguments arguments) {
        return arguments.stream().map(idGenerator::lookupExpressionFor).collect(Collectors.toList());
    }

    private Expression lookupExpression(UCFGBuilder.BlockBuilder blockBuilder, IdentifierGenerator idGenerator, ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
            Expression array = idGenerator.lookupExpressionFor(((ArrayAccessExpressionTree)expressionTree).expression());
            Expression.Variable aux = UCFGBuilder.variableWithId((String)idGenerator.newId());
            blockBuilder.assignTo(aux, UCFGJavaVisitor.arrayGet(array), this.location(expressionTree));
            return aux;
        }
        this.buildFieldReadAccessInvocation(blockBuilder, idGenerator, expressionTree);
        return idGenerator.lookupExpressionFor(expressionTree);
    }

    private static UCFGBuilder.CallBuilder arrayGet(Expression array) {
        return UCFGBuilder.call((String)"__arrayGet").withArgs(new Expression[]{array});
    }

    private static UCFGBuilder.CallBuilder arraySet(Expression targetArray, Expression value) {
        return UCFGBuilder.call((String)"__arraySet").withArgs(new Expression[]{targetArray, value});
    }

    private static UCFGBuilder.CallBuilder concat(Expression ... args) {
        return UCFGBuilder.call((String)"__concat").withArgs(args);
    }

    private static String signatureFor(Symbol.MethodSymbol methodSymbol) {
        return ((JavaSymbol.MethodJavaSymbol)methodSymbol).completeSignature();
    }

    @Nullable
    private LocationInFile location(CFG.Block javaBlock) {
        Tree firstTree = null;
        List<Tree> elements = javaBlock.elements();
        if (!elements.isEmpty()) {
            firstTree = elements.get(0);
        } else if (javaBlock.terminator() != null) {
            firstTree = javaBlock.terminator();
        }
        if (firstTree == null) {
            return null;
        }
        return this.location(firstTree);
    }

    private LocationInFile location(Tree tree) {
        return this.location(tree.firstToken(), tree.lastToken());
    }

    private LocationInFile location(SyntaxToken firstToken, SyntaxToken lastToken) {
        return new LocationInFile(this.javaFileKey, firstToken.line(), firstToken.column(), lastToken.line(), lastToken.column() + lastToken.text().length());
    }

    private static boolean isObjectVarDeclaration(Tree tree) {
        if (!tree.is(Tree.Kind.VARIABLE)) {
            return false;
        }
        VariableTree var = (VariableTree)tree;
        return UCFGJavaVisitor.isObject(var.type().symbolType());
    }

    private static boolean isObject(Type type) {
        if (type.isArray()) {
            return UCFGJavaVisitor.isObject(((Type.ArrayType)type).elementType());
        }
        return !type.isPrimitive() && !type.isUnknown();
    }

    public static class IdentifierGenerator {
        private static final String CONST = "\"\"";
        private final Map<Symbol, String> objectVars;
        private final Map<Tree, String> temps;
        private int counter;

        public IdentifierGenerator(MethodTree methodTree) {
            Set objectParameters = methodTree.parameters().stream().filter(p -> UCFGJavaVisitor.isObject(p.symbol().type())).map(VariableTree::symbol).collect(Collectors.toSet());
            VariableReadExtractor variableReadExtractor = new VariableReadExtractor(methodTree.symbol(), false);
            methodTree.accept(variableReadExtractor);
            Set objectLocals = variableReadExtractor.usedVariables().stream().filter(s -> UCFGJavaVisitor.isObject(s.type())).collect(Collectors.toSet());
            this.objectVars = Sets.union(objectParameters, objectLocals).stream().collect(Collectors.toMap(s -> s, Symbol::name));
            this.temps = new HashMap<Tree, String>();
            this.counter = 0;
        }

        public boolean isConst(String id) {
            return CONST.equals(id);
        }

        public String newIdFor(@Nullable Tree tree) {
            return this.temps.computeIfAbsent(tree, t -> this.newId());
        }

        private String newId() {
            String result = "%" + this.counter;
            ++this.counter;
            return result;
        }

        public Expression lookupExpressionFor(@Nullable Tree tree) {
            String id = this.lookupIdFor(tree);
            if (this.isConst(id)) {
                if (tree != null) {
                    if (tree.is(Tree.Kind.STRING_LITERAL)) {
                        return UCFGBuilder.constant((String)LiteralUtils.trimQuotes(((LiteralTree)tree).value()));
                    }
                    if (tree.is(Tree.Kind.IDENTIFIER) && ((IdentifierTree)tree).name().equals("this")) {
                        return Expression.THIS;
                    }
                }
                return UCFGBuilder.constant((String)id);
            }
            return UCFGBuilder.variableWithId((String)id);
        }

        public String lookupIdFor(@Nullable Tree tree) {
            if (tree == null) {
                return CONST;
            }
            Tree noParentheses = IdentifierGenerator.skipParentheses(tree);
            if (noParentheses.is(Tree.Kind.IDENTIFIER) && !this.temps.containsKey(noParentheses)) {
                return this.lookupIdFor(((IdentifierTree)noParentheses).symbol());
            }
            return this.temps.getOrDefault(noParentheses, CONST);
        }

        public String lookupIdFor(Symbol symbol) {
            return this.objectVars.getOrDefault(symbol, CONST);
        }

        public void varForExpression(Tree element, String id) {
            this.temps.put(element, id);
        }

        private static Tree skipParentheses(Tree tree) {
            if (tree.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
                return ExpressionUtils.skipParentheses((ParenthesizedTree)tree);
            }
            return tree;
        }
    }
}

