/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.cfg.CFG;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class FileLinesVisitor
extends SubscriptionVisitor {
    private final SonarComponents sonarComponents;
    private final Set<Integer> linesOfCode = new HashSet<Integer>();
    private final Set<Integer> executableLines = new HashSet<Integer>();

    public FileLinesVisitor(SonarComponents sonarComponents) {
        this.sonarComponents = sonarComponents;
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)((Object)Tree.Kind.TOKEN), (Object)((Object)Tree.Kind.METHOD), (Object)((Object)Tree.Kind.CONSTRUCTOR), (Object)((Object)Tree.Kind.INITIALIZER), (Object)((Object)Tree.Kind.STATIC_INITIALIZER), (Object)((Object)Tree.Kind.VARIABLE), (Object)((Object)Tree.Kind.FOR_EACH_STATEMENT), (Object)((Object)Tree.Kind.FOR_STATEMENT), (Object)((Object)Tree.Kind.WHILE_STATEMENT), (Object)((Object)Tree.Kind.DO_STATEMENT), (Object)((Object)Tree.Kind.LAMBDA_EXPRESSION));
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        File currentFile = context.getFile();
        FileLinesContext fileLinesContext = this.sonarComponents.fileLinesContextFor(currentFile);
        int fileLength = this.sonarComponents.fileLength(currentFile);
        for (int line = 1; line <= fileLength; ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, this.linesOfCode.contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("executable_lines_data", line, this.executableLines.contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
        this.linesOfCode.clear();
        this.executableLines.clear();
    }

    @Override
    public void visitNode(Tree tree) {
        List<Object> trees = Collections.emptyList();
        switch (tree.kind()) {
            case INITIALIZER: 
            case STATIC_INITIALIZER: {
                trees = ((BlockTree)tree).body();
                break;
            }
            case VARIABLE: {
                trees = this.visitVariable((VariableTree)tree);
                break;
            }
            case LAMBDA_EXPRESSION: {
                trees = FileLinesVisitor.visitLambda((LambdaExpressionTree)tree);
                break;
            }
            case METHOD: 
            case CONSTRUCTOR: {
                trees = this.visitMethod((MethodTree)tree);
                break;
            }
            case FOR_STATEMENT: 
            case FOR_EACH_STATEMENT: 
            case WHILE_STATEMENT: 
            case DO_STATEMENT: {
                this.executableLines.add(tree.lastToken().line());
                break;
            }
        }
        this.computeExecutableLines(trees);
    }

    private List<? extends Tree> visitVariable(VariableTree variableTree) {
        ExpressionTree initializer = variableTree.initializer();
        if (initializer != null && !FileLinesVisitor.isConstant(variableTree)) {
            return Lists.newArrayList((Object[])new ExpressionTree[]{initializer});
        }
        if (variableTree.parent().is(Tree.Kind.CATCH)) {
            new ExecutableLinesTokenVisitor().scanTree(variableTree);
        }
        return Collections.emptyList();
    }

    private static List<? extends Tree> visitLambda(LambdaExpressionTree lambda) {
        Tree body = lambda.body();
        if (body.is(Tree.Kind.BLOCK)) {
            return ((BlockTree)body).body();
        }
        return Lists.newArrayList((Object[])new Tree[]{body});
    }

    private List<? extends Tree> visitMethod(MethodTree tree) {
        BlockTree methodBody = tree.block();
        if (methodBody != null) {
            TypeTree returnType = tree.returnType();
            if (returnType == null || "void".equals(returnType.firstToken().text())) {
                this.executableLines.add(methodBody.closeBraceToken().line());
            }
            return methodBody.body();
        }
        return Collections.emptyList();
    }

    private void computeExecutableLines(List<? extends Tree> trees) {
        if (trees.isEmpty()) {
            return;
        }
        CFG cfg = CFG.buildCFG(trees);
        cfg.blocks().stream().flatMap(b -> b.elements().stream()).forEach(t -> {
            if (t.is(Tree.Kind.NEW_CLASS)) {
                NewClassTree newClassTree = (NewClassTree)t;
                new ExecutableLinesTokenVisitor().scanTree(newClassTree.identifier());
                this.executableLines.add(newClassTree.newKeyword().line());
            } else if (t.is(Tree.Kind.TRY_STATEMENT)) {
                this.executableLines.add(t.lastToken().line());
            } else {
                this.executableLines.add(t.firstToken().line());
            }
        });
    }

    @Override
    public void visitToken(SyntaxToken syntaxToken) {
        this.linesOfCode.add(syntaxToken.line());
    }

    private static boolean isConstant(VariableTree variableTree) {
        return ModifiersUtils.hasModifier(variableTree.modifiers(), Modifier.STATIC) && ModifiersUtils.hasModifier(variableTree.modifiers(), Modifier.FINAL) && variableTree.initializer().is(Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.NULL_LITERAL);
    }

    private class ExecutableLinesTokenVisitor
    extends SubscriptionVisitor {
        private ExecutableLinesTokenVisitor() {
        }

        @Override
        public List<Tree.Kind> nodesToVisit() {
            return ImmutableList.of((Object)((Object)Tree.Kind.TOKEN));
        }

        @Override
        public void visitToken(SyntaxToken syntaxToken) {
            FileLinesVisitor.this.executableLines.add(syntaxToken.line());
        }
    }
}

