/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.se;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.bytecode.cfg.BytecodeCFG;
import org.sonar.java.bytecode.cfg.BytecodeCFGMethodVisitor;
import org.sonar.java.bytecode.cfg.Instruction;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.bytecode.se.BytecodeSECheck;
import org.sonar.java.bytecode.se.CheckerDispatcher;
import org.sonar.java.bytecode.se.MethodLookup;
import org.sonar.java.cfg.CFG;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.UnknownType;
import org.sonar.java.se.ExceptionUtils;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ExplodedGraphWalker;
import org.sonar.java.se.Pair;
import org.sonar.java.se.ProgramPoint;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.DivisionByZeroCheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.constraint.TypedConstraint;
import org.sonar.java.se.symbolicvalues.RelationalSymbolicValue;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.java.se.xproc.MethodBehavior;

public class BytecodeEGWalker {
    private static final Logger LOG = Loggers.get(BytecodeEGWalker.class);
    private static final int MAX_EXEC_PROGRAM_POINT = 2;
    private static final int MAX_STEPS = 16000;
    private final BehaviorCache behaviorCache;
    private final SemanticModel semanticModel;
    @VisibleForTesting
    ExplodedGraph explodedGraph;
    private BytecodeCFG.Block exitBlock;
    @VisibleForTesting
    Deque<ExplodedGraph.Node> workList;
    ExplodedGraph.Node node;
    ProgramPoint programPosition;
    ProgramState programState;
    int steps;
    private Set<ExplodedGraph.Node> endOfExecutionPath;
    private ConstraintManager constraintManager;
    MethodBehavior methodBehavior;
    private CheckerDispatcher checkerDispatcher;

    public BytecodeEGWalker(BehaviorCache behaviorCache, SemanticModel semanticModel) {
        this.behaviorCache = behaviorCache;
        this.semanticModel = semanticModel;
        this.checkerDispatcher = new CheckerDispatcher(this, Lists.newArrayList((Object[])new BytecodeSECheck[]{new BytecodeSECheck.NullnessCheck(), new BytecodeSECheck.ZeronessCheck()}));
        this.constraintManager = new ConstraintManager();
        this.explodedGraph = new ExplodedGraph();
        this.workList = new LinkedList<ExplodedGraph.Node>();
        this.endOfExecutionPath = new LinkedHashSet<ExplodedGraph.Node>();
    }

    @CheckForNull
    public MethodBehavior getMethodBehavior(String signature, SquidClassLoader classLoader) {
        if (BytecodeEGWalker.methodFromArray(signature)) {
            return null;
        }
        this.methodBehavior = this.behaviorCache.methodBehaviorForSymbol(signature);
        if (!this.methodBehavior.isVisited()) {
            try {
                this.methodBehavior.visited();
                this.execute(signature, classLoader);
            }
            catch (BytecodeAnalysisException | ExplodedGraphWalker.MaximumStepsReachedException | RelationalSymbolicValue.TransitiveRelationExceededException e) {
                LOG.debug("Dataflow analysis is incomplete for method {} : {}", (Object)signature, (Object)e.getMessage());
            }
            catch (Exception e) {
                throw new BytecodeAnalysisException("Failed dataflow analysis for " + signature, e);
            }
        }
        return this.methodBehavior;
    }

    private static boolean methodFromArray(String signature) {
        return signature.substring(0, signature.indexOf(35)).endsWith("[]");
    }

    @VisibleForTesting
    int maxSteps() {
        return 16000;
    }

    private void execute(String signature, SquidClassLoader classLoader) {
        BytecodeCFGMethodVisitor cfgVisitor = new BytecodeCFGMethodVisitor();
        MethodLookup lookup = MethodLookup.lookup(signature, classLoader, cfgVisitor);
        if (lookup == null) {
            LOG.debug("Method body not found: %s", (Object)signature);
            return;
        }
        this.methodBehavior.setDeclaredExceptions(lookup.declaredExceptions);
        this.methodBehavior.setVarArgs(lookup.isVarArgs);
        BytecodeCFG bytecodeCFG = cfgVisitor.getCfg();
        if (bytecodeCFG == null) {
            return;
        }
        this.exitBlock = bytecodeCFG.exitBlock();
        this.steps = 0;
        for (ProgramState startingState : this.startingStates(signature, ProgramState.EMPTY_STATE, lookup.isStatic)) {
            this.enqueue(new ProgramPoint(bytecodeCFG.entry()), startingState);
        }
        while (!this.workList.isEmpty()) {
            ++this.steps;
            if (this.steps > this.maxSteps()) {
                throw new ExplodedGraphWalker.MaximumStepsReachedException("Too many steps resolving " + this.methodBehavior.signature());
            }
            this.setNode(this.workList.removeFirst());
            if (this.programPosition.block.successors().isEmpty()) {
                this.endOfExecutionPath.add(this.node);
                continue;
            }
            if (this.programPosition.i < this.programPosition.block.elements().size()) {
                this.executeInstruction((Instruction)this.programPosition.block.elements().get(this.programPosition.i));
                continue;
            }
            this.handleBlockExit(this.programPosition);
        }
        this.handleEndOfExecutionPath();
        this.executeCheckEndOfExecution();
        this.methodBehavior.completed();
        this.workList = null;
        this.node = null;
        this.programState = null;
        this.constraintManager = null;
    }

    @VisibleForTesting
    void executeInstruction(Instruction instruction) {
        if (!this.checkerDispatcher.executeCheckPreStatement(instruction)) {
            return;
        }
        switch (instruction.opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.programState = this.programState.stackValue(SymbolicValue.NULL_LITERAL);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = this.setDoubleOrLong(sv, instruction.isLongOrDoubleValue());
                this.programState = this.programState.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL);
                if (instruction.opcode == 4 || instruction.opcode == 10 || instruction.opcode == 12 || instruction.opcode == 15) {
                    this.programState = this.programState.addConstraint(sv, BooleanConstraint.TRUE);
                }
                if (instruction.opcode == 3 || instruction.opcode == 9 || instruction.opcode == 11 || instruction.opcode == 14) {
                    this.programState = this.programState.addConstraint(sv, BooleanConstraint.FALSE).addConstraint(sv, DivisionByZeroCheck.ZeroConstraint.ZERO);
                    break;
                }
                this.programState = this.programState.addConstraint(sv, DivisionByZeroCheck.ZeroConstraint.NON_ZERO);
                break;
            }
            case 16: 
            case 17: {
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = this.programState.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL).addConstraint(sv, DivisionByZeroCheck.ZeroConstraint.NON_ZERO);
                if (instruction.operand == 0) {
                    this.programState = this.programState.addConstraint(sv, BooleanConstraint.FALSE).addConstraint(sv, DivisionByZeroCheck.ZeroConstraint.ZERO);
                    break;
                }
                if (instruction.operand != 1) break;
                this.programState = this.programState.addConstraint(sv, BooleanConstraint.TRUE);
                break;
            }
            case 18: {
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = this.programState.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL);
                this.programState = this.setDoubleOrLong(sv, instruction.isLongOrDoubleValue());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                SymbolicValue value = this.programState.getValue(instruction.operand);
                Preconditions.checkNotNull((Object)value, (Object)"Loading a symbolic value unindexed");
                this.programState = this.programState.stackValue(value);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = this.programState.unstackValue((int)2).state.stackValue(sv);
                if (instruction.opcode != 50) {
                    this.programState = this.programState.addConstraint(sv, ObjectConstraint.NOT_NULL);
                }
                this.programState = this.setDoubleOrLong(sv, instruction.isLongOrDoubleValue());
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                this.programState = pop.state.put(instruction.operand, pop.values.get(0));
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.programState = this.programState.unstackValue((int)3).state;
                break;
            }
            case 87: {
                this.programState = this.programState.unstackValue((int)1).state;
                break;
            }
            case 88: {
                SymbolicValue sv = this.programState.peekValue();
                Preconditions.checkNotNull((Object)sv, (Object)"POP2 on empty stack");
                ProgramState.Pop pop = this.isDoubleOrLong(sv) ? this.popStack(1, instruction.opcode) : this.popStack(2, instruction.opcode);
                this.programState = pop.state;
                break;
            }
            case 89: {
                SymbolicValue sv = this.programState.peekValue();
                Preconditions.checkNotNull((Object)sv, (Object)"DUP on empty stack");
                this.programState = this.programState.stackValue(sv);
                break;
            }
            case 90: {
                ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                this.programState = BytecodeEGWalker.stackValues(pop, 0, 1, 0);
                break;
            }
            case 91: {
                SymbolicValue sv = this.programState.peekValue(1);
                if (this.isDoubleOrLong(sv)) {
                    ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                    this.programState = BytecodeEGWalker.stackValues(pop, 0, 1, 0);
                    break;
                }
                ProgramState.Pop pop = this.popStack(3, instruction.opcode);
                this.programState = BytecodeEGWalker.stackValues(pop, 0, 2, 1, 0);
                break;
            }
            case 92: {
                SymbolicValue sv = this.programState.peekValue();
                Preconditions.checkNotNull((Object)sv, (Object)"DUP2 needs at least 1 value on stack");
                if (this.isDoubleOrLong(sv)) {
                    ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                    this.programState = BytecodeEGWalker.stackValues(pop, 0, 0);
                    break;
                }
                ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                this.programState = BytecodeEGWalker.stackValues(pop, 1, 0, 1, 0);
                break;
            }
            case 93: {
                SymbolicValue sv = this.programState.peekValue();
                Preconditions.checkNotNull((Object)sv, (Object)"DUP2_X1 needs at least 1 value on stack");
                if (this.isDoubleOrLong(sv)) {
                    ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                    this.programState = BytecodeEGWalker.stackValues(pop, 0, 1, 0);
                    break;
                }
                ProgramState.Pop pop = this.popStack(3, instruction.opcode);
                this.programState = BytecodeEGWalker.stackValues(pop, 1, 0, 2, 1, 0);
                break;
            }
            case 94: {
                if (this.isDoubleOrLong(this.programState.peekValue()) && this.isDoubleOrLong(this.programState.peekValue(1))) {
                    ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                    this.programState = BytecodeEGWalker.stackValues(pop, 0, 1, 0);
                    break;
                }
                if (this.isDoubleOrLong(this.programState.peekValue(2))) {
                    ProgramState.Pop pop = this.popStack(3, instruction.opcode);
                    this.programState = BytecodeEGWalker.stackValues(pop, 1, 0, 2, 1, 0);
                    break;
                }
                if (this.isDoubleOrLong(this.programState.peekValue())) {
                    ProgramState.Pop pop = this.popStack(3, instruction.opcode);
                    this.programState = BytecodeEGWalker.stackValues(pop, 0, 2, 1, 0);
                    break;
                }
                ProgramState.Pop pop = this.popStack(4, instruction.opcode);
                this.programState = BytecodeEGWalker.stackValues(pop, 1, 0, 3, 2, 1, 0);
                break;
            }
            case 95: {
                ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                this.programState = pop.state.stackValue(pop.values.get(0)).stackValue(pop.values.get(1));
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = pop.state.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL);
                this.programState = this.setDoubleOrLong(sv, instruction.isLongOrDoubleValue());
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = pop.state.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL);
                this.programState = this.setDoubleOrLong(sv, instruction.isLongOrDoubleValue());
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                SymbolicValue sv = this.constraintManager.createBinarySymbolicValue(instruction, pop.valuesAndSymbols);
                this.programState = pop.state.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL);
                this.programState = this.setDoubleOrLong(sv, instruction.isLongOrDoubleValue());
                break;
            }
            case 132: {
                int index = instruction.operand;
                SymbolicValue existing = this.programState.getValue(index);
                Preconditions.checkNotNull((Object)existing, (Object)("Local variable " + index + " not found"));
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = this.programState.put(index, sv).addConstraint(sv, ObjectConstraint.NOT_NULL);
                break;
            }
            case 133: 
            case 135: 
            case 140: 
            case 141: {
                SymbolicValue sv = this.programState.peekValue();
                Preconditions.checkNotNull((Object)sv, (String)"%s needs value on stack", (Object[])new Object[]{instruction});
                this.programState = this.setDoubleOrLong(sv, true);
                break;
            }
            case 136: 
            case 137: 
            case 142: 
            case 144: {
                SymbolicValue sv = this.programState.peekValue();
                Preconditions.checkNotNull((Object)sv, (String)"%s needs value on stack", (Object[])new Object[]{instruction});
                this.programState = this.setDoubleOrLong(sv, false);
                break;
            }
            case 134: 
            case 138: 
            case 139: 
            case 143: 
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = pop.state.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL);
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                this.programState.storeExitValue();
                this.programState = this.programState.unstackValue((int)1).state;
                break;
            }
            case 177: {
                break;
            }
            case 178: {
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = this.programState.stackValue(sv);
                this.programState = this.setDoubleOrLong(sv, instruction.isLongOrDoubleValue());
                break;
            }
            case 179: {
                ProgramState.Pop pop = this.programState.unstackValue(1);
                this.programState = pop.state;
                break;
            }
            case 180: {
                ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = pop.state.stackValue(sv);
                this.programState = this.setDoubleOrLong(sv, instruction.isLongOrDoubleValue());
                break;
            }
            case 181: {
                ProgramState.Pop pop = this.popStack(2, instruction.opcode);
                this.programState = pop.state;
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                if (!this.handleMethodInvocation(instruction)) break;
                return;
            }
            case 186: {
                ProgramState.Pop pop = this.popStack(instruction.arity(), instruction.opcode);
                Preconditions.checkState((boolean)instruction.hasReturnValue(), (Object)"Lambda should always evaluate to target functional interface");
                SymbolicValue lambdaTargetInterface = new SymbolicValue();
                this.programState = pop.state.stackValue(lambdaTargetInterface).addConstraint(lambdaTargetInterface, ObjectConstraint.NOT_NULL);
                break;
            }
            case 187: {
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = this.programState.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL).addConstraint(sv, new TypedConstraint(instruction.className));
                break;
            }
            case 190: {
                ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = pop.state.stackValue(sv);
                break;
            }
            case 188: 
            case 189: {
                ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                SymbolicValue sv = this.constraintManager.createSymbolicValue(instruction);
                this.programState = pop.state.stackValue(sv).addConstraint(sv, ObjectConstraint.NOT_NULL);
                break;
            }
            case 191: {
                if (!(this.programState.peekValue() instanceof SymbolicValue.ExceptionalSymbolicValue)) {
                    ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                    SymbolicValue sv = pop.values.get(0);
                    TypedConstraint typedConstraint = this.programState.getConstraint(sv, TypedConstraint.class);
                    UnknownType type = typedConstraint != null ? typedConstraint.getType(this.semanticModel) : Symbols.unknownType;
                    this.programState = pop.state.stackValue(this.constraintManager.createExceptionalSymbolicValue(type));
                }
                this.programState.storeExitValue();
                break;
            }
            case 192: {
                Preconditions.checkState((this.programState.peekValue() != null ? 1 : 0) != 0, (Object)"CHECKCAST needs 1 value on stack");
                break;
            }
            case 193: {
                ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                SymbolicValue.InstanceOfSymbolicValue instanceOf = new SymbolicValue.InstanceOfSymbolicValue();
                instanceOf.computedFrom(pop.valuesAndSymbols);
                this.programState = pop.state.stackValue(instanceOf);
                break;
            }
            case 194: 
            case 195: {
                ProgramState.Pop pop = this.popStack(1, instruction.opcode);
                this.programState = pop.state;
                break;
            }
            case 197: {
                Instruction.MultiANewArrayInsn multiANewArrayInsn = (Instruction.MultiANewArrayInsn)instruction;
                ProgramState.Pop pop = this.popStack(multiANewArrayInsn.dim, instruction.opcode);
                SymbolicValue arrayRef = new SymbolicValue();
                this.programState = pop.state.stackValue(arrayRef).addConstraint(arrayRef, ObjectConstraint.NOT_NULL);
                break;
            }
            default: {
                throw new IllegalStateException("Instruction not handled. " + instruction);
            }
        }
        this.checkerDispatcher.executeCheckPostStatement(instruction);
    }

    private static ProgramState stackValues(ProgramState.Pop pop, int ... values) {
        ProgramState ps = pop.state;
        for (int value : values) {
            ps = ps.stackValue(pop.values.get(value));
        }
        return ps;
    }

    private ProgramState setDoubleOrLong(SymbolicValue sv, boolean value) {
        return BytecodeEGWalker.setDoubleOrLong(this.programState, sv, value);
    }

    private static ProgramState setDoubleOrLong(ProgramState programState, SymbolicValue sv, boolean value) {
        if (value) {
            return programState.addConstraint(sv, StackValueCategoryConstraint.LONG_OR_DOUBLE);
        }
        return programState.removeConstraintsOnDomain(sv, StackValueCategoryConstraint.class);
    }

    private boolean isDoubleOrLong(SymbolicValue sv) {
        return this.programState.getConstraint(sv, StackValueCategoryConstraint.class) == StackValueCategoryConstraint.LONG_OR_DOUBLE;
    }

    private ProgramState.Pop popStack(int nbOfValues, int opcode) {
        ProgramState.Pop pop = this.programState.unstackValue(nbOfValues);
        Preconditions.checkState((pop.values.size() == nbOfValues ? 1 : 0) != 0, (String)"%s needs %s values on stack", (Object[])new Object[]{Printer.OPCODES[opcode], nbOfValues});
        return pop;
    }

    private boolean handleMethodInvocation(Instruction instruction) {
        boolean isStatic = instruction.opcode == 184;
        int arity = isStatic ? instruction.arity() : instruction.arity() + 1;
        ProgramState.Pop pop = this.programState.unstackValue(arity);
        Preconditions.checkState((pop.values.size() == arity ? 1 : 0) != 0, (Object)"Arguments mismatch for INVOKE");
        this.programState = pop.state;
        SymbolicValue returnSV = instruction.hasReturnValue() ? this.constraintManager.createSymbolicValue(instruction) : null;
        String signature = instruction.fieldOrMethod.completeSignature();
        MethodBehavior methodInvokedBehavior = this.behaviorCache.get(signature);
        this.enqueueUncheckedExceptions();
        if (methodInvokedBehavior != null && methodInvokedBehavior.isComplete() && !methodInvokedBehavior.yields().isEmpty()) {
            List stack = Lists.reverse(pop.values);
            if (!isStatic) {
                stack = stack.subList(1, stack.size());
            }
            List arguments = stack;
            methodInvokedBehavior.happyPathYields().forEach(yield -> yield.statesAfterInvocation(arguments, Collections.emptyList(), this.programState, () -> returnSV).forEach(ps -> {
                this.checkerDispatcher.methodYield = yield;
                if (ps.peekValue() != null) {
                    ps = BytecodeEGWalker.setDoubleOrLong(ps, ps.peekValue(), instruction.isLongOrDoubleValue());
                }
                this.checkerDispatcher.addTransition((ProgramState)ps);
                this.checkerDispatcher.methodYield = null;
            }));
            methodInvokedBehavior.exceptionalPathYields().forEach(yield -> {
                org.sonar.plugins.java.api.semantic.Type exceptionType = yield.exceptionType(this.semanticModel);
                yield.statesAfterInvocation(arguments, Collections.emptyList(), this.programState, () -> this.constraintManager.createExceptionalSymbolicValue(exceptionType)).forEach(ps -> {
                    ps.storeExitValue();
                    this.enqueueExceptionHandlers(exceptionType, (ProgramState)ps);
                });
            });
            return true;
        }
        if (methodInvokedBehavior != null) {
            methodInvokedBehavior.getDeclaredExceptions().forEach(exception -> {
                org.sonar.plugins.java.api.semantic.Type exceptionType = this.semanticModel.getClassType((String)exception);
                ProgramState ps = this.programState.stackValue(this.constraintManager.createExceptionalSymbolicValue(exceptionType));
                this.enqueueExceptionHandlers(exceptionType, ps);
            });
        }
        if (instruction.hasReturnValue()) {
            this.programState = this.programState.stackValue(returnSV);
            this.programState = this.setDoubleOrLong(returnSV, instruction.isLongOrDoubleValue());
        }
        return false;
    }

    private void enqueueUncheckedExceptions() {
        this.programPosition.block.successors().stream().map(BytecodeCFG.Block.class::cast).filter(this::isUncheckedExceptionCatchBlock).forEach(b -> this.enqueue(new ProgramPoint((CFG.IBlock<?>)b), this.stateWithException(this.programState, (BytecodeCFG.Block)b)));
    }

    private boolean isUncheckedExceptionCatchBlock(BytecodeCFG.Block b) {
        return b.isCatchBlock() && ExceptionUtils.isUncheckedException(b.getExceptionType(this.semanticModel));
    }

    private ProgramState stateWithException(ProgramState programState, BytecodeCFG.Block b) {
        org.sonar.plugins.java.api.semantic.Type exceptionType = b.getExceptionType(this.semanticModel);
        SymbolicValue.ExceptionalSymbolicValue sv = new SymbolicValue.ExceptionalSymbolicValue(exceptionType);
        return programState.stackValue(sv);
    }

    private void enqueueExceptionHandlers(org.sonar.plugins.java.api.semantic.Type exceptionType, ProgramState ps) {
        List<BytecodeCFG.Block> blocksCatchingException = this.programPosition.block.successors().stream().map(b -> (BytecodeCFG.Block)b).filter(BytecodeCFG.Block::isCatchBlock).filter(b -> this.isExceptionHandledByBlock(exceptionType, (BytecodeCFG.Block)b)).collect(Collectors.toList());
        if (!blocksCatchingException.isEmpty()) {
            blocksCatchingException.forEach(b -> this.enqueue(new ProgramPoint((CFG.IBlock<?>)b), ps));
            if (this.isCatchExhaustive(exceptionType, blocksCatchingException)) {
                return;
            }
        }
        Preconditions.checkState((boolean)(ps.peekValue() instanceof SymbolicValue.ExceptionalSymbolicValue), (Object)"Exception shall be on top of the stack");
        ps.storeExitValue();
        this.enqueue(new ProgramPoint(this.exitBlock), ps);
    }

    private boolean isCatchExhaustive(org.sonar.plugins.java.api.semantic.Type exceptionType, List<BytecodeCFG.Block> blocksCatchingException) {
        return blocksCatchingException.stream().filter(BytecodeCFG.Block::isCatchBlock).anyMatch(b -> b.isUncaughtException() || exceptionType.isSubtypeOf(b.getExceptionType(this.semanticModel)));
    }

    private boolean isExceptionHandledByBlock(org.sonar.plugins.java.api.semantic.Type exceptionType, BytecodeCFG.Block b) {
        org.sonar.plugins.java.api.semantic.Type blockException = b.getExceptionType(this.semanticModel);
        return b.isUncaughtException() || exceptionType == null || exceptionType.isSubtypeOf(blockException) || blockException.isSubtypeOf(exceptionType);
    }

    @VisibleForTesting
    void handleBlockExit(ProgramPoint programPosition) {
        BytecodeCFG.Block block = (BytecodeCFG.Block)programPosition.block;
        Instruction terminator = block.terminator();
        if (terminator == null) {
            this.enqueueHappyPath(programPosition);
            return;
        }
        switch (terminator.opcode) {
            case 167: {
                this.enqueueHappyPath(programPosition);
                break;
            }
            case 170: 
            case 171: {
                this.programState = this.programState.unstackValue((int)1).state;
                this.enqueueHappyPath(programPosition);
                break;
            }
            default: {
                this.handleBranching(terminator);
            }
        }
    }

    private void handleBranching(Instruction terminator) {
        this.programState = this.branchingState(terminator, this.programState);
        Pair<List<ProgramState>, List<ProgramState>> pair = this.constraintManager.assumeDual(this.programState);
        ProgramPoint falsePP = new ProgramPoint(((BytecodeCFG.Block)this.programPosition.block).falseSuccessor());
        ProgramPoint truePP = new ProgramPoint(((BytecodeCFG.Block)this.programPosition.block).trueSuccessor());
        ((List)pair.a).forEach(s -> this.enqueue(falsePP, (ProgramState)s));
        ((List)pair.b).forEach(s -> this.enqueue(truePP, (ProgramState)s));
    }

    @VisibleForTesting
    ProgramState branchingState(Instruction terminator, ProgramState programState) {
        ProgramState ps;
        ImmutableList symbolicValueSymbols;
        switch (terminator.opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                ProgramState.Pop pop = programState.unstackValue(1);
                SymbolicValue svZero = new SymbolicValue();
                symbolicValueSymbols = ImmutableList.of((Object)new ProgramState.SymbolicValueSymbol(svZero, null), (Object)pop.valuesAndSymbols.get(0));
                List programStates = svZero.setConstraint(pop.state, DivisionByZeroCheck.ZeroConstraint.ZERO).stream().flatMap(s -> svZero.setConstraint((ProgramState)s, BooleanConstraint.FALSE).stream()).collect(Collectors.toList());
                Preconditions.checkState((programStates.size() == 1 ? 1 : 0) != 0);
                ps = (ProgramState)programStates.get(0);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                ProgramState.Pop pop = programState.unstackValue(2);
                symbolicValueSymbols = pop.valuesAndSymbols;
                ps = pop.state;
                break;
            }
            case 198: 
            case 199: {
                ProgramState.Pop pop = programState.unstackValue(1);
                symbolicValueSymbols = ImmutableList.of((Object)new ProgramState.SymbolicValueSymbol(SymbolicValue.NULL_LITERAL, null), (Object)pop.valuesAndSymbols.get(0));
                ps = pop.state;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected terminator " + terminator);
            }
        }
        return ps.stackValue(this.constraintManager.createBinarySymbolicValue(terminator, (List<ProgramState.SymbolicValueSymbol>)symbolicValueSymbols));
    }

    private void enqueueHappyPath(ProgramPoint programPosition) {
        programPosition.block.successors().stream().map(b -> (BytecodeCFG.Block)b).filter(b -> !b.isCatchBlock()).forEach(b -> this.enqueue(new ProgramPoint((CFG.IBlock<?>)b), this.programState));
    }

    private void executeCheckEndOfExecution() {
    }

    @VisibleForTesting
    Iterable<ProgramState> startingStates(String signature, ProgramState currentState, boolean isStaticMethod) {
        Type[] argumentTypes;
        int parameterIdx = 0;
        ProgramState state = currentState;
        if (!isStaticMethod) {
            SymbolicValue thisSV = this.constraintManager.createSymbolicValue((Instruction)null);
            state = currentState.addConstraint(thisSV, ObjectConstraint.NOT_NULL).addConstraint(thisSV, new TypedConstraint(signature.substring(0, signature.indexOf(35)))).put(0, thisSV);
            parameterIdx = 1;
        }
        for (Type argumentType : argumentTypes = Type.getArgumentTypes((String)signature.substring(signature.indexOf(40)))) {
            SymbolicValue sv = this.constraintManager.createSymbolicValue((Instruction)null);
            this.methodBehavior.addParameter(sv);
            state = state.put(parameterIdx, sv);
            state = BytecodeEGWalker.setDoubleOrLong(state, sv, argumentType.getSize() == 2);
            parameterIdx += argumentType.getSize();
        }
        return Collections.singletonList(state);
    }

    @VisibleForTesting
    void setNode(ExplodedGraph.Node node) {
        this.node = node;
        this.programPosition = this.node.programPoint;
        this.programState = this.node.programState;
    }

    void enqueue(ProgramPoint pp, ProgramState programState) {
        int nbOfExecution = programState.numberOfTimeVisited(pp);
        if (nbOfExecution > 2) {
            return;
        }
        ProgramState ps = programState.visitedPoint(pp, nbOfExecution + 1);
        ExplodedGraph.Node cachedNode = this.explodedGraph.node(pp, ps);
        cachedNode.addParent(this.node, null);
        if (cachedNode.isNew()) {
            this.workList.addFirst(cachedNode);
        }
    }

    private void handleEndOfExecutionPath() {
        ExplodedGraph.Node savedNode = this.node;
        this.endOfExecutionPath.forEach(n -> {
            this.setNode((ExplodedGraph.Node)n);
            if (this.methodBehavior != null) {
                this.methodBehavior.createYield(this.node, false);
            }
        });
        this.setNode(savedNode);
    }

    static class BytecodeAnalysisException
    extends RuntimeException {
        public BytecodeAnalysisException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static enum StackValueCategoryConstraint implements Constraint
    {
        LONG_OR_DOUBLE;


        @Override
        public String valueAsString() {
            return this.toString();
        }

        @Override
        @Nullable
        public Constraint copyOver(RelationalSymbolicValue.Kind kind) {
            return null;
        }
    }
}

