/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.se;

import java.util.List;
import org.sonar.java.bytecode.cfg.Instruction;
import org.sonar.java.bytecode.se.CheckerDispatcher;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.DivisionByZeroCheck;
import org.sonar.java.se.constraint.BooleanConstraint;
import org.sonar.java.se.constraint.ObjectConstraint;
import org.sonar.java.se.symbolicvalues.SymbolicValue;

public interface BytecodeSECheck {
    default public ProgramState checkPreStatement(CheckerDispatcher dispatcher, Instruction inst) {
        return dispatcher.getState();
    }

    default public ProgramState checkPostStatement(CheckerDispatcher dispatcher, Instruction inst) {
        return dispatcher.getState();
    }

    public static class ZeronessCheck
    implements BytecodeSECheck {
        @Override
        public ProgramState checkPostStatement(CheckerDispatcher dispatcher, Instruction inst) {
            ProgramState currentState = dispatcher.getState();
            ExplodedGraph.Node node = dispatcher.getNode();
            if (node == null) {
                return currentState;
            }
            ProgramState previousState = node.programState;
            switch (inst.opcode) {
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: {
                    return ZeronessCheck.handlePlusMinus(previousState, currentState);
                }
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    return ZeronessCheck.handleMultiply(previousState, currentState);
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    return ZeronessCheck.handleDivisionRemainder(previousState, currentState, true);
                }
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    return ZeronessCheck.handleDivisionRemainder(previousState, currentState, false);
                }
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: {
                    return ZeronessCheck.handleShift(previousState, currentState);
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    return ZeronessCheck.handleNegation(previousState, currentState);
                }
            }
            return currentState;
        }

        private static ProgramState handlePlusMinus(ProgramState previousState, ProgramState currentState) {
            List<SymbolicValue> operands = previousState.peekValues(2);
            SymbolicValue result = currentState.peekValue();
            SymbolicValue op1 = operands.get(0);
            SymbolicValue op2 = operands.get(1);
            boolean op1Zero = ZeronessCheck.isZero(currentState, op1);
            boolean op2Zero = ZeronessCheck.isZero(currentState, op2);
            if (op2Zero) {
                return currentState.unstackValue((int)1).state.stackValue(op1);
            }
            if (op1Zero) {
                return currentState.unstackValue((int)1).state.stackValue(op2);
            }
            return currentState.removeConstraintsOnDomain(result, BooleanConstraint.class);
        }

        private static ProgramState handleMultiply(ProgramState previousState, ProgramState currentState) {
            List<SymbolicValue> operands = previousState.peekValues(2);
            SymbolicValue result = currentState.peekValue();
            SymbolicValue op1 = operands.get(0);
            SymbolicValue op2 = operands.get(1);
            boolean op1Zero = ZeronessCheck.isZero(currentState, op1);
            if (op1Zero || ZeronessCheck.isZero(currentState, op2)) {
                return currentState.unstackValue((int)1).state.stackValue(op1Zero ? op1 : op2);
            }
            if (ZeronessCheck.isNonZero(currentState, op1) && ZeronessCheck.isNonZero(currentState, op2)) {
                return currentState.removeConstraintsOnDomain(result, BooleanConstraint.class).addConstraint(result, DivisionByZeroCheck.ZeroConstraint.NON_ZERO);
            }
            return currentState.removeConstraintsOnDomain(result, BooleanConstraint.class);
        }

        private static ProgramState handleDivisionRemainder(ProgramState previousState, ProgramState currentState, boolean isDivision) {
            List<SymbolicValue> operands = previousState.peekValues(2);
            SymbolicValue result = currentState.peekValue();
            SymbolicValue op1 = operands.get(0);
            SymbolicValue op2 = operands.get(1);
            if (ZeronessCheck.isZero(currentState, op2)) {
                return null;
            }
            if (ZeronessCheck.isZero(currentState, op1)) {
                return currentState.unstackValue((int)1).state.stackValue(op1);
            }
            if (ZeronessCheck.isNonZero(currentState, op1) && isDivision) {
                return currentState.removeConstraintsOnDomain(result, BooleanConstraint.class).addConstraint(result, DivisionByZeroCheck.ZeroConstraint.NON_ZERO);
            }
            return currentState.removeConstraintsOnDomain(result, BooleanConstraint.class);
        }

        private static ProgramState handleNegation(ProgramState previousState, ProgramState currentState) {
            List<SymbolicValue> operands = previousState.peekValues(1);
            SymbolicValue result = currentState.peekValue();
            SymbolicValue op1 = operands.get(0);
            if (ZeronessCheck.isZero(currentState, op1)) {
                return currentState.unstackValue((int)1).state.stackValue(op1);
            }
            if (ZeronessCheck.isNonZero(currentState, op1)) {
                return currentState.removeConstraintsOnDomain(result, BooleanConstraint.class).addConstraint(result, DivisionByZeroCheck.ZeroConstraint.NON_ZERO);
            }
            return currentState.removeConstraintsOnDomain(result, BooleanConstraint.class);
        }

        private static ProgramState handleShift(ProgramState previousState, ProgramState currentState) {
            List<SymbolicValue> operands = previousState.peekValues(2);
            SymbolicValue result = currentState.peekValue();
            SymbolicValue op1 = operands.get(0);
            SymbolicValue op2 = operands.get(0);
            if (ZeronessCheck.isZero(currentState, op1) || ZeronessCheck.isZero(currentState, op2)) {
                return currentState.unstackValue((int)1).state.stackValue(op1);
            }
            return currentState.removeConstraintsOnDomain(result, BooleanConstraint.class).addConstraint(result, DivisionByZeroCheck.ZeroConstraint.NON_ZERO);
        }

        private static boolean isZero(ProgramState state, SymbolicValue sv) {
            return state.getConstraint(sv, DivisionByZeroCheck.ZeroConstraint.class) == DivisionByZeroCheck.ZeroConstraint.ZERO;
        }

        private static boolean isNonZero(ProgramState state, SymbolicValue sv) {
            return state.getConstraint(sv, DivisionByZeroCheck.ZeroConstraint.class) == DivisionByZeroCheck.ZeroConstraint.NON_ZERO;
        }
    }

    public static class NullnessCheck
    implements BytecodeSECheck {
        @Override
        public ProgramState checkPreStatement(CheckerDispatcher dispatcher, Instruction inst) {
            ProgramState state = dispatcher.getState();
            if (NullnessCheck.isInvokeOnObjectRef(inst)) {
                SymbolicValue objectRef = state.peekValue(inst.arity());
                ObjectConstraint constraint = state.getConstraint(objectRef, ObjectConstraint.class);
                if (constraint != null && constraint.isNull()) {
                    return null;
                }
                if (constraint == null) {
                    return state.addConstraint(objectRef, ObjectConstraint.NOT_NULL);
                }
            }
            return state;
        }

        private static boolean isInvokeOnObjectRef(Instruction inst) {
            return inst.opcode == 185 || inst.opcode == 183 || inst.opcode == 182;
        }
    }
}

