/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.model.expression.ConditionalExpressionTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.model.expression.LambdaExpressionTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.MethodReferenceTreeImpl;
import org.sonar.java.model.expression.NewArrayTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.model.expression.ParenthesizedTreeImpl;
import org.sonar.java.resolve.AnnotationInstanceResolve;
import org.sonar.java.resolve.AnnotationValueResolve;
import org.sonar.java.resolve.ArrayJavaType;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.DeferredType;
import org.sonar.java.resolve.IntersectionType;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.java.resolve.LambdaBlockReturnVisitor;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeSubstitution;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.java.resolve.WildCardType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public class TypeAndReferenceSolver
extends BaseTreeVisitor {
    private final Map<Tree.Kind, JavaType> typesOfLiterals = Maps.newEnumMap(Tree.Kind.class);
    private final SemanticModel semanticModel;
    private final Symbols symbols;
    private final Resolve resolve;
    private final ParametrizedTypeCache parametrizedTypeCache;
    private final Map<Tree, JavaType> types = Maps.newHashMap();
    Resolve.Env env;

    public TypeAndReferenceSolver(SemanticModel semanticModel, Symbols symbols, Resolve resolve, ParametrizedTypeCache parametrizedTypeCache) {
        this.semanticModel = semanticModel;
        this.symbols = symbols;
        this.resolve = resolve;
        this.parametrizedTypeCache = parametrizedTypeCache;
        this.typesOfLiterals.put(Tree.Kind.BOOLEAN_LITERAL, symbols.booleanType);
        this.typesOfLiterals.put(Tree.Kind.NULL_LITERAL, symbols.nullType);
        this.typesOfLiterals.put(Tree.Kind.CHAR_LITERAL, symbols.charType);
        this.typesOfLiterals.put(Tree.Kind.STRING_LITERAL, symbols.stringType);
        this.typesOfLiterals.put(Tree.Kind.FLOAT_LITERAL, symbols.floatType);
        this.typesOfLiterals.put(Tree.Kind.DOUBLE_LITERAL, symbols.doubleType);
        this.typesOfLiterals.put(Tree.Kind.LONG_LITERAL, symbols.longType);
        this.typesOfLiterals.put(Tree.Kind.INT_LITERAL, symbols.intType);
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.scan(tree.modifiers());
        TypeAndReferenceSolver.completeMetadata((JavaSymbol.MethodJavaSymbol)tree.symbol(), tree.modifiers().annotations());
        this.scan(tree.typeParameters());
        this.scan(tree.parameters());
        this.scan(tree.defaultValue());
        this.scan(tree.block());
    }

    @Override
    public void visitClass(ClassTree tree) {
        this.scan(tree.modifiers());
        TypeAndReferenceSolver.completeMetadata((JavaSymbol)((Object)tree.symbol()), tree.modifiers().annotations());
        this.scan(tree.typeParameters());
        this.scan(tree.members());
    }

    private static void completeMetadata(JavaSymbol symbol, List<AnnotationTree> annotations) {
        for (AnnotationTree tree : annotations) {
            AnnotationInstanceResolve annotationInstance = new AnnotationInstanceResolve((JavaSymbol.TypeJavaSymbol)tree.symbolType().symbol());
            symbol.metadata().addAnnotation(annotationInstance);
            Arguments arguments = tree.arguments();
            if (arguments.size() > 1 || !arguments.isEmpty() && ((ExpressionTree)arguments.get(0)).is(Tree.Kind.ASSIGNMENT)) {
                for (ExpressionTree expressionTree : arguments) {
                    AssignmentExpressionTree aet = (AssignmentExpressionTree)expressionTree;
                    annotationInstance.addValue(new AnnotationValueResolve(((IdentifierTree)aet.variable()).name(), aet.expression()));
                }
                continue;
            }
            TypeAndReferenceSolver.addConstantValue(tree, annotationInstance);
        }
    }

    private static void addConstantValue(AnnotationTree tree, AnnotationInstanceResolve annotationInstance) {
        Collection<Symbol> scopeSymbols = tree.annotationType().symbolType().symbol().memberSymbols();
        for (ExpressionTree expressionTree : tree.arguments()) {
            String name = "";
            for (Symbol scopeSymbol : scopeSymbols) {
                if (!scopeSymbol.isMethodSymbol()) continue;
                name = scopeSymbol.name();
                break;
            }
            annotationInstance.addValue(new AnnotationValueResolve(name, expressionTree));
        }
    }

    @Override
    public void visitImport(ImportTree tree) {
    }

    @Override
    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.scan(tree.statement());
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        JavaSymbol symbol;
        JavaType returnType;
        MethodInvocationTreeImpl mit = (MethodInvocationTreeImpl)tree;
        Resolve.Env methodEnv = this.semanticModel.getEnv(tree);
        if (mit.isTypeSet() && mit.symbol().isMethodSymbol()) {
            TypeSubstitution typeSubstitution = TypeAndReferenceSolver.inferedSubstitution(mit);
            List<JavaType> argTypes = TypeAndReferenceSolver.getParameterTypes(tree.arguments());
            JavaSymbol.MethodJavaSymbol methodSymbol = (JavaSymbol.MethodJavaSymbol)mit.symbol();
            List<JavaType> formals = methodSymbol.parameterTypes().stream().map(t -> (JavaType)t).collect(Collectors.toList());
            List<JavaType> inferedArgTypes = this.resolve.resolveTypeSubstitution(formals, typeSubstitution);
            int size = inferedArgTypes.size();
            IntStream.range(0, argTypes.size()).forEach(i -> {
                JavaType arg = (JavaType)argTypes.get(i);
                Type formal = (Type)inferedArgTypes.get(Math.min(i, size - 1));
                if (formal != arg) {
                    AbstractTypedTree argTree = (AbstractTypedTree)mit.arguments().get(i);
                    argTree.setInferedType(formal);
                    argTree.accept(this);
                }
            });
            List<JavaType> typeParamTypes = TypeAndReferenceSolver.getParameterTypes(tree.typeArguments());
            JavaType resultType = ((MethodJavaType)mit.symbol().type()).resultType;
            if (resultType.symbol.owner == mit.symbol()) {
                resultType = (JavaType)mit.symbolType();
            }
            this.inferReturnTypeFromInferedArgs(tree, methodEnv, argTypes, typeParamTypes, resultType, typeSubstitution);
            return;
        }
        this.scan(tree.arguments());
        this.scan(tree.typeArguments());
        List<JavaType> argTypes = TypeAndReferenceSolver.getParameterTypes(tree.arguments());
        List<JavaType> typeParamTypes = TypeAndReferenceSolver.getParameterTypes(tree.typeArguments());
        Resolve.Resolution resolution = this.resolveMethodSymbol(tree.methodSelect(), methodEnv, argTypes, typeParamTypes);
        if (resolution == null) {
            returnType = this.symbols.deferedType(mit);
            symbol = Symbols.unknownSymbol;
        } else {
            symbol = resolution.symbol();
            returnType = resolution.type();
            if (symbol.isMethodSymbol()) {
                MethodJavaType methodType = (MethodJavaType)resolution.type();
                returnType = methodType.resultType;
            }
        }
        mit.setSymbol(symbol);
        if (returnType != null && returnType.isTagged(17)) {
            ((DeferredType)returnType).setTree(mit);
        }
        this.registerType(tree, returnType);
        if (resolution != null) {
            this.inferArgumentTypes(argTypes, resolution);
            this.inferReturnTypeFromInferedArgs(tree, methodEnv, argTypes, typeParamTypes, returnType, new TypeSubstitution());
        }
    }

    private void inferReturnTypeFromInferedArgs(MethodInvocationTree tree, Resolve.Env methodEnv, List<JavaType> argTypes, List<JavaType> typeParamTypes, JavaType returnType, TypeSubstitution typeSubstitution) {
        List<JavaType> parameterTypes = TypeAndReferenceSolver.getParameterTypes(tree.arguments());
        if (!parameterTypes.equals(argTypes)) {
            IdentifierTree identifier = null;
            Resolve.Resolution resolution = null;
            ExpressionTree methodSelect = tree.methodSelect();
            if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mset = (MemberSelectExpressionTree)methodSelect;
                JavaType type = this.getType(mset.expression());
                if (type.isTagged(17)) {
                    throw new IllegalStateException("type of arg should not be defered anymore ??");
                }
                identifier = mset.identifier();
                resolution = this.resolve.findMethod(methodEnv, type, identifier.name(), parameterTypes, typeParamTypes);
            } else if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
                identifier = (IdentifierTree)methodSelect;
                resolution = this.resolve.findMethod(methodEnv, identifier.name(), parameterTypes, typeParamTypes);
            }
            if (resolution != null && returnType != resolution.type() && resolution.symbol().isMethodSymbol()) {
                MethodJavaType methodType = (MethodJavaType)resolution.type();
                if (!methodType.resultType.isTagged(17)) {
                    this.registerType(tree, this.resolve.applySubstitution(methodType.resultType, typeSubstitution));
                    this.registerType(identifier, methodType);
                }
            }
        } else {
            this.registerType(tree, this.resolve.applySubstitution(returnType, typeSubstitution));
        }
    }

    private static TypeSubstitution inferedSubstitution(MethodInvocationTreeImpl mit) {
        JavaSymbol.MethodJavaSymbol methodSymbol = (JavaSymbol.MethodJavaSymbol)mit.symbol();
        JavaType methodReturnedType = (JavaType)mit.symbolType();
        TypeSubstitution typeSubstitution = new TypeSubstitution();
        if (methodReturnedType.isTagged(18)) {
            JavaType resultType = ((MethodJavaType)methodSymbol.type).resultType;
            if (resultType.isTagged(18)) {
                typeSubstitution = ((ParametrizedTypeJavaType)resultType).typeSubstitution.combine(((ParametrizedTypeJavaType)methodReturnedType).typeSubstitution);
            } else if (resultType.isTagged(15)) {
                typeSubstitution.add((TypeVariableJavaType)resultType, methodReturnedType);
            }
        }
        return typeSubstitution;
    }

    private void setInferedType(Type infered, DeferredType deferredType) {
        Type newClassType;
        AbstractTypedTree inferedExpression = deferredType.tree();
        Type newType = infered;
        if (inferedExpression.is(Tree.Kind.NEW_CLASS) && ((JavaType)(newClassType = ((NewClassTree)((Object)inferedExpression)).identifier().symbolType())).isParameterized()) {
            newType = this.resolve.resolveTypeSubstitutionWithDiamondOperator((ParametrizedTypeJavaType)newClassType, (JavaType)infered);
        }
        inferedExpression.setInferedType(newType);
        inferedExpression.accept(this);
        if (inferedExpression.is(Tree.Kind.VAR_TYPE)) {
            JavaSymbol.VariableJavaSymbol variableSymbol = ((VariableTreeImpl)inferedExpression.parent()).getSymbol();
            variableSymbol.type = (JavaType)newType;
        }
    }

    private static List<JavaType> getParameterTypes(@Nullable List<? extends Tree> args) {
        if (args == null) {
            return new ArrayList<JavaType>();
        }
        return args.stream().map(e -> ((AbstractTypedTree)e).isTypeSet() ? (JavaType)((AbstractTypedTree)e).symbolType() : Symbols.unknownType).collect(Collectors.toList());
    }

    @CheckForNull
    private Resolve.Resolution resolveMethodSymbol(Tree methodSelect, Resolve.Env methodEnv, List<JavaType> argTypes, List<JavaType> typeParamTypes) {
        Resolve.Resolution resolution;
        IdentifierTree identifier;
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)methodSelect;
            this.resolveAs(mset.expression(), 6);
            JavaType type = this.getType(mset.expression());
            if (type.isTagged(17)) {
                return null;
            }
            identifier = mset.identifier();
            resolution = this.resolve.findMethod(methodEnv, type, identifier.name(), argTypes, typeParamTypes);
        } else if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            identifier = (IdentifierTree)methodSelect;
            resolution = this.resolve.findMethod(methodEnv, identifier.name(), argTypes, typeParamTypes);
        } else {
            throw new IllegalStateException("Method select in method invocation is not of the expected type " + methodSelect);
        }
        this.registerType(identifier, resolution.type());
        TypeAndReferenceSolver.associateReference(identifier, resolution.symbol());
        return resolution;
    }

    private void resolveAs(@Nullable Tree tree, int kind) {
        if (tree == null) {
            return;
        }
        if (this.env == null) {
            this.resolveAs(tree, kind, this.semanticModel.getEnv(tree));
        } else {
            this.resolveAs(tree, kind, this.env);
        }
    }

    public JavaSymbol resolveAs(Tree tree, int kind, Resolve.Env resolveEnv) {
        return this.resolveAs(tree, kind, resolveEnv, true);
    }

    public JavaSymbol resolveAs(Tree tree, int kind, Resolve.Env resolveEnv, boolean associateReference) {
        if (tree.is(Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT)) {
            JavaSymbol resolvedSymbol;
            IdentifierTree identifierTree;
            if (tree.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
                if (JavaKeyword.CLASS.getValue().equals(mse.identifier().name())) {
                    return this.resolveClassType(tree, resolveEnv, mse);
                }
                identifierTree = mse.identifier();
                List<AnnotationTree> identifierAnnotations = identifierTree.annotations();
                this.scan(identifierAnnotations);
                TypeAndReferenceSolver.completeMetadata((JavaSymbol)identifierTree.symbol(), identifierAnnotations);
                Resolve.Resolution res = this.getSymbolOfMemberSelectExpression(mse, kind, resolveEnv);
                resolvedSymbol = res.symbol();
                JavaType resolvedType = this.resolve.resolveTypeSubstitution(res.type(), this.getType(mse.expression()));
                this.registerType(identifierTree, resolvedType);
                this.registerType(tree, resolvedType);
            } else {
                identifierTree = (IdentifierTree)tree;
                Resolve.Resolution resolution = this.resolve.findIdent(resolveEnv, identifierTree.name(), kind);
                resolvedSymbol = resolution.symbol();
                JavaType type = resolution.type();
                if (kind == 2 && type.isParameterized()) {
                    type = type.erasure();
                }
                this.registerType(tree, type);
            }
            if (associateReference) {
                TypeAndReferenceSolver.associateReference(identifierTree, resolvedSymbol);
            }
            return resolvedSymbol;
        }
        tree.accept(this);
        JavaType type = this.getType(tree);
        if (tree.is(Tree.Kind.INFERED_TYPE, Tree.Kind.VAR_TYPE)) {
            type = this.symbols.deferedType((AbstractTypedTree)tree);
            this.registerType(tree, type);
        }
        if (type == null) {
            throw new IllegalStateException("Type not resolved " + tree);
        }
        return type.symbol;
    }

    private JavaSymbol resolveClassType(Tree tree, Resolve.Env resolveEnv, MemberSelectExpressionTree mse) {
        this.resolveAs(mse.expression(), 2, resolveEnv);
        JavaType expressionType = this.getType(mse.expression());
        if (expressionType.isPrimitive()) {
            expressionType = expressionType.primitiveWrapperType();
        }
        TypeSubstitution typeSubstitution = new TypeSubstitution();
        typeSubstitution.add(this.symbols.classType.getSymbol().typeVariableTypes.get(0), expressionType);
        JavaType parametrizedClassType = this.parametrizedTypeCache.getParametrizedTypeType(this.symbols.classType.symbol, typeSubstitution);
        this.registerType(tree, parametrizedClassType);
        return parametrizedClassType.symbol;
    }

    private Resolve.Resolution getSymbolOfMemberSelectExpression(MemberSelectExpressionTree mse, int kind, Resolve.Env resolveEnv) {
        int expressionKind = 2;
        if ((kind & 4) != 0) {
            expressionKind |= 4;
        }
        if ((kind & 2) != 0) {
            expressionKind |= 1;
        }
        JavaSymbol site = this.resolveAs(mse.expression(), expressionKind, resolveEnv);
        if (site.kind == 4) {
            return this.resolve.findIdentInType(resolveEnv, this.getType((Tree)mse.expression()).symbol, mse.identifier().name(), 4);
        }
        if (site.kind == 2) {
            return this.resolve.findIdentInType(resolveEnv, (JavaSymbol.TypeJavaSymbol)site, mse.identifier().name(), kind);
        }
        if (site.kind == 1) {
            return Resolve.Resolution.resolution(this.resolve.findIdentInPackage(site, mse.identifier().name(), kind));
        }
        return this.resolve.unresolved();
    }

    private void resolveAs(List<? extends Tree> trees, int kind) {
        for (Tree tree : trees) {
            this.resolveAs(tree, kind);
        }
    }

    @Override
    public void visitTypeParameter(TypeParameterTree typeParameter) {
    }

    @Override
    public void visitTypeArguments(TypeArguments trees) {
        this.resolveAs(trees, 2);
    }

    @Override
    public void visitInstanceOf(InstanceOfTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.resolveAs(tree.type(), 2);
        this.registerType(tree, this.symbols.booleanType);
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        this.resolveAs(tree.type(), 2);
        this.resolveAs(tree.typeArguments(), 2);
        this.registerType(tree, this.parametrizedTypeWithTypeArguments(this.getType(tree.type()).getSymbol(), tree.typeArguments()));
    }

    private JavaType parametrizedTypeWithTypeArguments(JavaSymbol.TypeJavaSymbol symbol, TypeArguments typeArguments) {
        TypeSubstitution typeSubstitution = new TypeSubstitution();
        if (typeArguments.size() <= symbol.typeVariableTypes.size()) {
            for (int i = 0; i < typeArguments.size(); ++i) {
                typeSubstitution.add(symbol.typeVariableTypes.get(i), this.getType((Tree)typeArguments.get(i)));
            }
        }
        return this.parametrizedTypeCache.getParametrizedTypeType(symbol, typeSubstitution);
    }

    @Override
    public void visitWildcard(WildcardTree tree) {
        if (tree.is(Tree.Kind.UNBOUNDED_WILDCARD)) {
            this.registerType(tree, this.symbols.unboundedWildcard);
        } else {
            this.resolveAs(tree.bound(), 2);
            JavaType bound = this.getType(tree.bound());
            WildCardType.BoundType boundType = tree.is(Tree.Kind.SUPER_WILDCARD) ? WildCardType.BoundType.SUPER : WildCardType.BoundType.EXTENDS;
            this.registerType(tree, this.parametrizedTypeCache.getWildcardType(bound, boundType));
        }
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        if (((ConditionalExpressionTreeImpl)tree).isTypeSet()) {
            JavaType falseType;
            JavaType trueType = this.getType(tree.trueExpression());
            if (trueType.isTagged(17)) {
                this.setInferedType(tree.symbolType(), (DeferredType)trueType);
            }
            if ((falseType = this.getType(tree.falseExpression())).isTagged(17)) {
                this.setInferedType(tree.symbolType(), (DeferredType)falseType);
            }
        } else {
            this.resolveAs(tree.condition(), 4);
            this.resolveAs(tree.trueExpression(), 4);
            this.resolveAs(tree.falseExpression(), 4);
            this.registerType(tree, this.resolve.conditionalExpressionType(tree, (JavaType)tree.trueExpression().symbolType(), (JavaType)tree.falseExpression().symbolType()));
        }
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.resolveAs(tree.expression(), 4);
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree tree) {
        LambdaExpressionTreeImpl lambdaExpressionTree = (LambdaExpressionTreeImpl)tree;
        if (lambdaExpressionTree.isTypeSet()) {
            JavaType lambdaType = (JavaType)lambdaExpressionTree.symbolType();
            List<JavaType> samMethodArgs = this.resolve.findSamMethodArgs(lambdaType);
            for (int i = 0; i < samMethodArgs.size(); ++i) {
                VariableTree param = lambdaExpressionTree.parameters().get(i);
                if (!param.type().is(Tree.Kind.INFERED_TYPE)) continue;
                JavaType inferedType = samMethodArgs.get(i);
                if (inferedType.isTagged(16)) {
                    inferedType = ((WildCardType)inferedType).bound;
                }
                ((AbstractTypedTree)((Object)param.type())).setInferedType(inferedType);
                ((JavaSymbol.VariableJavaSymbol)param.symbol()).type = inferedType;
            }
            super.visitLambdaExpression(tree);
            if (lambdaType.isUnknown() || lambdaType.isTagged(17)) {
                return;
            }
            this.refineLambdaType(lambdaExpressionTree, lambdaType);
        } else {
            this.registerType(tree, this.symbols.deferedType(lambdaExpressionTree));
        }
    }

    private void refineLambdaType(LambdaExpressionTreeImpl lambdaExpressionTree, JavaType lambdaType) {
        Optional<JavaSymbol.MethodJavaSymbol> samMethod = this.resolve.getSamMethod(lambdaType);
        if (!samMethod.isPresent()) {
            return;
        }
        JavaType samReturnType = (JavaType)samMethod.get().returnType().type();
        JavaType capturedReturnType = this.resolve.resolveTypeSubstitution(samReturnType, lambdaType);
        if (capturedReturnType.is("void") || !lambdaType.isParameterized()) {
            return;
        }
        JavaType refinedReturnType = capturedReturnType;
        if (lambdaExpressionTree.body().is(Tree.Kind.BLOCK)) {
            LambdaBlockReturnVisitor lambdaBlockReturnVisitor = new LambdaBlockReturnVisitor();
            lambdaExpressionTree.body().accept(lambdaBlockReturnVisitor);
            if (!lambdaBlockReturnVisitor.types.isEmpty()) {
                refinedReturnType = (JavaType)this.resolve.leastUpperBound(lambdaBlockReturnVisitor.types);
            }
        } else {
            refinedReturnType = (JavaType)((AbstractTypedTree)lambdaExpressionTree.body()).symbolType();
        }
        this.refineType(lambdaExpressionTree, lambdaType, capturedReturnType, refinedReturnType);
    }

    private void refineType(AbstractTypedTree expression, JavaType expressionType, JavaType capturedReturnType, JavaType refinedReturnType) {
        if (refinedReturnType != capturedReturnType) {
            if (expressionType.isTagged(18)) {
                ParametrizedTypeJavaType functionType = (ParametrizedTypeJavaType)this.resolve.functionType((ParametrizedTypeJavaType)expressionType);
                TypeSubstitution typeSubstitution = ((ParametrizedTypeJavaType)expressionType).typeSubstitution;
                typeSubstitution.substitutionEntries().stream().filter(e -> e.getValue() == capturedReturnType).map(Map.Entry::getKey).findFirst().ifPresent(t -> {
                    if (refinedReturnType instanceof DeferredType) {
                        this.setInferedType(functionType.typeSubstitution.substitutedType((JavaType)t), (DeferredType)refinedReturnType);
                    } else {
                        TypeSubstitution refinedSubstitution = new TypeSubstitution(typeSubstitution).add((TypeVariableJavaType)t, refinedReturnType);
                        JavaType refinedType = this.parametrizedTypeCache.getParametrizedTypeType(expressionType.symbol, refinedSubstitution);
                        expression.setType(refinedType);
                    }
                });
            } else {
                expression.setType(refinedReturnType);
            }
        }
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        ExpressionTree expression = tree.expression();
        if (expression != null && ((JavaType)expression.symbolType()).isTagged(17)) {
            Tree parent = tree.parent();
            while (!parent.is(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION)) {
                if ((parent = parent.parent()) != null) continue;
                throw new IllegalStateException("Return statement was unexpected here");
            }
            Type infered = parent.is(Tree.Kind.METHOD) ? ((MethodTree)parent).returnType().symbolType() : ((LambdaExpressionTree)parent).symbolType();
            this.setInferedType(infered, (DeferredType)expression.symbolType());
        }
    }

    @Override
    public void visitCaseLabel(CaseLabelTree tree) {
        ExpressionTree labelExpression = tree.expression();
        if (labelExpression == null) {
            return;
        }
        ExpressionTree enumExpression = TypeAndReferenceSolver.enumExpressionFromSwitchOnEnum(tree);
        if (enumExpression != null) {
            this.resolveEnumConstant(enumExpression, (IdentifierTree)labelExpression);
        } else {
            this.scan(tree.expression());
        }
    }

    @CheckForNull
    private static ExpressionTree enumExpressionFromSwitchOnEnum(CaseLabelTree tree) {
        Tree parent = tree.parent();
        while (!parent.is(Tree.Kind.SWITCH_STATEMENT)) {
            parent = parent.parent();
        }
        ExpressionTree enumExpression = ((SwitchStatementTree)parent).expression();
        return enumExpression.symbolType().symbol().isEnum() ? enumExpression : null;
    }

    private void resolveEnumConstant(ExpressionTree enumExpression, IdentifierTree enumConstant) {
        JavaSymbol.TypeJavaSymbol enumSymbol;
        Resolve.Env enumEnv = this.semanticModel.getEnv(enumExpression);
        Resolve.Resolution res = this.resolve.findIdentInType(enumEnv, enumSymbol = (JavaSymbol.TypeJavaSymbol)enumExpression.symbolType().symbol(), enumConstant.name(), 4);
        if (!res.symbol().isUnknown()) {
            this.registerType(enumConstant, res.type());
            TypeAndReferenceSolver.associateReference(enumConstant, res.symbol());
        }
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        this.resolveAs(tree.type(), 2);
        this.scan(tree.dimensions());
        this.resolveAs((List<? extends Tree>)tree.initializers(), 4);
        JavaType type = this.getType(tree.type());
        if (tree.type() == null) {
            if (((NewArrayTreeImpl)tree).isTypeSet() && tree.symbolType().isArray()) {
                type = ((ArrayJavaType)tree.symbolType()).elementType;
            } else {
                this.registerType(tree, this.symbols.deferedType((AbstractTypedTree)((Object)tree)));
                return;
            }
        }
        int dimensions = tree.dimensions().size();
        type = new ArrayJavaType(type, this.symbols.arrayClass);
        for (int i = 1; i < dimensions; ++i) {
            type = new ArrayJavaType(type, this.symbols.arrayClass);
        }
        this.registerType(tree, type);
        for (ExpressionTree expressionTree : tree.initializers()) {
            if (!((JavaType)expressionTree.symbolType()).isTagged(17)) continue;
            this.setInferedType(((ArrayJavaType)type).elementType, (DeferredType)expressionTree.symbolType());
        }
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        if (((ParenthesizedTreeImpl)tree).isTypeSet()) {
            JavaType expType = this.getType(tree.expression());
            if (expType.isTagged(17)) {
                this.setInferedType(tree.symbolType(), (DeferredType)expType);
            }
        } else {
            this.resolveAs(tree.expression(), 4);
            JavaType parenthesizedExpressionType = this.getType(tree.expression());
            if (parenthesizedExpressionType.isTagged(17)) {
                parenthesizedExpressionType = this.symbols.deferedType((AbstractTypedTree)((Object)tree));
            }
            this.registerType(tree, parenthesizedExpressionType);
        }
    }

    @Override
    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.scan(tree.dimension());
        JavaType type = this.getType(tree.expression());
        if (type != null && type.tag == 11) {
            this.registerType(tree, ((ArrayJavaType)type).elementType);
        } else {
            this.registerType(tree, Symbols.unknownType);
        }
    }

    @Override
    public void visitArrayDimension(ArrayDimensionTree tree) {
        this.resolveAs(tree.expression(), 4);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        tree.leftOperand().accept(this);
        tree.rightOperand().accept(this);
        this.registerBinaryExpressionType(tree);
    }

    private void registerBinaryExpressionType(BinaryExpressionTree tree) {
        JavaType left = this.getType(tree.leftOperand());
        JavaType right = this.getType(tree.rightOperand());
        if (left == null || right == null) {
            this.registerType(tree, Symbols.unknownType);
            return;
        }
        if ("+".equals(tree.operatorToken().text()) && (left == this.symbols.stringType || right == this.symbols.stringType)) {
            this.registerType(tree, this.symbols.stringType);
            return;
        }
        this.registerType(tree, this.binaryExpressionType(tree, left, right));
    }

    private JavaType binaryExpressionType(BinaryExpressionTree tree, JavaType left, JavaType right) {
        JavaSymbol symbol = this.resolve.findMethod(this.semanticModel.getEnv(tree), this.symbols.predefClass.type, tree.operatorToken().text(), (List<JavaType>)ImmutableList.of((Object)left, (Object)right)).symbol();
        if (symbol.kind != 16) {
            return Symbols.unknownType;
        }
        return ((MethodJavaType)symbol.type).resultType;
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        ClassTree classBody;
        NewClassTreeImpl newClassTreeImpl = (NewClassTreeImpl)tree;
        if (newClassTreeImpl.isTypeSet()) {
            return;
        }
        Object typeArgumentsTypes = ImmutableList.of();
        if (tree.typeArguments() != null) {
            this.resolveAs(tree.typeArguments(), 2);
            typeArgumentsTypes = tree.typeArguments().stream().map(this::getType).collect(Collectors.toList());
        }
        this.resolveAs(tree.arguments(), 4);
        List<JavaType> parameterTypes = TypeAndReferenceSolver.getParameterTypes(tree.arguments());
        Resolve.Env newClassEnv = this.semanticModel.getEnv(tree);
        ExpressionTree enclosingExpression = tree.enclosingExpression();
        TypeTree typeTree = tree.identifier();
        IdentifierTree constructorIdentifier = newClassTreeImpl.getConstructorIdentifier();
        JavaType identifierType = this.resolveIdentifierType(newClassEnv, enclosingExpression, typeTree, constructorIdentifier.name());
        JavaSymbol.TypeJavaSymbol constructorIdentifierSymbol = (JavaSymbol.TypeJavaSymbol)identifierType.symbol();
        constructorIdentifierSymbol.addUsage(constructorIdentifier);
        parameterTypes = TypeAndReferenceSolver.addImplicitOuterClassParameter(parameterTypes, constructorIdentifierSymbol);
        Resolve.Resolution resolution = this.resolveConstructorSymbol(constructorIdentifier, identifierType, newClassEnv, parameterTypes, (List<JavaType>)typeArgumentsTypes);
        JavaType constructedType = identifierType;
        if (resolution.symbol().isMethodSymbol()) {
            constructedType = ((MethodJavaType)resolution.type()).resultType;
            if (constructedType.isTagged(17)) {
                Tree parent = newClassTreeImpl.parent();
                if (parent.is(Tree.Kind.MEMBER_SELECT)) {
                    constructedType = this.resolve.parametrizedTypeWithErasure((ParametrizedTypeJavaType)identifierType);
                } else {
                    ((DeferredType)constructedType).setTree(newClassTreeImpl);
                }
            } else if (identifierType.symbol().isInterface()) {
                this.registerType(typeTree, identifierType);
            } else {
                this.registerType(typeTree, resolution.type());
            }
        }
        if ((classBody = tree.classBody()) != null) {
            constructedType = this.getAnonymousClassType(identifierType, constructedType, classBody);
        }
        this.registerType(tree, constructedType);
    }

    private JavaType getAnonymousClassType(JavaType identifierType, JavaType constructedType, ClassTree classBody) {
        JavaType parentType = constructedType.isTagged(17) || identifierType.symbol().isInterface() ? identifierType : constructedType;
        ClassJavaType anonymousClassType = (ClassJavaType)classBody.symbol().type();
        if (parentType.getSymbol().isInterface()) {
            anonymousClassType.interfaces = ImmutableList.of((Object)parentType);
            anonymousClassType.supertype = this.symbols.objectType;
        } else {
            anonymousClassType.supertype = parentType;
            anonymousClassType.interfaces = ImmutableList.of();
        }
        anonymousClassType.symbol.members.enter(new JavaSymbol.VariableJavaSymbol(16, "super", anonymousClassType.supertype, (JavaSymbol)anonymousClassType.symbol));
        this.scan(classBody);
        return anonymousClassType;
    }

    private JavaType resolveIdentifierType(Resolve.Env newClassEnv, @Nullable ExpressionTree enclosingExpression, TypeTree typeTree, String typeName) {
        if (enclosingExpression != null) {
            this.resolveAs(enclosingExpression, 4);
            Resolve.Resolution idType = this.resolve.findIdentInType(newClassEnv, (JavaSymbol.TypeJavaSymbol)enclosingExpression.symbolType().symbol(), typeName, 2);
            JavaType type = idType.type();
            if (typeTree.is(Tree.Kind.PARAMETERIZED_TYPE)) {
                TypeArguments typeArguments = ((ParameterizedTypeTree)typeTree).typeArguments();
                this.scan(typeArguments);
                type = this.parametrizedTypeWithTypeArguments(type.symbol, typeArguments);
            }
            this.registerType(typeTree, type);
        } else {
            this.resolveAs(typeTree, 2, newClassEnv, false);
        }
        return (JavaType)typeTree.symbolType();
    }

    private static List<JavaType> addImplicitOuterClassParameter(List<JavaType> parameterTypes, JavaSymbol.TypeJavaSymbol constructorIdentifierSymbol) {
        ImmutableList result = parameterTypes;
        Symbol owner = constructorIdentifierSymbol.owner();
        if (!((JavaSymbol)owner).isPackageSymbol() && !constructorIdentifierSymbol.isStatic()) {
            result = ImmutableList.builder().add((Object)((JavaSymbol)owner).enclosingClass().type).addAll(parameterTypes).build();
        }
        return result;
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        super.visitExpressionStatement(tree);
        ExpressionTree expression = tree.expression();
        if (((JavaType)expression.symbolType()).isTagged(17) && expression.is(Tree.Kind.NEW_CLASS)) {
            JavaType parametrizedTypeWithObject = this.resolve.parametrizedTypeWithErasure((ParametrizedTypeJavaType)this.getType(((NewClassTree)expression).identifier()));
            this.setInferedType(parametrizedTypeWithObject, (DeferredType)expression.symbolType());
        }
    }

    private Resolve.Resolution resolveConstructorSymbol(IdentifierTree identifier, Type type, Resolve.Env methodEnv, List<JavaType> argTypes) {
        return this.resolveConstructorSymbol(identifier, type, methodEnv, argTypes, (List<JavaType>)ImmutableList.of());
    }

    private Resolve.Resolution resolveConstructorSymbol(IdentifierTree identifier, Type type, Resolve.Env methodEnv, List<JavaType> argTypes, List<JavaType> typeArgumentsTypes) {
        Resolve.Resolution resolution = this.resolve.findMethod(methodEnv, (JavaType)type, "<init>", argTypes, typeArgumentsTypes);
        JavaSymbol symbol = resolution.symbol();
        this.inferArgumentTypes(argTypes, resolution);
        ((IdentifierTreeImpl)identifier).setSymbol(symbol);
        TypeAndReferenceSolver.associateReference(identifier, symbol);
        return resolution;
    }

    private void inferArgumentTypes(List<JavaType> argTypes, Resolve.Resolution resolution) {
        Type formal = Symbols.unknownType;
        for (int i = 0; i < argTypes.size(); ++i) {
            JavaType arg = argTypes.get(i);
            if (resolution.symbol().isMethodSymbol()) {
                List<JavaType> resolvedFormals;
                int size = (resolvedFormals = ((MethodJavaType)resolution.type()).argTypes).size();
                formal = resolvedFormals.get(i < size ? i : size - 1);
            }
            if (!arg.isTagged(17)) continue;
            this.setInferedType(formal, (DeferredType)arg);
        }
    }

    @Override
    public void visitPrimitiveType(PrimitiveTypeTree tree) {
        Resolve.Env primitiveEnv = this.env;
        if (this.env == null) {
            primitiveEnv = this.semanticModel.getEnv(tree);
        }
        this.registerType(tree, this.resolve.findIdent(primitiveEnv, tree.keyword().text(), 2).type());
    }

    @Override
    public void visitVariable(VariableTree tree) {
        this.scan(tree.modifiers());
        JavaSymbol.VariableJavaSymbol variableSymbol = ((VariableTreeImpl)tree).getSymbol();
        TypeAndReferenceSolver.completeMetadata(variableSymbol, tree.modifiers().annotations());
        ExpressionTree initializer = tree.initializer();
        if (initializer != null) {
            this.resolveAs(initializer, 4);
            TypeTree typeTree = tree.type();
            JavaType initializerType = (JavaType)initializer.symbolType();
            if (initializerType.isTagged(17)) {
                this.setInferedType(typeTree.symbolType(), (DeferredType)initializer.symbolType());
            } else if (typeTree.is(Tree.Kind.VAR_TYPE)) {
                this.setInferedType(this.upwardProjection(initializerType), (DeferredType)typeTree.symbolType());
            }
        }
    }

    @Override
    public void visitForEachStatement(ForEachStatement tree) {
        this.scan(tree.variable());
        this.scan(tree.expression());
        TypeTree typeTree = tree.variable().type();
        if (typeTree.is(Tree.Kind.VAR_TYPE)) {
            JavaType iteratedObjectType = this.getIteratedObjectType((JavaType)tree.expression().symbolType());
            this.setInferedType(this.upwardProjection(iteratedObjectType), (DeferredType)typeTree.symbolType());
        }
        this.scan(tree.statement());
    }

    private JavaType getIteratedObjectType(JavaType type) {
        return this.getIteratedObjectType(type, new HashSet<String>());
    }

    private JavaType getIteratedObjectType(JavaType type, Set<String> knownTypes) {
        if (type.isUnknown()) {
            return Symbols.unknownType;
        }
        String fullyQualifiedName = type.fullyQualifiedName();
        if (knownTypes.contains(fullyQualifiedName)) {
            return Symbols.unknownType;
        }
        knownTypes.add(fullyQualifiedName);
        if (type.is("java.lang.Iterable")) {
            if (!type.isParameterized()) {
                return this.symbols.objectType;
            }
            ParametrizedTypeJavaType ptjt = (ParametrizedTypeJavaType)type;
            return ptjt.substitution(ptjt.typeParameters().get(0));
        }
        return type.directSuperTypes().stream().map(superType -> this.getIteratedObjectType((JavaType)superType, knownTypes)).filter(resolved -> !resolved.isUnknown()).findFirst().orElse(Symbols.unknownType);
    }

    private JavaType upwardProjection(JavaType initializerType) {
        if (initializerType.isTagged(16)) {
            WildCardType type = (WildCardType)initializerType;
            switch (type.boundType) {
                case UNBOUNDED: {
                    return this.symbols.objectType;
                }
                case EXTENDS: {
                    return type.bound;
                }
                case SUPER: {
                    return this.symbols.objectType;
                }
            }
        }
        if (initializerType.isTagged(15)) {
            return initializerType.erasure();
        }
        return initializerType;
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        this.resolveAs(tree.variable(), 4);
        this.resolveAs(tree.expression(), 4);
        JavaType type = this.getType(tree.variable());
        if (((JavaType)tree.expression().symbolType()).isTagged(17)) {
            this.setInferedType(type, (DeferredType)tree.expression().symbolType());
        }
        this.registerType(tree, type);
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        JavaType type = this.typesOfLiterals.get((Object)tree.kind());
        this.registerType(tree, type);
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        this.resolveAs(tree.expression(), 4);
        JavaType type = this.getType(tree.expression());
        if (type.isPrimitiveWrapper()) {
            type = type.primitiveType;
        }
        if (type.isNumerical() && type != this.symbols.longType && type != this.symbols.doubleType && type != this.symbols.floatType) {
            type = this.symbols.intType;
        }
        this.registerType(tree, type);
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        if (this.getType(tree.type()) == null) {
            this.resolveAs(tree.type(), 2);
        }
        this.scan(tree.annotations());
        this.registerType(tree, new ArrayJavaType(this.getType(tree.type()), this.symbols.arrayClass));
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        this.resolveAs(tree.type(), 2);
        for (Tree bound : tree.bounds()) {
            this.resolveAs(bound, 2);
        }
        this.resolveAs(tree.expression(), 4);
        JavaType castType = this.intersectionType(this.getType(tree.type()), tree.bounds().stream().map(b -> (JavaType)((ExpressionTree)b).symbolType()).collect(Collectors.toSet()), tree);
        Type expressionType = tree.expression().symbolType();
        if (expressionType instanceof DeferredType) {
            this.setInferedType(castType, (DeferredType)expressionType);
        }
        this.registerType(tree, castType);
    }

    private JavaType intersectionType(JavaType type, Set<JavaType> interfaces, Tree tree) {
        if (interfaces.isEmpty()) {
            return type;
        }
        ArrayList<String> names = new ArrayList<String>();
        names.add(type.name());
        names.addAll(interfaces.stream().map(JavaType::name).collect(Collectors.toSet()));
        JavaSymbol.TypeJavaSymbol typeJavaSymbol = new JavaSymbol.TypeJavaSymbol(0, "<intersectionType of " + names.stream().collect(Collectors.joining(" & ")) + ">", this.semanticModel.getEnv((Tree)tree).packge);
        typeJavaSymbol.members = new Scope(typeJavaSymbol);
        IntersectionType intersectionType = new IntersectionType(typeJavaSymbol);
        typeJavaSymbol.type = intersectionType;
        HashSet<JavaType> superInterfaces = new HashSet<JavaType>(interfaces);
        if (type.symbol.isInterface()) {
            superInterfaces.add(type);
            intersectionType.supertype = this.symbols.objectType;
        } else {
            intersectionType.supertype = type;
        }
        intersectionType.interfaces = ImmutableList.builder().addAll(superInterfaces).build();
        return intersectionType;
    }

    @Override
    public void visitUnionType(UnionTypeTree tree) {
        this.resolveAs((List<? extends Tree>)tree.typeAlternatives(), 2);
        ImmutableSet.Builder uniontype = ImmutableSet.builder();
        for (TypeTree typeTree : tree.typeAlternatives()) {
            uniontype.add((Object)typeTree.symbolType());
        }
        this.registerType(tree, (JavaType)this.resolve.leastUpperBound((Set<Type>)uniontype.build()));
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.scan(tree.modifiers());
        NewClassTree newClassTree = tree.initializer();
        this.scan(newClassTree.enclosingExpression());
        this.registerType(newClassTree.identifier(), ((VariableTreeImpl)((Object)tree)).getSymbol().getType());
        this.scan(newClassTree.typeArguments());
        this.scan(newClassTree.arguments());
        ClassTree classBody = newClassTree.classBody();
        if (classBody != null) {
            this.scan(classBody);
            ((ClassJavaType)classBody.symbol().type()).supertype = this.getType(newClassTree.identifier());
        }
        this.resolveConstructorSymbol(tree.simpleName(), newClassTree.identifier().symbolType(), this.semanticModel.getEnv(tree), TypeAndReferenceSolver.getParameterTypes(newClassTree.arguments()));
    }

    @Override
    public void visitAnnotation(AnnotationTree tree) {
        if (((AbstractTypedTree)((Object)tree.annotationType())).isTypeSet()) {
            return;
        }
        this.resolveAs(tree.annotationType(), 2);
        Arguments arguments = tree.arguments();
        if (arguments.size() > 1 || !arguments.isEmpty() && ((ExpressionTree)arguments.get(0)).is(Tree.Kind.ASSIGNMENT)) {
            for (ExpressionTree expressionTree : arguments) {
                AssignmentExpressionTree aet = (AssignmentExpressionTree)expressionTree;
                IdentifierTree variable = (IdentifierTree)aet.variable();
                JavaSymbol identInType = this.resolve.findMethod(this.semanticModel.getEnv(tree), this.getType(tree.annotationType()), variable.name(), (List<JavaType>)ImmutableList.of()).symbol();
                TypeAndReferenceSolver.associateReference(variable, identInType);
                JavaType type = identInType.type;
                if (type == null) {
                    type = Symbols.unknownType;
                }
                this.registerType(variable, type);
                this.resolveAs(aet.expression(), 4);
            }
        } else {
            for (ExpressionTree expressionTree : arguments) {
                this.resolveAs(expressionTree, 4);
            }
        }
        this.registerType(tree, this.getType(tree.annotationType()));
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        this.resolveAs(tree, 4);
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        if (!((AbstractTypedTree)((Object)tree)).isTypeSet()) {
            this.resolveAs(tree, 4);
        }
    }

    @Override
    public void visitMethodReference(MethodReferenceTree methodReferenceTree) {
        MethodReferenceTreeImpl methodRefTree = (MethodReferenceTreeImpl)methodReferenceTree;
        if (methodRefTree.isTypeSet() && methodReferenceTree.typeArguments() == null) {
            this.resolve.getSamMethod((JavaType)methodRefTree.symbolType()).ifPresent(samMethod -> this.resolveMethodReference((JavaSymbol.MethodJavaSymbol)samMethod, methodRefTree));
        } else {
            this.scan(methodReferenceTree.typeArguments());
            this.resolveAs(methodReferenceTree.expression(), 6);
            this.registerType(methodRefTree, this.symbols.deferedType(methodRefTree));
        }
    }

    private void resolveMethodReference(JavaSymbol.MethodJavaSymbol samMethod, MethodReferenceTreeImpl methodRefTree) {
        JavaType methodRefType = (JavaType)methodRefTree.symbolType();
        JavaType samReturnType = (JavaType)samMethod.returnType().type();
        List<JavaType> samMethodArgs = this.resolve.findSamMethodArgs(methodRefType);
        Resolve.Resolution resolution = this.resolve.findMethodReference(this.semanticModel.getEnv(methodRefTree), samMethodArgs, methodRefTree);
        JavaSymbol methodSymbol = resolution.symbol();
        if (methodSymbol.isMethodSymbol()) {
            IdentifierTree methodIdentifier = methodRefTree.method();
            TypeAndReferenceSolver.addMethodRefReference(methodIdentifier, methodSymbol);
            TypeAndReferenceSolver.setMethodRefType(methodRefTree, methodRefType, resolution.type());
            JavaType capturedReturnType = this.resolve.resolveTypeSubstitution(samReturnType, methodRefType);
            JavaType refinedReturnType = ((MethodJavaType)methodIdentifier.symbolType()).resultType();
            if ("<init>".equals(methodSymbol.name)) {
                refinedReturnType = this.refinedTypeForConstructor(capturedReturnType, refinedReturnType);
            }
            if (refinedReturnType instanceof DeferredType) {
                ((DeferredType)refinedReturnType).setTree((AbstractTypedTree)((Object)methodRefTree.method()));
            }
            this.refineType(methodRefTree, methodRefType, capturedReturnType, refinedReturnType);
        } else {
            this.handleNewArray(methodRefTree, methodRefType, samReturnType);
        }
    }

    private static void addMethodRefReference(IdentifierTree methodIdentifier, JavaSymbol methodSymbol) {
        ((IdentifierTreeImpl)methodIdentifier).setSymbol(methodSymbol);
        methodSymbol.addUsage(methodIdentifier);
    }

    private static void setMethodRefType(MethodReferenceTree methodRef, JavaType methodRefType, JavaType methodType) {
        ((AbstractTypedTree)((Object)methodRef)).setType(methodRefType);
        ((AbstractTypedTree)((Object)methodRef.method())).setType(methodType);
    }

    private JavaType refinedTypeForConstructor(JavaType capturedReturnType, JavaType refinedReturnType) {
        JavaType sanitizedCaptured = capturedReturnType;
        JavaType refinedConstructorType = refinedReturnType;
        if (refinedConstructorType.symbol().isTypeSymbol() && !((JavaSymbol.TypeJavaSymbol)refinedConstructorType.symbol()).typeParameters().scopeSymbols().isEmpty()) {
            refinedConstructorType = this.parametrizedTypeCache.getParametrizedTypeType(refinedConstructorType.symbol, new TypeSubstitution());
        }
        if (sanitizedCaptured.isTagged(15)) {
            sanitizedCaptured = ((TypeVariableJavaType)sanitizedCaptured).bounds.get(0);
        }
        if (refinedConstructorType.isParameterized()) {
            refinedConstructorType = this.resolve.resolveTypeSubstitutionWithDiamondOperator((ParametrizedTypeJavaType)refinedConstructorType, sanitizedCaptured);
        }
        return refinedConstructorType;
    }

    private void handleNewArray(MethodReferenceTree methodReferenceTree, JavaType methodRefType, JavaType samReturnType) {
        JavaType expressionType = this.getType(methodReferenceTree.expression());
        if (expressionType != null && expressionType.isArray() && "new".equals(methodReferenceTree.method().name())) {
            JavaType capturedReturnType = this.resolve.resolveTypeSubstitution(samReturnType, methodRefType);
            this.refineType((MethodReferenceTreeImpl)methodReferenceTree, methodRefType, capturedReturnType, expressionType);
        }
    }

    @Override
    public void visitOther(Tree tree) {
        this.registerType(tree, Symbols.unknownType);
    }

    @VisibleForTesting
    JavaType getType(Tree tree) {
        return this.types.get(tree);
    }

    private void registerType(Tree tree, JavaType type) {
        if (AbstractTypedTree.class.isAssignableFrom(tree.getClass())) {
            ((AbstractTypedTree)tree).setType(type);
        }
        this.types.put(tree, type);
    }

    private static void associateReference(IdentifierTree tree, JavaSymbol symbol) {
        if (symbol.kind < 64) {
            ((IdentifierTreeImpl)tree).setSymbol(symbol);
            symbol.addUsage(tree);
        }
    }
}

