/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterators;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.AnalysisException;
import org.sonar.java.bytecode.loader.AarLoader;
import org.sonar.java.bytecode.loader.FileSystemLoader;
import org.sonar.java.bytecode.loader.JarLoader;
import org.sonar.java.bytecode.loader.Loader;
import org.sonar.java.resolve.Convert;

public class SquidClassLoader
extends ClassLoader
implements Closeable {
    private static final Logger LOG = Loggers.get(SquidClassLoader.class);
    private final List<Loader> loaders = new ArrayList<Loader>();
    private final LoadingCache<String, Optional<Loader>> loaderCache;

    public SquidClassLoader(List<File> files) {
        super(SquidClassLoader.computeParent());
        for (File file : files) {
            if (!file.exists()) continue;
            try {
                if (file.isDirectory()) {
                    this.loaders.add(new FileSystemLoader(file));
                    continue;
                }
                if (file.getName().endsWith(".jar")) {
                    this.loaders.add(new JarLoader(file));
                    continue;
                }
                if (!file.getName().endsWith(".aar")) continue;
                this.loaders.add(new AarLoader(file));
            }
            catch (IllegalStateException e) {
                LOG.warn("Unable to load classes from '{}'", (Object)file.getPath());
                LOG.debug("{}: {}", (Object)e.getMessage(), (Object)e.getCause().getMessage());
            }
        }
        this.loaderCache = CacheBuilder.newBuilder().maximumSize(5000L).build((CacheLoader)new CacheLoader<String, Optional<Loader>>(){

            public Optional<Loader> load(String key) {
                return SquidClassLoader.this.findLoaderWithResource(key);
            }
        });
    }

    private static ClassLoader computeParent() {
        try {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String resourceName = name.replace('.', '/') + ".class";
        for (Loader loader : this.loaders) {
            byte[] classBytes = loader.loadBytes(resourceName);
            if (!ArrayUtils.isNotEmpty((byte[])classBytes)) continue;
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL findResource(String name) {
        try {
            return ((Optional)this.loaderCache.get((Object)name)).map(loader -> loader.findResource(name)).orElse(null);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    private Optional<Loader> findLoaderWithResource(String resourceName) {
        for (Loader loader : this.loaders) {
            URL url = loader.findResource(resourceName);
            if (url == null) continue;
            return Optional.of(loader);
        }
        return Optional.empty();
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Loader loader : this.loaders) {
            URL url = loader.findResource(name);
            if (url == null) continue;
            result.add(url);
        }
        return Iterators.asEnumeration(result.iterator());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public byte[] getBytesForClass(String className) {
        try (InputStream is = this.getResourceAsStream(Convert.bytecodeName(className) + ".class");){
            if (is == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new AnalysisException("An IOException occurred in SonarJava classLoader.", e);
        }
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.findResource(name);
        if (url == null) {
            return super.getResource(name);
        }
        return url;
    }

    @Override
    public void close() {
        for (Loader loader : this.loaders) {
            loader.close();
        }
    }
}

