/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.se.CheckerContext;
import org.sonar.java.se.FlowComputation;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.checks.CheckerTreeNodeVisitor;
import org.sonar.java.se.checks.SECheck;
import org.sonar.java.se.checks.XxeProperty;
import org.sonar.java.se.constraint.Constraint;
import org.sonar.java.se.constraint.ConstraintManager;
import org.sonar.java.se.constraint.ConstraintsByDomain;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2755")
public class XxeProcessingCheck
extends SECheck {
    private static final String BOOLEAN = "boolean";
    private static final String NEW_INSTANCE = "newInstance";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String XML_INPUT_FACTORY = "javax.xml.stream.XMLInputFactory";
    private static final MethodMatchers XML_INPUT_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofTypes("javax.xml.stream.XMLInputFactory").names("newInstance", "newFactory").withAnyParameters().build();
    private static final String DOCUMENT_BUILDER_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final MethodMatchers DOCUMENT_BUILDER_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofTypes("javax.xml.parsers.DocumentBuilderFactory").names("newInstance").withAnyParameters().build();
    private static final String SAX_PARSER_FACTORY = "javax.xml.parsers.SAXParserFactory";
    private static final String SAX_PARSER = "javax.xml.parsers.SAXParser";
    private static final MethodMatchers SAX_PARSER_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofTypes("javax.xml.parsers.SAXParserFactory").names("newInstance").withAnyParameters().build();
    private static final String SCHEMA_FACTORY = "javax.xml.validation.SchemaFactory";
    private static final MethodMatchers SCHEMA_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofTypes("javax.xml.validation.SchemaFactory").names("newInstance").withAnyParameters().build();
    private static final String VALIDATOR = "javax.xml.validation.Validator";
    private static final String TRANSFORMER_FACTORY = "javax.xml.transform.TransformerFactory";
    private static final MethodMatchers TRANSFORMER_FACTORY_NEW_INSTANCE = MethodMatchers.create().ofSubTypes("javax.xml.transform.TransformerFactory").names("newInstance").withAnyParameters().build();
    private static final String XML_READER = "org.xml.sax.XMLReader";
    private static final MethodMatchers CREATE_XML_READER = MethodMatchers.create().ofTypes("org.xml.sax.helpers.XMLReaderFactory").names("createXMLReader").withAnyParameters().build();
    private static final String SAX_BUILDER = "org.jdom2.input.SAXBuilder";
    private static final MethodMatchers SAX_BUILDER_CONSTRUCTOR = MethodMatchers.create().ofTypes("org.jdom2.input.SAXBuilder").constructor().withAnyParameters().build();
    private static final String SAX_READER = "org.dom4j.io.SAXReader";
    private static final MethodMatchers SAX_READER_CONSTRUCTOR = MethodMatchers.create().ofTypes("org.dom4j.io.SAXReader").constructor().withAnyParameters().build();
    private static final Map<MethodMatchers, Predicate<ConstraintsByDomain>> CONDITIONS_FOR_SECURED_BY_TYPE = ImmutableMap.builder().put((Object)XML_INPUT_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureSupportDtd.SECURED) || c.hasConstraint(XxeProperty.FeatureIsSupportingExternalEntities.SECURED)).put((Object)DOCUMENT_BUILDER_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeProperty.FeatureLoadExternalDtd.SECURED) || c.hasConstraint(XxeProperty.FeatureExternalGeneralEntities.SECURED)).put((Object)SAX_PARSER_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeProperty.FeatureExternalGeneralEntities.SECURED)).put((Object)SCHEMA_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED)).put((Object)TRANSFORMER_FACTORY_NEW_INSTANCE, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeStyleSheet.SECURED)).put((Object)CREATE_XML_READER, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeProperty.FeatureExternalGeneralEntities.SECURED)).build();
    private static final Map<MethodMatchers, Predicate<ConstraintsByDomain>> CONDITIONS_FOR_SECURED_BY_TYPE_NEW_CLASS = ImmutableMap.of((Object)SAX_BUILDER_CONSTRUCTOR, c -> c.hasConstraint(XxeProperty.AttributeDTD.SECURED) && c.hasConstraint(XxeProperty.AttributeSchema.SECURED) || c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED), (Object)SAX_READER_CONSTRUCTOR, c -> c.hasConstraint(XxeProperty.FeatureDisallowDoctypeDecl.SECURED) || c.hasConstraint(XxeProperty.FeatureExternalGeneralEntities.SECURED));
    private static final MethodMatchers FEATURES_AND_PROPERTIES_SETTERS = MethodMatchers.or(MethodMatchers.create().ofSubTypes("javax.xml.parsers.DocumentBuilderFactory", "javax.xml.transform.TransformerFactory").names("setAttribute").addParametersMatcher("java.lang.String", "java.lang.Object").build(), MethodMatchers.create().ofSubTypes("javax.xml.stream.XMLInputFactory", "javax.xml.parsers.SAXParser", "javax.xml.validation.SchemaFactory", "javax.xml.validation.Validator", "org.xml.sax.XMLReader", "org.jdom2.input.SAXBuilder").names("setProperty").addParametersMatcher("java.lang.String", "java.lang.Object").build(), MethodMatchers.create().ofSubTypes("javax.xml.parsers.DocumentBuilderFactory", "javax.xml.parsers.SAXParserFactory", "org.xml.sax.XMLReader", "org.jdom2.input.SAXBuilder", "org.dom4j.io.SAXReader").names("setFeature").addParametersMatcher("java.lang.String", "boolean").build());
    private static final MethodMatchers TRANSFERRING_METHOD_CALLS = MethodMatchers.or(MethodMatchers.create().ofTypes("javax.xml.parsers.SAXParserFactory").names("newSAXParser").withAnyParameters().build(), MethodMatchers.create().ofTypes("javax.xml.validation.SchemaFactory").names("newSchema").withAnyParameters().build(), MethodMatchers.create().ofTypes("javax.xml.validation.Schema").names("newValidator").withAnyParameters().build(), MethodMatchers.create().ofTypes("javax.xml.parsers.SAXParser").names("getXMLReader").withAnyParameters().build());
    private static final MethodMatchers PARSING_METHODS = MethodMatchers.or(MethodMatchers.create().ofSubTypes("javax.xml.parsers.DocumentBuilderFactory").names("newDocumentBuilder").addWithoutParametersMatcher().build(), MethodMatchers.create().ofSubTypes("javax.xml.transform.TransformerFactory").names("newTransformer").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("javax.xml.stream.XMLInputFactory").name(n -> n.startsWith("create")).withAnyParameters().build(), MethodMatchers.create().ofSubTypes("javax.xml.validation.Validator").names("validate").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("javax.xml.parsers.SAXParser").names("parse").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("org.xml.sax.XMLReader").names("parse").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("org.jdom2.input.SAXBuilder").names("build").withAnyParameters().build(), MethodMatchers.create().ofSubTypes("org.dom4j.io.SAXReader").names("read").withAnyParameters().build());
    private static final List<XxeProperty> PROPERTIES_TO_CHECK = ImmutableList.builder().add((Object[])XxeProperty.FeatureSupportDtd.values()).add((Object[])XxeProperty.FeatureIsSupportingExternalEntities.values()).add((Object[])XxeProperty.FeatureDisallowDoctypeDecl.values()).add((Object[])XxeProperty.FeatureExternalGeneralEntities.values()).add((Object[])XxeProperty.FeatureLoadExternalDtd.values()).add((Object[])XxeProperty.AttributeDTD.values()).add((Object[])XxeProperty.AttributeSchema.values()).add((Object[])XxeProperty.AttributeStyleSheet.values()).build();
    private static final List<Class<? extends Constraint>> FLOW_CONSTRAINT_DOMAIN = ImmutableList.builder().add(XxeProperty.AttributeDTD.class).add(XxeProperty.AttributeSchema.class).add(XxeProperty.AttributeStyleSheet.class).build();

    @Override
    public ProgramState checkPreStatement(CheckerContext context, Tree syntaxNode) {
        PreStatementVisitor visitor = new PreStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    @Override
    public ProgramState checkPostStatement(CheckerContext context, Tree syntaxNode) {
        PostStatementVisitor visitor = new PostStatementVisitor(context);
        syntaxNode.accept(visitor);
        return visitor.programState;
    }

    private static ProgramState addNamedConstraint(@Nullable ExpressionTree expressionTree, ProgramState state) {
        Optional<String> value;
        SymbolicValue sv;
        if (expressionTree != null && (sv = state.peekValue()) != null && (value = expressionTree.asConstant(String.class)).isPresent()) {
            for (XxeProperty property : PROPERTIES_TO_CHECK) {
                if (!property.isNamed(value.get())) continue;
                return state.addConstraint(sv, property.namedConstraint());
            }
        }
        return state;
    }

    @Override
    public void checkEndOfExecutionPath(CheckerContext context, ConstraintManager constraintManager) {
        ProgramState endState = context.getState();
        if (endState.exitingOnRuntimeException()) {
            return;
        }
        SymbolicValue peek = endState.peekValue();
        if (peek instanceof XxeSymbolicValue) {
            XxeSymbolicValue xxeSV = (XxeSymbolicValue)peek;
            this.reportIfNotSecured(context, xxeSV, endState.getConstraints(xxeSV));
        }
    }

    private void reportIfNotSecured(CheckerContext context, XxeSymbolicValue xxeSV, @Nullable ConstraintsByDomain constraintsByDomain) {
        if (!xxeSV.isField && !XxeProcessingCheck.isSecuredByProperty(xxeSV, constraintsByDomain)) {
            context.reportIssue(xxeSV.init, this, "Disable access to external entities in XML parsing.", FlowComputation.flowWithoutExceptions(context.getNode(), xxeSV, c -> c == XxeProperty.AttributeDTD.UNSECURED || c == XxeProperty.AttributeSchema.UNSECURED || c == XxeProperty.AttributeStyleSheet.UNSECURED, FLOW_CONSTRAINT_DOMAIN));
        }
    }

    private static boolean isSecuredByProperty(XxeSymbolicValue sv, @Nullable ConstraintsByDomain constraintsByDomain) {
        return constraintsByDomain == null || sv.conditionForSecured.test(constraintsByDomain);
    }

    private static class XxeSymbolicValue
    extends SymbolicValue {
        private final Tree init;
        private final Predicate<ConstraintsByDomain> conditionForSecured;
        private boolean isField;

        private XxeSymbolicValue(Tree init, Predicate<ConstraintsByDomain> conditionForSecured) {
            this.init = init;
            this.isField = false;
            this.conditionForSecured = conditionForSecured;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XxeSymbolicValue that = (XxeSymbolicValue)o;
            return this.isField == that.isField && this.init.equals(that.init) && this.conditionForSecured.equals(that.conditionForSecured);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.init, this.conditionForSecured, this.isField);
        }

        public void setField(boolean isField) {
            this.isField = isField;
        }
    }

    private static enum XxeSensitive implements Constraint
    {
        SENSITIVE;

    }

    private static class PostStatementVisitor
    extends CheckerTreeNodeVisitor {
        private PostStatementVisitor(CheckerContext context) {
            super(context.getState());
        }

        @Override
        public void visitNewClass(NewClassTree newClass) {
            SymbolicValue peek = this.programState.peekValue();
            if (peek != null && CONDITIONS_FOR_SECURED_BY_TYPE_NEW_CLASS.keySet().stream().anyMatch(mm -> mm.matches(newClass))) {
                this.programState = this.programState.addConstraint(peek, XxeSensitive.SENSITIVE);
            }
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree mit) {
            SymbolicValue peek = this.programState.peekValue();
            if (peek != null && CONDITIONS_FOR_SECURED_BY_TYPE.keySet().stream().anyMatch(mm -> mm.matches(mit))) {
                this.programState = this.programState.addConstraint(peek, XxeSensitive.SENSITIVE);
            }
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ProgramState.SymbolicValueSymbol peek = this.programState.peekValueSymbol();
            Symbol symbol = peek.symbol();
            SymbolicValue sv = peek.symbolicValue();
            if (symbol != null && sv instanceof XxeSymbolicValue) {
                ((XxeSymbolicValue)sv).setField(ProgramState.isField(symbol));
            }
            this.programState = XxeProcessingCheck.addNamedConstraint(tree.expression(), this.programState);
        }
    }

    private class PreStatementVisitor
    extends CheckerTreeNodeVisitor {
        private final ConstraintManager constraintManager;
        private final CheckerContext context;

        private PreStatementVisitor(CheckerContext context) {
            super(context.getState());
            this.constraintManager = context.getConstraintManager();
            this.context = context;
        }

        @Override
        public void visitNewClass(NewClassTree newClass) {
            for (Map.Entry entry : CONDITIONS_FOR_SECURED_BY_TYPE_NEW_CLASS.entrySet()) {
                if (!((MethodMatchers)entry.getKey()).matches(newClass)) continue;
                this.constraintManager.setValueFactory(() -> new XxeSymbolicValue(newClass.identifier(), (Predicate)entry.getValue()));
                break;
            }
        }

        @Override
        public void visitVariable(VariableTree tree) {
            this.programState = XxeProcessingCheck.addNamedConstraint(tree.initializer(), this.programState);
        }

        @Override
        public void visitMethodInvocation(MethodInvocationTree mit) {
            SymbolicValue peek;
            for (Map.Entry entry : CONDITIONS_FOR_SECURED_BY_TYPE.entrySet()) {
                if (!((MethodMatchers)entry.getKey()).matches(mit)) continue;
                this.constraintManager.setValueFactory(() -> new XxeSymbolicValue(ExpressionUtils.methodName(mit), (Predicate)entry.getValue()));
                break;
            }
            if (TRANSFERRING_METHOD_CALLS.matches(mit)) {
                this.constraintManager.setValueFactory(() -> this.programState.peekValue(mit.arguments().size()));
            } else if (FEATURES_AND_PROPERTIES_SETTERS.matches(mit)) {
                Arguments arguments = mit.arguments();
                for (XxeProperty property : PROPERTIES_TO_CHECK) {
                    this.programState = this.checkArguments(this.programState, arguments, property);
                }
            }
            if (PARSING_METHODS.matches(mit) && (peek = this.programState.peekValue(mit.arguments().size())) instanceof XxeSymbolicValue) {
                XxeSymbolicValue xxeSymbolicValue = (XxeSymbolicValue)peek;
                XxeProcessingCheck.this.reportIfNotSecured(this.context, xxeSymbolicValue, this.programState.getConstraints(xxeSymbolicValue));
            }
        }

        private ProgramState checkArguments(ProgramState state, Arguments arguments, XxeProperty property) {
            if (this.isSettingProperty(state, (ExpressionTree)arguments.get(0), property)) {
                ExpressionTree arg1;
                SymbolicValue sv1 = state.peekValue();
                if (property.isSecuring(sv1, arg1 = (ExpressionTree)arguments.get(1))) {
                    return state.addConstraint(state.peekValue(2), property.securedConstraint());
                }
                if (property.isUnsecuring(sv1, arg1)) {
                    return state.addConstraint(state.peekValue(2), property.unsecuredConstraint());
                }
            }
            return state;
        }

        boolean isSettingProperty(ProgramState state, ExpressionTree arg0, XxeProperty property) {
            if (arg0.asConstant(String.class).filter(property::isNamed).isPresent()) {
                return true;
            }
            ConstraintsByDomain constraintsByDomain = state.getConstraints(state.peekValue(1));
            return constraintsByDomain != null && constraintsByDomain.hasConstraint(property.namedConstraint());
        }
    }
}

