/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.FileLinesVisitor;
import org.sonar.java.ast.visitors.SyntaxHighlighterVisitor;
import org.sonar.java.filters.SonarJavaIssueFilter;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.se.SymbolicExecutionMode;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.plugins.java.api.JavaVersion;

public class JavaSquid {
    private static final Logger LOG = Loggers.get(JavaSquid.class);
    private final JavaAstScanner astScanner;
    private final JavaAstScanner astScannerForTests;
    private final JavaAstScanner astScannerForGeneratedFiles;

    public JavaSquid(JavaVersion javaVersion, @Nullable SonarComponents sonarComponents, @Nullable Measurer measurer, JavaResourceLocator javaResourceLocator, @Nullable SonarJavaIssueFilter postAnalysisIssueFilter, JavaCheck ... visitors) {
        this(javaVersion, false, sonarComponents, measurer, javaResourceLocator, postAnalysisIssueFilter, visitors);
    }

    public JavaSquid(JavaVersion javaVersion, boolean xFileEnabled, @Nullable SonarComponents sonarComponents, @Nullable Measurer measurer, JavaResourceLocator javaResourceLocator, @Nullable SonarJavaIssueFilter postAnalysisIssueFilter, JavaCheck ... visitors) {
        ArrayList commonVisitors = Lists.newArrayList((Object[])new JavaCheck[]{javaResourceLocator});
        if (postAnalysisIssueFilter != null) {
            commonVisitors.add(postAnalysisIssueFilter);
        }
        Iterable codeVisitors = Iterables.concat((Iterable)commonVisitors, Arrays.asList(visitors));
        ArrayList testCodeVisitors = Lists.newArrayList((Iterable)commonVisitors);
        if (measurer != null) {
            List<Measurer> measurers = Collections.singletonList(measurer);
            codeVisitors = Iterables.concat(measurers, (Iterable)codeVisitors);
            testCodeVisitors.add(new Measurer.TestFileMeasurer(measurer));
        }
        ArrayList<File> classpath = new ArrayList();
        ArrayList<File> testClasspath = new ArrayList();
        ArrayList<JavaCheck> jspCodeVisitors = new ArrayList();
        ArrayList<File> jspClasspath = new ArrayList();
        if (sonarComponents != null) {
            if (!sonarComponents.isSonarLintContext()) {
                codeVisitors = Iterables.concat((Iterable)codeVisitors, Arrays.asList(new FileLinesVisitor(sonarComponents), new SyntaxHighlighterVisitor(sonarComponents)));
                testCodeVisitors.add(new SyntaxHighlighterVisitor(sonarComponents));
            }
            classpath = sonarComponents.getJavaClasspath();
            testClasspath = sonarComponents.getJavaTestClasspath();
            jspClasspath = sonarComponents.getJspClasspath();
            testCodeVisitors.addAll(sonarComponents.testCheckClasses());
            jspCodeVisitors = sonarComponents.jspCodeVisitors();
        }
        this.astScanner = new JavaAstScanner(sonarComponents);
        this.astScanner.setVisitorBridge(JavaSquid.createVisitorBridge(codeVisitors, classpath, javaVersion, sonarComponents, SymbolicExecutionMode.getMode(visitors, xFileEnabled)));
        this.astScannerForTests = new JavaAstScanner(sonarComponents);
        this.astScannerForTests.setVisitorBridge(JavaSquid.createVisitorBridge(testCodeVisitors, testClasspath, javaVersion, sonarComponents, SymbolicExecutionMode.DISABLED));
        this.astScannerForGeneratedFiles = new JavaAstScanner(sonarComponents);
        this.astScannerForGeneratedFiles.setVisitorBridge(JavaSquid.createVisitorBridge(jspCodeVisitors, jspClasspath, javaVersion, sonarComponents, SymbolicExecutionMode.DISABLED));
    }

    private static VisitorsBridge createVisitorBridge(Iterable<JavaCheck> codeVisitors, List<File> classpath, JavaVersion javaVersion, @Nullable SonarComponents sonarComponents, SymbolicExecutionMode symbolicExecutionMode) {
        VisitorsBridge visitorsBridge = new VisitorsBridge(codeVisitors, classpath, sonarComponents, symbolicExecutionMode);
        visitorsBridge.setJavaVersion(javaVersion);
        return visitorsBridge;
    }

    public void scan(Iterable<InputFile> sourceFiles, Iterable<InputFile> testFiles, Iterable<? extends InputFile> generatedFiles) {
        this.scanSources(sourceFiles);
        this.scanTests(testFiles);
        this.scanGeneratedFiles(generatedFiles);
    }

    private void scanSources(Iterable<InputFile> sourceFiles) {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Java Main Files AST scan");
        this.astScanner.scan(sourceFiles);
        profiler.stopInfo();
    }

    private void scanTests(Iterable<InputFile> testFiles) {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Java Test Files AST scan");
        this.astScannerForTests.scan(testFiles);
        profiler.stopInfo();
    }

    private void scanGeneratedFiles(Iterable<? extends InputFile> generatedFiles) {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Java Generated Files AST scan");
        this.astScannerForGeneratedFiles.scan(generatedFiles);
        profiler.stopInfo();
    }
}

