/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.java.AnalysisException;
import org.sonar.java.CheckFailureException;
import org.sonar.java.EndOfAnalysisCheck;
import org.sonar.java.ExceptionHandler;
import org.sonar.java.IllegalRuleParameterException;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.visitors.SonarSymbolTableVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.model.DefaultJavaFileScannerContext;
import org.sonar.java.model.GeneratedFile;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.Sema;
import org.sonar.java.se.SymbolicExecutionMode;
import org.sonar.java.se.SymbolicExecutionVisitor;
import org.sonar.java.se.xproc.BehaviorCache;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

public class VisitorsBridge {
    private static final Logger LOG = Loggers.get(VisitorsBridge.class);
    private final BehaviorCache behaviorCache;
    private final List<JavaFileScanner> allScanners = new ArrayList<JavaFileScanner>();
    private List<JavaFileScanner> executableScanners;
    private final SonarComponents sonarComponents;
    private final boolean symbolicExecutionEnabled;
    protected InputFile currentFile;
    protected JavaVersion javaVersion;
    private final List<File> classpath;
    private final SquidClassLoader classLoader;
    private IssuableSubsciptionVisitorsRunner issuableSubscriptionVisitorsRunner;
    private static final Predicate<JavaFileScanner> IS_ISSUABLE_SUBSCRIPTION_VISITOR = IssuableSubscriptionVisitor.class::isInstance;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(Collections.singletonList(visitor), new ArrayList<File>(), null);
    }

    @VisibleForTesting
    public VisitorsBridge(Iterable<? extends JavaCheck> visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents) {
        this(visitors, projectClasspath, sonarComponents, SymbolicExecutionMode.DISABLED);
    }

    public VisitorsBridge(Iterable<? extends JavaCheck> visitors, List<File> projectClasspath, @Nullable SonarComponents sonarComponents, SymbolicExecutionMode symbolicExecutionMode) {
        for (JavaCheck javaCheck : visitors) {
            if (!(javaCheck instanceof JavaFileScanner)) continue;
            this.allScanners.add((JavaFileScanner)javaCheck);
        }
        this.classpath = projectClasspath;
        this.executableScanners = this.allScanners.stream().filter(IS_ISSUABLE_SUBSCRIPTION_VISITOR.negate()).collect(Collectors.toList());
        this.issuableSubscriptionVisitorsRunner = new IssuableSubsciptionVisitorsRunner(this.allScanners);
        this.sonarComponents = sonarComponents;
        this.classLoader = ClassLoaderBuilder.create(projectClasspath);
        this.symbolicExecutionEnabled = symbolicExecutionMode.isEnabled();
        this.behaviorCache = new BehaviorCache(this.classLoader, symbolicExecutionMode.isCrossFileEnabled());
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public List<File> getClasspath() {
        return this.classpath;
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
        List<JavaFileScanner> scannersForJavaVersion = VisitorsBridge.executableScanners(this.allScanners, javaVersion);
        this.executableScanners = scannersForJavaVersion.stream().filter(IS_ISSUABLE_SUBSCRIPTION_VISITOR.negate()).collect(Collectors.toList());
        this.issuableSubscriptionVisitorsRunner = new IssuableSubsciptionVisitorsRunner(scannersForJavaVersion);
    }

    public void visitFile(@Nullable Tree parsedTree) {
        boolean fileParsed;
        JavaTree.CompilationUnitTreeImpl tree = new JavaTree.CompilationUnitTreeImpl(null, new ArrayList<ImportClauseTree>(), new ArrayList<Tree>(), null, null);
        boolean bl = fileParsed = parsedTree != null;
        if (fileParsed && parsedTree.is(Tree.Kind.COMPILATION_UNIT)) {
            tree = (JavaTree.CompilationUnitTreeImpl)parsedTree;
            this.createSonarSymbolTable(tree);
        }
        JavaFileScannerContext javaFileScannerContext = this.createScannerContext(tree, tree.sema, this.sonarComponents, fileParsed);
        if (this.symbolicExecutionEnabled) {
            try {
                this.runScanner(javaFileScannerContext, (JavaFileScanner)new SymbolicExecutionVisitor(this.executableScanners, this.behaviorCache));
                this.behaviorCache.cleanup();
            }
            catch (CheckFailureException e) {
                this.interruptIfFailFast(e);
            }
        }
        for (JavaFileScanner scanner : this.executableScanners) {
            try {
                this.runScanner(javaFileScannerContext, scanner);
            }
            catch (CheckFailureException e) {
                this.interruptIfFailFast(e);
            }
        }
        try {
            this.issuableSubscriptionVisitorsRunner.run(javaFileScannerContext);
        }
        catch (CheckFailureException e) {
            this.interruptIfFailFast(e);
        }
    }

    private void interruptIfFailFast(CheckFailureException e) {
        if (this.sonarComponents != null && this.sonarComponents.shouldFailAnalysisOnException()) {
            throw new AnalysisException("Failing check", e);
        }
    }

    private void runScanner(JavaFileScannerContext javaFileScannerContext, JavaFileScanner scanner) throws CheckFailureException {
        this.runScanner(() -> scanner.scanFile(javaFileScannerContext), scanner);
    }

    private void runScanner(Runnable action, JavaFileScanner scanner) throws CheckFailureException {
        try {
            action.run();
        }
        catch (IllegalRuleParameterException e) {
            throw new AnalysisException("Bad configuration of rule parameter", e);
        }
        catch (Exception e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof InterruptedIOException || rootCause instanceof InterruptedException) {
                throw e;
            }
            String message = String.format("Unable to run check %s - %s on file '%s', To help improve the SonarSource Java Analyzer, please report this problem to SonarSource: see https://community.sonarsource.com/", scanner.getClass(), VisitorsBridge.ruleKey(scanner), this.currentFile);
            LOG.error(message, (Throwable)e);
            throw new CheckFailureException(message, e);
        }
    }

    private static String ruleKey(JavaFileScanner scanner) {
        Rule annotation = (Rule)AnnotationUtils.getAnnotation(scanner.getClass(), Rule.class);
        if (annotation != null) {
            return annotation.key();
        }
        return "";
    }

    private static List<JavaFileScanner> executableScanners(List<JavaFileScanner> scanners, JavaVersion javaVersion) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (JavaFileScanner scanner : scanners) {
            if (scanner instanceof JavaVersionAwareVisitor && !((JavaVersionAwareVisitor)((Object)scanner)).isCompatibleWithJavaVersion(javaVersion)) continue;
            results.add((Object)scanner);
        }
        return results.build();
    }

    protected JavaFileScannerContext createScannerContext(CompilationUnitTree tree, @Nullable Sema semanticModel, SonarComponents sonarComponents, boolean fileParsed) {
        return new DefaultJavaFileScannerContext(tree, this.currentFile, semanticModel, sonarComponents, this.javaVersion, fileParsed);
    }

    private void createSonarSymbolTable(CompilationUnitTree tree) {
        if (this.sonarComponents != null && !this.sonarComponents.isSonarLintContext() && !(this.currentFile instanceof GeneratedFile)) {
            SonarSymbolTableVisitor symVisitor = new SonarSymbolTableVisitor(this.sonarComponents.symbolizableFor(this.currentFile));
            symVisitor.visitCompilationUnit(tree);
        }
    }

    public void processRecognitionException(RecognitionException e, InputFile inputFile) {
        if (this.sonarComponents == null || !this.sonarComponents.reportAnalysisError(e, inputFile)) {
            this.visitFile(null);
            this.executableScanners.stream().filter(scanner -> scanner instanceof ExceptionHandler).forEach(scanner -> ((ExceptionHandler)((Object)scanner)).processRecognitionException(e));
        }
    }

    public void setCurrentFile(InputFile inputFile) {
        this.currentFile = inputFile;
    }

    public void endOfAnalysis() {
        this.allScanners.stream().filter(s -> s instanceof EndOfAnalysisCheck).map(EndOfAnalysisCheck.class::cast).forEach(EndOfAnalysisCheck::endOfAnalysis);
        this.classLoader.close();
    }

    private class IssuableSubsciptionVisitorsRunner {
        private EnumMap<Tree.Kind, List<SubscriptionVisitor>> checks = new EnumMap(Tree.Kind.class);
        private List<SubscriptionVisitor> subscriptionVisitors;

        IssuableSubsciptionVisitorsRunner(List<JavaFileScanner> executableScanners) {
            this.subscriptionVisitors = executableScanners.stream().filter(IS_ISSUABLE_SUBSCRIPTION_VISITOR).map(SubscriptionVisitor.class::cast).collect(Collectors.toList());
            this.subscriptionVisitors.forEach(s -> s.nodesToVisit().forEach(k -> this.checks.computeIfAbsent((Tree.Kind)((Object)((Object)k)), key -> new ArrayList()).add(s)));
        }

        public void run(JavaFileScannerContext javaFileScannerContext) throws CheckFailureException {
            this.forEach(this.subscriptionVisitors, s -> s.setContext(javaFileScannerContext));
            this.visit(javaFileScannerContext.getTree());
            this.forEach(this.subscriptionVisitors, s -> s.leaveFile(javaFileScannerContext));
        }

        private void visitChildren(Tree tree) throws CheckFailureException {
            JavaTree javaTree = (JavaTree)tree;
            if (!javaTree.isLeaf()) {
                for (Tree next : javaTree.getChildren()) {
                    if (next == null) continue;
                    this.visit(next);
                }
            }
        }

        private void visit(Tree tree) throws CheckFailureException {
            Tree.Kind kind = tree.kind();
            List<SubscriptionVisitor> subscribed = this.checks.getOrDefault((Object)kind, Collections.emptyList());
            boolean isToken = kind == Tree.Kind.TOKEN;
            Consumer<SubscriptionVisitor> callback = isToken ? s -> s.visitToken((SyntaxToken)tree) : s -> s.visitNode(tree);
            this.forEach(subscribed, callback);
            if (isToken) {
                this.forEach(this.checks.getOrDefault((Object)Tree.Kind.TRIVIA, Collections.emptyList()), s -> ((SyntaxToken)tree).trivias().forEach(s::visitTrivia));
            } else {
                this.visitChildren(tree);
            }
            if (!isToken) {
                this.forEach(subscribed, s -> s.leaveNode(tree));
            }
        }

        private final void forEach(Collection<SubscriptionVisitor> visitors, Consumer<SubscriptionVisitor> callback) throws CheckFailureException {
            for (SubscriptionVisitor visitor : visitors) {
                VisitorsBridge.this.runScanner(() -> callback.accept(visitor), visitor);
            }
        }
    }
}

