/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.JavaFilesCache;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.classpath.ClasspathForMain;
import org.sonar.java.classpath.ClasspathForTest;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaResourceLocator;

public class DefaultJavaResourceLocator
implements JavaResourceLocator {
    private static final Logger LOG = Loggers.get(DefaultJavaResourceLocator.class);
    private final ClasspathForMain javaClasspath;
    private final ClasspathForTest javaTestClasspath;
    @VisibleForTesting
    Map<String, InputFile> resourcesByClass;

    public DefaultJavaResourceLocator(ClasspathForMain javaClasspath, ClasspathForTest javaTestClasspath) {
        this.javaClasspath = javaClasspath;
        this.javaTestClasspath = javaTestClasspath;
        this.resourcesByClass = new HashMap<String, InputFile>();
    }

    @Override
    public InputFile findResourceByClassName(String className) {
        String name = className.replace('.', '/');
        InputFile inputFile = this.resourcesByClass.get(name);
        if (inputFile == null) {
            LOG.debug("Class not found in resource cache : {}", (Object)className);
        }
        return inputFile;
    }

    private Collection<String> classKeys() {
        return new TreeSet<String>(this.resourcesByClass.keySet());
    }

    @Override
    public Collection<File> classFilesToAnalyze() {
        ArrayList<File> result = new ArrayList<File>();
        block0: for (String key : this.classKeys()) {
            String filePath = key + ".class";
            for (File binaryDir : this.javaClasspath.getBinaryDirs()) {
                File classFile = new File(binaryDir, filePath);
                if (!classFile.isFile()) continue;
                result.add(classFile);
                continue block0;
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<File> classpath() {
        return Collections.unmodifiableList(this.javaClasspath.getElements());
    }

    @Override
    public Collection<File> testClasspath() {
        return Collections.unmodifiableList(this.javaTestClasspath.getElements());
    }

    @Override
    public Collection<File> binaryDirs() {
        return Collections.unmodifiableList(this.javaClasspath.getBinaryDirs());
    }

    @Override
    public Collection<File> testBinaryDirs() {
        return Collections.unmodifiableList(this.javaTestClasspath.getBinaryDirs());
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        InputFile inputFile = context.getInputFile();
        JavaFilesCache javaFilesCache = new JavaFilesCache();
        javaFilesCache.scanFile(context);
        javaFilesCache.getClassNames().forEach(className -> this.resourcesByClass.put((String)className, inputFile));
    }
}

