/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.caching;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.caching.DummyCache;
import org.sonar.java.caching.JavaReadCacheImpl;
import org.sonar.java.caching.JavaWriteCacheImpl;
import org.sonar.plugins.java.api.caching.CacheContext;
import org.sonar.plugins.java.api.caching.JavaReadCache;
import org.sonar.plugins.java.api.caching.JavaWriteCache;

public class CacheContextImpl
implements CacheContext {
    public static final String SONAR_CACHING_ENABLED_KEY = "sonar.java.caching.enabled";
    private static final Logger LOGGER = Loggers.get(CacheContextImpl.class);
    private final boolean isCacheEnabled;
    private final JavaReadCache readCache;
    private final JavaWriteCache writeCache;

    private CacheContextImpl(boolean isCacheEnabled, JavaReadCache readCache, JavaWriteCache writeCache) {
        this.isCacheEnabled = isCacheEnabled;
        this.readCache = readCache;
        this.writeCache = writeCache;
    }

    public static CacheContextImpl of(@Nullable SensorContext context) {
        if (context != null) {
            try {
                boolean cacheEnabled = (context.config() == null ? Optional.empty() : context.config().getBoolean(SONAR_CACHING_ENABLED_KEY)).map(flag -> {
                    LOGGER.debug(() -> "Forcing caching behavior. Caching will be enabled: " + flag);
                    return flag;
                }).orElse(context.isCacheEnabled());
                LOGGER.trace(() -> "Caching is enabled: " + cacheEnabled);
                if (cacheEnabled) {
                    return new CacheContextImpl(true, new JavaReadCacheImpl(context.previousCache()), new JavaWriteCacheImpl(context.nextCache()));
                }
            }
            catch (NoSuchMethodError error) {
                LOGGER.debug(() -> String.format("Missing cache related method from sonar-plugin-api: %s.", error.getMessage()));
            }
        }
        DummyCache dummyCache = new DummyCache();
        return new CacheContextImpl(false, dummyCache, dummyCache);
    }

    @Override
    public boolean isCacheEnabled() {
        return this.isCacheEnabled;
    }

    @Override
    public JavaReadCache getReadCache() {
        return this.readCache;
    }

    @Override
    public JavaWriteCache getWriteCache() {
        return this.writeCache;
    }
}

